/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html An interface to an XML input stream.
 *
 * @if notclike @internal @endif
 */

public class XMLInputStream : IDisposable {
	private HandleRef swigCPtr;
	protected bool swigCMemOwn;
	
	internal XMLInputStream(IntPtr cPtr, bool cMemoryOwn)
	{
		swigCMemOwn = cMemoryOwn;
		swigCPtr    = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(XMLInputStream obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (XMLInputStream obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~XMLInputStream() {
    Dispose();
  }

  public virtual void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_XMLInputStream(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
    }
  }

  
/**
   * Creates a new XMLInputStream.
   *
   * @p content the source of the stream.
   *
   * @p isFile bool flag to indicate whether @p content is a file name.
   * If @c true, @p content is assumed to be the file from which the XML
   * content is to be read.  If @c false, @p content is taken to be a
   * string that @em is the content to be read.
   *
   * @p library the name of the parser library to use.
   *
   * @p errorLog the XMLErrorLog object to use.
   *
   * @if notcpp @htmlinclude warn-default-args-in-docs.html @endif
   */ /* libsbml-internal */ public
 XMLInputStream(string content, bool isFile, string library, XMLErrorLog errorLog) : this(libsbmlPINVOKE.new_XMLInputStream__SWIG_0(content, isFile, library, XMLErrorLog.getCPtr(errorLog)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new XMLInputStream.
   *
   * @p content the source of the stream.
   *
   * @p isFile bool flag to indicate whether @p content is a file name.
   * If @c true, @p content is assumed to be the file from which the XML
   * content is to be read.  If @c false, @p content is taken to be a
   * string that @em is the content to be read.
   *
   * @p library the name of the parser library to use.
   *
   * @p errorLog the XMLErrorLog object to use.
   *
   * @if notcpp @htmlinclude warn-default-args-in-docs.html @endif
   */ /* libsbml-internal */ public
 XMLInputStream(string content, bool isFile, string library) : this(libsbmlPINVOKE.new_XMLInputStream__SWIG_1(content, isFile, library), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new XMLInputStream.
   *
   * @p content the source of the stream.
   *
   * @p isFile bool flag to indicate whether @p content is a file name.
   * If @c true, @p content is assumed to be the file from which the XML
   * content is to be read.  If @c false, @p content is taken to be a
   * string that @em is the content to be read.
   *
   * @p library the name of the parser library to use.
   *
   * @p errorLog the XMLErrorLog object to use.
   *
   * @if notcpp @htmlinclude warn-default-args-in-docs.html @endif
   */ /* libsbml-internal */ public
 XMLInputStream(string content, bool isFile) : this(libsbmlPINVOKE.new_XMLInputStream__SWIG_2(content, isFile), true) {
  }

  
/**
   * Creates a new XMLInputStream.
   *
   * @p content the source of the stream.
   *
   * @p isFile bool flag to indicate whether @p content is a file name.
   * If @c true, @p content is assumed to be the file from which the XML
   * content is to be read.  If @c false, @p content is taken to be a
   * string that @em is the content to be read.
   *
   * @p library the name of the parser library to use.
   *
   * @p errorLog the XMLErrorLog object to use.
   *
   * @if notcpp @htmlinclude warn-default-args-in-docs.html @endif
   */ /* libsbml-internal */ public
 XMLInputStream(string content) : this(libsbmlPINVOKE.new_XMLInputStream__SWIG_3(content), true) {
  }

  
/**
   * Returns the encoding of the XML stream.
   *
   * @return the encoding of the XML stream.
   */ /* libsbml-internal */ public
 string getEncoding() {
    string ret = libsbmlPINVOKE.XMLInputStream_getEncoding(swigCPtr);
    return ret;
  }

  
/**
   * Returns the version of the XML stream.
   *
   * @return the version of the XML stream.
   */ /* libsbml-internal */ public
 string getVersion() {
    string ret = libsbmlPINVOKE.XMLInputStream_getVersion(swigCPtr);
    return ret;
  }

  
/**
   * Returns an XMLErrorLog which can be used to log XML parse errors and
   * other validation errors (and messages).
   *
   * @return an XMLErrorLog which can be used to log XML parse errors and
   * other validation errors (and messages).
   */ /* libsbml-internal */ public
 XMLErrorLog getErrorLog() {
    IntPtr cPtr = libsbmlPINVOKE.XMLInputStream_getErrorLog(swigCPtr);
    XMLErrorLog ret = (cPtr == IntPtr.Zero) ? null : new XMLErrorLog(cPtr, false);
    return ret;
  }

  
/**
   * Returns true if end of file (stream) has been reached, false
   * otherwise.
   *
   * @return true if end of file (stream) has been reached, false
   * otherwise.
   */ /* libsbml-internal */ public
 bool isEOF() {
    bool ret = libsbmlPINVOKE.XMLInputStream_isEOF(swigCPtr);
    return ret;
  }

  
/**
   * Returns true if a fatal error occurred while reading from this stream.
   *
   * @return true if a fatal error occurred while reading from this stream.
   */ /* libsbml-internal */ public
 bool isError() {
    bool ret = libsbmlPINVOKE.XMLInputStream_isError(swigCPtr);
    return ret;
  }

  
/**
   * Returns true if the stream is in a good state (i.e. isEOF() and
   * isError() are both false), false otherwise.
   *
   * @return true if the stream is in a good state (i.e. isEOF() and
   * isError() are both false), false otherwise.
   */ /* libsbml-internal */ public
 bool isGood() {
    bool ret = libsbmlPINVOKE.XMLInputStream_isGood(swigCPtr);
    return ret;
  }

  
/**
   * Consumes the next XMLToken and return it.
   *
   * @return the next XMLToken or EOF (XMLToken.isEOF() == true).
   */ /* libsbml-internal */ public
 XMLToken next() {
    XMLToken ret = new XMLToken(libsbmlPINVOKE.XMLInputStream_next(swigCPtr), true);
    return ret;
  }

  
/**
   * Returns the next XMLToken without consuming it.  A subsequent call to
   * either peek() or next() will return the same token.
   *
   * @return the next XMLToken or EOF (XMLToken.isEOF() == true).
   */ /* libsbml-internal */ public
 XMLToken peek() {
    XMLToken ret = new XMLToken(libsbmlPINVOKE.XMLInputStream_peek(swigCPtr), false);
    return ret;
  }

  
/**
   * Consume zero or more XMLTokens up to and including the corresponding
   * end XML element or EOF.
   */ /* libsbml-internal */ public
 void skipPastEnd(XMLToken element) {
    libsbmlPINVOKE.XMLInputStream_skipPastEnd(swigCPtr, XMLToken.getCPtr(element));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Consume zero or more XMLTokens up to but not including the next XML
   * element or EOF.
   */ /* libsbml-internal */ public
 void skipText() {
    libsbmlPINVOKE.XMLInputStream_skipText(swigCPtr);
  }

  
/**
   * Sets the XMLErrorLog this stream will use to log errors.
   *
   * @return integer value indicating success/failure of the
   * function.  @if clike The value is drawn from the
   * enumeration #OperationReturnValues_t. @endif The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   */ /* libsbml-internal */ public
 int setErrorLog(XMLErrorLog log) {
    int ret = libsbmlPINVOKE.XMLInputStream_setErrorLog(swigCPtr, XMLErrorLog.getCPtr(log));
    return ret;
  }

  
/**
   * Prints a string representation of the underlying token stream, for
   * debugging purposes.
   */ /* libsbml-internal */ public
 string toString() {
    string ret = libsbmlPINVOKE.XMLInputStream_toString(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 SBMLNamespaces getSBMLNamespaces() {
	SBMLNamespaces ret
	    = (SBMLNamespaces) libsbml.DowncastSBMLNamespaces(libsbmlPINVOKE.XMLInputStream_getSBMLNamespaces(swigCPtr), false);
	return ret;
}

  
/** */ /* libsbml-internal */ public
 void setSBMLNamespaces(SBMLNamespaces sbmlns) {
    libsbmlPINVOKE.XMLInputStream_setSBMLNamespaces(swigCPtr, SBMLNamespaces.getCPtr(sbmlns));
  }

}

}
