//------------------------------------------------------------------------------
// <auto-generated />
//
// This file was automatically generated by SWIG (http://www.swig.org).
// Version 3.0.12
//
// Do not make changes to this file unless you know what you are doing--modify
// the SWIG interface file instead.
//------------------------------------------------------------------------------

namespace libsbml {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html An SBML reaction between species in an SBML model.
 *
 * A @em reaction represents any transformation, transport or binding
 * process, typically a chemical reaction, that can change the quantity of
 * one or more species.  In SBML, a reaction is defined primarily in terms
 * of the participating reactants and products (and their corresponding
 * stoichiometries), along with optional modifier species, an optional rate
 * at which the reaction takes place, and optional parameters.
 *
 * As with other major objects in SBML, Reaction has a mandatory attribute,
 * 'id', used to give the reaction an identifier.  The identifier
 * must be a text string conforming to the identifer syntax permitted in
 * SBML.  In SBML Level&nbsp;2 and Level&nbsp;3, the reaction 'id'
 * identifier can be used in mathematical formulas elsewhere in an SBML
 * model to represent the rate of that reaction; this usage is explained
 * below.  Reaction also has an optional 'name' attribute, of type
 * @c string.  The 'id' and 'name' must be used according to the guidelines
 * described in the SBML specification.
 *
 * The species participating as reactants, products, and/or modifiers in a
 * reaction are declared using lists of SpeciesReference and/or
 * ModifierSpeciesReference instances stored in subelements
 * 'listOfReactants', 'listOfProducts' and 'listOfModifiers'.  Certain
 * restrictions are placed on the appearance of species in reaction
 * definitions:
 * <ul>
 * <li> The ability of a species to appear as a reactant or product of any
 * reaction in a model is governed by certain flags in that species'
 * definition; see the definition of Species for more information.
 *
 * <li> Any species appearing in the mathematical formula of the subelement
 * 'kineticLaw' (described below) of a Reaction must be declared in at
 * least one of that Reaction's lists of reactants, products, and/or
 * modifiers.  Put another way, it is an error for a reaction's kinetic law
 * formula to refer to species that have not been declared for that
 * reaction.
 *
 * <li> For SBML Levels 1, 2, and SBML Level&nbsp;3 Version&nbsp;1, a 
 * reaction definition can contain an empty list of reactants
 * <em>or</em> an empty list of products, but it must have at least one
 * reactant or product; in other words, a reaction without any reactant or
 * product species is not permitted.  (This restriction does not apply to
 * modifier species, which remain optional in all cases.)  In SBML 
 * Level&nbsp;3 Version&nbsp;2, this requirement was dropped, allowing 
 * the creation of reactions with neither reactants nor products.
 * </ul>
 * 
 * A reaction can contain up to one KineticLaw object in a subelement named
 * 'kineticLaw'.  It defines the speed at which the process defined by the
 * reaction takes place.  The description of KineticLaw provides more
 * details about its use.  Note that although the inclusion of a KineticLaw
 * object in an instance of a Reaction component is optional, there is no
 * useful default that can be substituted in place of a missing rate
 * expression in a reaction.  Moreover, a reaction's rate cannot be defined
 * in any other way in SBML---InitialAssignment, AssignmentRule,
 * RateRule, AlgebraicRule, Event, and other constructs in SBML cannot be
 * used to set the reaction rate separately.  Nevertheless, for some
 * modeling applications, reactions without any defined rate can be
 * perfectly acceptable.
 *
 * Reaction also has a boolean attribute named 'reversible' for indicating
 * whether the reaction is reversible.  This attribute is optional in SBML
 * Level&nbsp;2, with a default of @c true; it is mandatory in SBML
 * Level&nbsp;3 (with no default value).  To say that a reaction is @em
 * reversible is to say it can proceed in either the forward or the reverse
 * direction.  Although the reversibility of a reaction can sometimes be
 * deduced by inspecting its rate expression, this is not always the case,
 * especially for complicated expressions.  Moreover, the need in SBML to
 * allow rate expressions (i.e., KineticLaw) to be optional leads to the
 * need for a separate flag indicating reversibility.  Note that labeling a
 * reaction as irreversible is an assertion that the reaction always
 * proceeds in the given forward direction.  (Why else would it be flagged
 * as irreversible?)  This implies the rate expression in the KineticLaw
 * always has a non-negative value during simulations.  Software tools
 * could provide a means of optionally testing that this condition holds.
 * The presence of reversibility information in two places (i.e., the rate
 * expression and the 'reversible' attribute on Reaction) leaves open the
 * possibility that a model could contain contradictory information, but
 * the creation of such a model would be an error on the part of the
 * software generating it.
 *
 * The Reaction object class has another boolean attribute called 'fast'.
 * This attribute is optional in SBML Level&nbsp;2, with a default of
 * @c false; it is mandatory in SBML Level&nbsp;3 (with no default value).  
 * In SBML Level&nbsp;3 Version&nbsp;2, a value of @c true for the 'fast'
 * attribute is deprecated in favor of all reactions having a 'fast' value 
 * of @c false.  It
 * is used to indicate that a reaction occurs on a vastly faster time scale
 * than others in a system.  Readers are directed to the SBML Level&nbsp;2
 * Version&nbsp;4 specification, which provides more detail about the
 * conditions under which a reaction can be considered to be fast in this
 * sense.  SBML Level&nbsp;1
 * and Level&nbsp;2 Version&nbsp;1 incorrectly claimed that software tools
 * could ignore this attribute if they did not implement support for the
 * corresponding concept; however, further research in SBML has revealed
 * that this is not true, and 'fast' <em>cannot be ignored</em> if it is
 * set to @c true.  SBML Level&nbsp;2 Versions&nbsp;2&ndash;4 therefore
 * stipulate that if a model has any reactions with 'fast' set to @c true,
 * a software tool must be able to respect the attribute or else indicate
 * to the user that it does not have the capacity to do so.  Analysis
 * software cannot ignore the value of the 'fast' attribute because doing
 * so may lead to different results as compared to a software system that
 * <em>does</em> make use of 'fast'.
 *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'fast' attribute was 
 * removed.  All reactions are assumed to be equivalent to reactions
 * in previous levels/versions that have a 'fast' attribute value
 * of @c false.  Users should be aware that even for previous
 * levels/versions of the specification, 'fast' attribute values of
 * @c true never achieved widespread support, and many software
 * packages may ignore it.  To achieve the same or similar 
 * effects as setting the fast attribute to @c true for a given 
 * reaction, the KineticLaw attribute should be constructed to 
 * produce a value in the desired time scale, or else the 
 * reaction could be replaced with an AssignmentRule or 
 * AlgebraicRule.
 *
 *
 *
 * In SBML Level&nbsp;3, the Reaction object has an
 * additional optional attribute named 'compartment', whose value must be
 * the identifier of a compartment defined in the enclosing Model object.
 * The 'compartment' attribute can be used to indicate the compartment in
 * which the reaction is assumed to take place.  If the attribute is
 * present, its value must be the identifier of a Compartment object
 * defined in the enclosing Model object.  Similar to the 'reversible'
 * attribute, the value of the 'compartment' attribute has no direct impact
 * on the construction of mathematical equations for the SBML model.  When
 * a kinetic law is given for a reaction, the compartment location may
 * already be implicit in the kinetic law (although this cannot always be
 * guaranteed).  Nevertheless, software tools may find the 'compartment'
 * attribute value useful for such purposes as analyzing the structure of
 * the model, guiding the modeler in constructing correct rate formulas,
 * and visualization purposes.
 *
 * Readers are urged to read the SBML specification for more details about
 * the proper use of Reaction.
 * 
 * 
 * 
 */

public class Reaction : SBase {
	private HandleRef swigCPtr;
	
	internal Reaction(IntPtr cPtr, bool cMemoryOwn) : base(libsbmlPINVOKE.Reaction_SWIGUpcast(cPtr), cMemoryOwn)
	{
		//super(libsbmlPINVOKE.ReactionUpcast(cPtr), cMemoryOwn);
		swigCPtr = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(Reaction obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (Reaction obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~Reaction() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != global::System.IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_Reaction(swigCPtr);
        }
        swigCPtr = new global::System.Runtime.InteropServices.HandleRef(null, global::System.IntPtr.Zero);
      }
      global::System.GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  
/**
   * Creates a new Reaction using the given SBML @p level and @p version
   * values.
   *
   * @param level a long integer, the SBML Level to assign to this Reaction.
   *
   * @param version a long integer, the SBML Version to assign to this
   * Reaction.
   *
   *
 * @throws SBMLConstructorException
 * Thrown if the given @p level and @p version combination are invalid
 * or if this object is incompatible with the given level and version.
 *
 *
   *
   *
 * @note Attempting to add an object to an SBMLDocument having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * SBMLDocument), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
 *
 *
   */ public
 Reaction(long level, long version) : this(libsbmlPINVOKE.new_Reaction__SWIG_0(level, version), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new Reaction using the given SBMLNamespaces object
   * @p  sbmlns.
   *
   *
 * 
 * The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's SBMLNamespaces facilities is to create an
 * SBMLNamespaces object somewhere in a program once, then hand that object
 * as needed to object constructors that accept SBMLNamespaces as arguments.
 *
 *
   *
   * @param sbmlns an SBMLNamespaces object.
   *
   *
 * @throws SBMLConstructorException
 * Thrown if the given @p sbmlns is inconsistent or incompatible
 * with this object.
 *
 *
   *
   *
 * @note Attempting to add an object to an SBMLDocument having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * SBMLDocument), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
 *
 *
   */ public
 Reaction(SBMLNamespaces sbmlns) : this(libsbmlPINVOKE.new_Reaction__SWIG_1(SBMLNamespaces.getCPtr(sbmlns)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Copy constructor; creates a copy of this Reaction.
   *
   * @param orig the object to copy.
   */ public
 Reaction(Reaction orig) : this(libsbmlPINVOKE.new_Reaction__SWIG_2(Reaction.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates and returns a deep copy of this Reaction object.
   *
   * @return the (deep) copy of this Reaction object.
   */ public new
 Reaction clone() {
	Reaction ret = (Reaction) libsbml.DowncastSBase(libsbmlPINVOKE.Reaction_clone(swigCPtr), true);
	return ret;
}

  
/**
   * Returns the first child element found that has the given @p id in the
   * model-wide SId namespace, or @c null if no such object is found.
   *
   * @param id string representing the id of the object to find.
   *
   * @return pointer to the first element found with the given @p id.
   */ public new
 SBase getElementBySId(string id) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.Reaction_getElementBySId(swigCPtr, id), false);
	return ret;
}

  
/**
   * Returns the first child element it can find with the given @p metaid, or
   * @c null if no such object is found.
   *
   * @param metaid string representing the metaid of the object to find.
   *
   * @return pointer to the first element found with the given @p metaid.
   */ public new
 SBase getElementByMetaId(string metaid) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.Reaction_getElementByMetaId(swigCPtr, metaid), false);
	return ret;
}

  
/**
   *
 * Replaces all uses of a given @c SIdRef type attribute value with another
 * value.
 *
 *
 * 

 * In SBML, object identifiers are of a data type called <code>SId</code>.
 * In SBML Level&nbsp;3, an explicit data type called <code>SIdRef</code> was
 * introduced for attribute values that refer to <code>SId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to an identifier', but the effective
 * data type was the same as <code>SIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>SIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 *
 *
 *
 * This method works by looking at all attributes and (if appropriate)
 * mathematical formulas in MathML content, comparing the referenced
 * identifiers to the value of @p oldid.  If any matches are found, the
 * matching values are replaced with @p newid.  The method does @em not
 * descend into child elements.
 *
 * @param oldid the old identifier.
 * @param newid the new identifier.
 *
 *
   */ public new
 void renameSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.Reaction_renameSIdRefs(swigCPtr, oldid, newid);
  }

  
/**
   * Initializes the fields of this Reaction object to 'typical' default
   * values.
   *
   * The SBML Reaction component has slightly different aspects and
   * default attribute values in different SBML Levels and Versions.
   * This method sets the values to certain common defaults, based
   * mostly on what they are in SBML Level&nbsp;2.  Specifically:
   * 
   * @li Sets the 'reversible' attribute to @c true
   * @li Sets the 'fast' attribute to @c false
   * @li Marks the 'fast' attribute as @em not having been set for
   *     SBML Level&nbsp;2, but @em as having been set for
   *     SBML Level&nbsp;1 and SBML Level&nbsp;3.
   *
   *
 * @warning <span class='warning'>SBML definitions before SBML Level&nbsp;2
 * Version&nbsp;2 incorrectly indicated that software tools could ignore the
 * 'fast' attribute if they did not implement support for the corresponding
 * concept; however, further research in SBML has revealed that this is not
 * true, and 'fast' <em>cannot be ignored</em> if it is set to @c true.
 * Beginning with SBML Level&nbsp;2 Versions&nbsp;2, the SBML specifications
 * therefore stipulate that if a model has any reactions with 'fast' set to
 * @c true, a software tool must be able to respect the attribute or else
 * indicate to the user that it does not have the capacity to do so.  Readers
 * are directed to the SBML specifications, which provides more detail about
 * the conditions under which a reaction can be considered to be fast in this
 * sense.</span>
 *
   */ public
 void initDefaults() {
    libsbmlPINVOKE.Reaction_initDefaults(swigCPtr);
  }

  
/**
   * Returns the value of the 'id' attribute of this Reaction.
   *
   * @note Because of the inconsistent behavior of this function with 
   * respect to assignments and rules, it is now recommended to
   * use the getIdAttribute() function instead.
   *
   *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
   *
   * @return the id of this Reaction.
   *
   * @see getIdAttribute()
   * @see setIdAttribute(string sid)
   * @see isSetIdAttribute()
   * @see unsetIdAttribute()
   */ public new
 string getId() {
    string ret = libsbmlPINVOKE.Reaction_getId(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'name' attribute of this Reaction object.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 *
 * @return the name of this SBML object, or the empty string if not set or unsettable.
 *
 * @see getIdAttribute()
 * @see isSetName()
 * @see setName(string sid)
 * @see unsetName()
 * 
 *
   */ public new
 string getName() {
    string ret = libsbmlPINVOKE.Reaction_getName(swigCPtr);
    return ret;
  }

  
/**
   * Returns the KineticLaw object contained in this Reaction.
   * 
   * @return the KineticLaw instance.
   */ public
 KineticLaw getKineticLaw() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Reaction_getKineticLaw__SWIG_0(swigCPtr);
    KineticLaw ret = (cPtr == global::System.IntPtr.Zero) ? null : new KineticLaw(cPtr, false);
    return ret;
  }

  
/**
   * Returns the value of the 'reversible' attribute on the Reaction as a
   * boolean value.
   * 
   * @return the reversibility status of this Reaction.
   */ public
 bool getReversible() {
    bool ret = libsbmlPINVOKE.Reaction_getReversible(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'fast' attribute of this Reaction.
   * 
   *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'fast' attribute was 
 * removed.  All reactions are assumed to be equivalent to reactions
 * in previous levels/versions that have a 'fast' attribute value
 * of @c false.  Users should be aware that even for previous
 * levels/versions of the specification, 'fast' attribute values of
 * @c true never achieved widespread support, and many software
 * packages may ignore it.  To achieve the same or similar 
 * effects as setting the fast attribute to @c true for a given 
 * reaction, the KineticLaw attribute should be constructed to 
 * produce a value in the desired time scale, or else the 
 * reaction could be replaced with an AssignmentRule or 
 * AlgebraicRule.
 *
 *
   *
   * @return the 'fast' status of this Reaction.
   *
   *
 * @warning <span class='warning'>SBML definitions before SBML Level&nbsp;2
 * Version&nbsp;2 incorrectly indicated that software tools could ignore the
 * 'fast' attribute if they did not implement support for the corresponding
 * concept; however, further research in SBML has revealed that this is not
 * true, and 'fast' <em>cannot be ignored</em> if it is set to @c true.
 * Beginning with SBML Level&nbsp;2 Versions&nbsp;2, the SBML specifications
 * therefore stipulate that if a model has any reactions with 'fast' set to
 * @c true, a software tool must be able to respect the attribute or else
 * indicate to the user that it does not have the capacity to do so.  Readers
 * are directed to the SBML specifications, which provides more detail about
 * the conditions under which a reaction can be considered to be fast in this
 * sense.</span>
 *
   */ public
 bool getFast() {
    bool ret = libsbmlPINVOKE.Reaction_getFast(swigCPtr);
    return ret;
  }

  
/**
   * (SBML Level&nbsp;3 only) Returns the value of the 'compartment'
   * attribute on the Reaction.
   * 
   * @return the compartment of this Reaction.
   *
   * @note The 'compartment' attribute is available in SBML Level&nbsp;3,
   * but is not present on Reaction in lower Levels of
   * SBML.
   */ public
 string getCompartment() {
    string ret = libsbmlPINVOKE.Reaction_getCompartment(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Reaction's 'id' attribute is set.
   *
   *
 *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
 *
 * @return @c true if the 'id' attribute of this SBML object is
 * set, @c false otherwise.
 *
 * @note Because of the inconsistent behavior of this function with
 * respect to assignments and rules, it is recommended that callers
 * use isSetIdAttribute() instead.
 *
 * @see getIdAttribute()
 * @see setIdAttribute(string sid)
 * @see unsetIdAttribute()
 * @see isSetIdAttribute()
 *
 *
   */ public new
 bool isSetId() {
    bool ret = libsbmlPINVOKE.Reaction_isSetId(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Reaction's 'name' attribute is set.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 * 
 * @return @c true if the 'name' attribute of this SBML object is
 * set, @c false otherwise.
 *
 * @see getName()
 * @see setName(string sid)
 * @see unsetName()
 *
 *
   */ public new
 bool isSetName() {
    bool ret = libsbmlPINVOKE.Reaction_isSetName(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Reaction contains a kinetic law object.
   *
   * @return @c true if a KineticLaw is present in this Reaction,, @c false
   * otherwise.
   */ public
 bool isSetKineticLaw() {
    bool ret = libsbmlPINVOKE.Reaction_isSetKineticLaw(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if the value of
   * the 'fast' attribute on this Reaction is set.
   *
   *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'fast' attribute was 
 * removed.  All reactions are assumed to be equivalent to reactions
 * in previous levels/versions that have a 'fast' attribute value
 * of @c false.  Users should be aware that even for previous
 * levels/versions of the specification, 'fast' attribute values of
 * @c true never achieved widespread support, and many software
 * packages may ignore it.  To achieve the same or similar 
 * effects as setting the fast attribute to @c true for a given 
 * reaction, the KineticLaw attribute should be constructed to 
 * produce a value in the desired time scale, or else the 
 * reaction could be replaced with an AssignmentRule or 
 * AlgebraicRule.
 *
 *
   *
   * @return @c true if the 'fast' attribute is set, @c false otherwise.
   *
   *
 * @warning <span class='warning'>SBML definitions before SBML Level&nbsp;2
 * Version&nbsp;2 incorrectly indicated that software tools could ignore the
 * 'fast' attribute if they did not implement support for the corresponding
 * concept; however, further research in SBML has revealed that this is not
 * true, and 'fast' <em>cannot be ignored</em> if it is set to @c true.
 * Beginning with SBML Level&nbsp;2 Versions&nbsp;2, the SBML specifications
 * therefore stipulate that if a model has any reactions with 'fast' set to
 * @c true, a software tool must be able to respect the attribute or else
 * indicate to the user that it does not have the capacity to do so.  Readers
 * are directed to the SBML specifications, which provides more detail about
 * the conditions under which a reaction can be considered to be fast in this
 * sense.</span>
 *
   */ public
 bool isSetFast() {
    bool ret = libsbmlPINVOKE.Reaction_isSetFast(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Reaction's 'compartment' attribute is set.
   *
   * @return @c true if the 'compartment' attribute of this Reaction is
   * set, @c false otherwise.
   *
   * @note The 'compartment' attribute is available in SBML
   * Level&nbsp;3, but is not present on Reaction in
   * lower Levels of SBML.
   */ public
 bool isSetCompartment() {
    bool ret = libsbmlPINVOKE.Reaction_isSetCompartment(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Reaction's 'reversible' attribute is set.
   *
   * @return @c true if the 'reversible' attribute of this Reaction is
   * set, @c false otherwise.
   */ public
 bool isSetReversible() {
    bool ret = libsbmlPINVOKE.Reaction_isSetReversible(swigCPtr);
    return ret;
  }

  
/**
   * Sets the value of the 'id' attribute of this Reaction.
   *
   *
 * 
 * The string @p sid is copied.
 *
 *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
 * 
 * @param sid the string to use as the identifier of this object.
 *
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
 * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
 *
 * @see getIdAttribute()
 * @see setIdAttribute(string sid)
 * @see isSetIdAttribute()
 * @see unsetIdAttribute()
 * 
 *
   */ public new
 int setId(string sid) {
    int ret = libsbmlPINVOKE.Reaction_setId(swigCPtr, sid);
    return ret;
  }

  
/**
   * Sets the value of the 'name' attribute of this Reaction.
   *
   *
 * 
 *
 * The string in @p name is copied.
 *
 * @param name the new name for the SBML object.
 *
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
 *
 *
   */ public new
 int setName(string name) {
    int ret = libsbmlPINVOKE.Reaction_setName(swigCPtr, name);
    return ret;
  }

  
/**
   * Sets the 'kineticLaw' subelement of this Reaction to a copy of the
   * given KineticLaw object.
   *
   * @param kl the KineticLaw object to use.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
  */ public
 int setKineticLaw(KineticLaw kl) {
    int ret = libsbmlPINVOKE.Reaction_setKineticLaw(swigCPtr, KineticLaw.getCPtr(kl));
    return ret;
  }

  
/**
   * Sets the value of the 'reversible' attribute of this Reaction.
   *
   * @param value the value of the 'reversible' attribute.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   */ public
 int setReversible(bool value) {
    int ret = libsbmlPINVOKE.Reaction_setReversible(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the value of the 'fast' attribute of this Reaction.
   *
   *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'fast' attribute was 
 * removed.  All reactions are assumed to be equivalent to reactions
 * in previous levels/versions that have a 'fast' attribute value
 * of @c false.  Users should be aware that even for previous
 * levels/versions of the specification, 'fast' attribute values of
 * @c true never achieved widespread support, and many software
 * packages may ignore it.  To achieve the same or similar 
 * effects as setting the fast attribute to @c true for a given 
 * reaction, the KineticLaw attribute should be constructed to 
 * produce a value in the desired time scale, or else the 
 * reaction could be replaced with an AssignmentRule or 
 * AlgebraicRule.
 *
 *
   *
   * Calling this function with an argument of @c true for an
   * SBML Level&nbsp;3 Version&nbsp;2 Reaction will not set
   * the value, as the attribute does not exist for that level/version.
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   * @param value the value of the 'fast' attribute.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   *
 * @warning <span class='warning'>SBML definitions before SBML Level&nbsp;2
 * Version&nbsp;2 incorrectly indicated that software tools could ignore the
 * 'fast' attribute if they did not implement support for the corresponding
 * concept; however, further research in SBML has revealed that this is not
 * true, and 'fast' <em>cannot be ignored</em> if it is set to @c true.
 * Beginning with SBML Level&nbsp;2 Versions&nbsp;2, the SBML specifications
 * therefore stipulate that if a model has any reactions with 'fast' set to
 * @c true, a software tool must be able to respect the attribute or else
 * indicate to the user that it does not have the capacity to do so.  Readers
 * are directed to the SBML specifications, which provides more detail about
 * the conditions under which a reaction can be considered to be fast in this
 * sense.</span>
 *
   */ public
 int setFast(bool value) {
    int ret = libsbmlPINVOKE.Reaction_setFast(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the value of the 'compartment' attribute of this Reaction.
   *
   * The string @p sid is copied.  
   *
   * @param sid the string to use as the compartment of this Reaction.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @note The 'compartment' attribute is available in SBML
   * Level&nbsp;3, but is not present on Reaction in
   * lower Levels of SBML.
   */ public
 int setCompartment(string sid) {
    int ret = libsbmlPINVOKE.Reaction_setCompartment(swigCPtr, sid);
    return ret;
  }

  
/**
   * Unsets the value of the 'name' attribute of this Reaction.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 * 
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
 *
 * @see getName()
 * @see setName(string sid)
 * @see isSetName()
 *
 *
   */ public new
 int unsetName() {
    int ret = libsbmlPINVOKE.Reaction_unsetName(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'kineticLaw' subelement of this Reaction.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int unsetKineticLaw() {
    int ret = libsbmlPINVOKE.Reaction_unsetKineticLaw(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'fast' attribute of this Reaction.
   *
   *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'fast' attribute was 
 * removed.  All reactions are assumed to be equivalent to reactions
 * in previous levels/versions that have a 'fast' attribute value
 * of @c false.  Users should be aware that even for previous
 * levels/versions of the specification, 'fast' attribute values of
 * @c true never achieved widespread support, and many software
 * packages may ignore it.  To achieve the same or similar 
 * effects as setting the fast attribute to @c true for a given 
 * reaction, the KineticLaw attribute should be constructed to 
 * produce a value in the desired time scale, or else the 
 * reaction could be replaced with an AssignmentRule or 
 * AlgebraicRule.
 *
 *
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   *
 * @warning <span class='warning'>SBML definitions before SBML Level&nbsp;2
 * Version&nbsp;2 incorrectly indicated that software tools could ignore the
 * 'fast' attribute if they did not implement support for the corresponding
 * concept; however, further research in SBML has revealed that this is not
 * true, and 'fast' <em>cannot be ignored</em> if it is set to @c true.
 * Beginning with SBML Level&nbsp;2 Versions&nbsp;2, the SBML specifications
 * therefore stipulate that if a model has any reactions with 'fast' set to
 * @c true, a software tool must be able to respect the attribute or else
 * indicate to the user that it does not have the capacity to do so.  Readers
 * are directed to the SBML specifications, which provides more detail about
 * the conditions under which a reaction can be considered to be fast in this
 * sense.</span>
 *
   */ public
 int unsetFast() {
    int ret = libsbmlPINVOKE.Reaction_unsetFast(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'compartment' attribute of this Reaction.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @note The 'compartment' attribute is available in SBML
   * Level&nbsp;3, but is not present on Reaction in
   * lower Levels of SBML.
   */ public
 int unsetCompartment() {
    int ret = libsbmlPINVOKE.Reaction_unsetCompartment(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'reversible' attribute of this Reaction.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int unsetReversible() {
    int ret = libsbmlPINVOKE.Reaction_unsetReversible(swigCPtr);
    return ret;
  }

  
/**
   * Adds a given SpeciesReference object as a reactant in this Reaction.
   *
   * The SpeciesReference instance in @p sr is copied.
   *
   * @param sr a SpeciesReference object referring to a Species in the
   * enclosing Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 * 
   *
   * @see createReactant()
   */ public
 int addReactant(SpeciesReference sr) {
    int ret = libsbmlPINVOKE.Reaction_addReactant__SWIG_0(swigCPtr, SpeciesReference.getCPtr(sr));
    return ret;
  }

  
/**
   * Adds the given species as a reactant with the given stoichiometry
   *
   * @param species the species to be added as reactant.
   *
   * @param stoichiometry an optional parameter specifying the
   *        stoichiometry of the added reactant (defaulting to 1).
   *
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   *
   * @param constant an attribute specifying whether the species reference is
   *        constant or not (defaulting to true).
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 *
   *
   * @note the Species object itself is NOT added to the model
   *
   * @see createProduct()
   */ public
 int addReactant(Species species, double stoichiometry, string id, bool constant) {
    int ret = libsbmlPINVOKE.Reaction_addReactant__SWIG_1(swigCPtr, Species.getCPtr(species), stoichiometry, id, constant);
    return ret;
  }

  
/**
   * Adds the given species as a reactant with the given stoichiometry
   *
   * @param species the species to be added as reactant.
   *
   * @param stoichiometry an optional parameter specifying the
   *        stoichiometry of the added reactant (defaulting to 1).
   *
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   *
   * @param constant an attribute specifying whether the species reference is
   *        constant or not (defaulting to true).
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 *
   *
   * @note the Species object itself is NOT added to the model
   *
   * @see createProduct()
   */ public
 int addReactant(Species species, double stoichiometry, string id) {
    int ret = libsbmlPINVOKE.Reaction_addReactant__SWIG_2(swigCPtr, Species.getCPtr(species), stoichiometry, id);
    return ret;
  }

  
/**
   * Adds the given species as a reactant with the given stoichiometry
   *
   * @param species the species to be added as reactant.
   *
   * @param stoichiometry an optional parameter specifying the
   *        stoichiometry of the added reactant (defaulting to 1).
   *
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   *
   * @param constant an attribute specifying whether the species reference is
   *        constant or not (defaulting to true).
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 *
   *
   * @note the Species object itself is NOT added to the model
   *
   * @see createProduct()
   */ public
 int addReactant(Species species, double stoichiometry) {
    int ret = libsbmlPINVOKE.Reaction_addReactant__SWIG_3(swigCPtr, Species.getCPtr(species), stoichiometry);
    return ret;
  }

  
/**
   * Adds the given species as a reactant with the given stoichiometry
   *
   * @param species the species to be added as reactant.
   *
   * @param stoichiometry an optional parameter specifying the
   *        stoichiometry of the added reactant (defaulting to 1).
   *
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   *
   * @param constant an attribute specifying whether the species reference is
   *        constant or not (defaulting to true).
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 *
   *
   * @note the Species object itself is NOT added to the model
   *
   * @see createProduct()
   */ public
 int addReactant(Species species) {
    int ret = libsbmlPINVOKE.Reaction_addReactant__SWIG_4(swigCPtr, Species.getCPtr(species));
    return ret;
  }

  
/**
   * Adds a given SpeciesReference object as a product in this Reaction.
   *
   * The SpeciesReference instance in @p sr is copied.
   *
   * @param sr a SpeciesReference object referring to a Species in the
   * enclosing Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 * 
   *
   * @see createProduct()
   */ public
 int addProduct(SpeciesReference sr) {
    int ret = libsbmlPINVOKE.Reaction_addProduct__SWIG_0(swigCPtr, SpeciesReference.getCPtr(sr));
    return ret;
  }

  
/**
   * Adds the given species as a product with the given stoichiometry
   *
   * @param species the species to be added as product.
   *
   * @param stoichiometry an optional parameter specifying the
   *        stoichiometry of the added product (defaulting to 1).
   *
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   *
   * @param constant an attribute specifying whether the species reference is
   *        constant or not (defaulting to true).
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 *
   *
   * @note the Species object itself is NOT added to the model
   *
   * @see createProduct()
   */ public
 int addProduct(Species species, double stoichiometry, string id, bool constant) {
    int ret = libsbmlPINVOKE.Reaction_addProduct__SWIG_1(swigCPtr, Species.getCPtr(species), stoichiometry, id, constant);
    return ret;
  }

  
/**
   * Adds the given species as a product with the given stoichiometry
   *
   * @param species the species to be added as product.
   *
   * @param stoichiometry an optional parameter specifying the
   *        stoichiometry of the added product (defaulting to 1).
   *
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   *
   * @param constant an attribute specifying whether the species reference is
   *        constant or not (defaulting to true).
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 *
   *
   * @note the Species object itself is NOT added to the model
   *
   * @see createProduct()
   */ public
 int addProduct(Species species, double stoichiometry, string id) {
    int ret = libsbmlPINVOKE.Reaction_addProduct__SWIG_2(swigCPtr, Species.getCPtr(species), stoichiometry, id);
    return ret;
  }

  
/**
   * Adds the given species as a product with the given stoichiometry
   *
   * @param species the species to be added as product.
   *
   * @param stoichiometry an optional parameter specifying the
   *        stoichiometry of the added product (defaulting to 1).
   *
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   *
   * @param constant an attribute specifying whether the species reference is
   *        constant or not (defaulting to true).
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 *
   *
   * @note the Species object itself is NOT added to the model
   *
   * @see createProduct()
   */ public
 int addProduct(Species species, double stoichiometry) {
    int ret = libsbmlPINVOKE.Reaction_addProduct__SWIG_3(swigCPtr, Species.getCPtr(species), stoichiometry);
    return ret;
  }

  
/**
   * Adds the given species as a product with the given stoichiometry
   *
   * @param species the species to be added as product.
   *
   * @param stoichiometry an optional parameter specifying the
   *        stoichiometry of the added product (defaulting to 1).
   *
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   *
   * @param constant an attribute specifying whether the species reference is
   *        constant or not (defaulting to true).
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 *
   *
   * @note the Species object itself is NOT added to the model
   *
   * @see createProduct()
   */ public
 int addProduct(Species species) {
    int ret = libsbmlPINVOKE.Reaction_addProduct__SWIG_4(swigCPtr, Species.getCPtr(species));
    return ret;
  }

  
/**
   * Adds a given ModifierSpeciesReference object as a product in this
   * Reaction.
   *
   * The ModifierSpeciesReference instance in @p msr is copied.
   *
   * @param msr a ModifierSpeciesReference object referring to a Species in
   * the enclosing Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 * 
   *
   * @see createModifier()
   */ public
 int addModifier(ModifierSpeciesReference msr) {
    int ret = libsbmlPINVOKE.Reaction_addModifier__SWIG_0(swigCPtr, ModifierSpeciesReference.getCPtr(msr));
    return ret;
  }

  
/**
   * Adds the given species as a modifier to this reaction
   *
   * @param species the species to be added as modifier.
   *
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 *
   *
   * @note the Species object itself is NOT added to the model
   *
   * @see createModifier()
   */ public
 int addModifier(Species species, string id) {
    int ret = libsbmlPINVOKE.Reaction_addModifier__SWIG_1(swigCPtr, Species.getCPtr(species), id);
    return ret;
  }

  
/**
   * Adds the given species as a modifier to this reaction
   *
   * @param species the species to be added as modifier.
   *
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 *
   *
   * @note the Species object itself is NOT added to the model
   *
   * @see createModifier()
   */ public
 int addModifier(Species species) {
    int ret = libsbmlPINVOKE.Reaction_addModifier__SWIG_2(swigCPtr, Species.getCPtr(species));
    return ret;
  }

  
/**
   * Creates a new SpeciesReference, adds it to this Reaction's list of
   * reactants, and returns it.
   *
   * @return a new SpeciesReference object.
   */ public
 SpeciesReference createReactant() {
	SpeciesReference ret
	    = (SpeciesReference) libsbml.DowncastSBase(libsbmlPINVOKE.Reaction_createReactant(swigCPtr), false);
	return ret;
}

  
/**
   * Creates a new SpeciesReference, adds it to this Reaction's list of
   * products, and returns it.
   *
   * @return a new SpeciesReference object.
   */ public
 SpeciesReference createProduct() {
	SpeciesReference ret
	    = (SpeciesReference) libsbml.DowncastSBase(libsbmlPINVOKE.Reaction_createProduct(swigCPtr), false);
	return ret;
}

  
/**
   * Creates a new ModifierSpeciesReference, adds it to this Reaction's
   * list of modifiers and returns it.
   *
   * @return a new ModifierSpeciesReference object.
   */ public
 ModifierSpeciesReference createModifier() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Reaction_createModifier(swigCPtr);
    ModifierSpeciesReference ret = (cPtr == global::System.IntPtr.Zero) ? null : new ModifierSpeciesReference(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new KineticLaw object, installs it as this Reaction's
   * 'kineticLaw' subelement, and returns it.
   *
   * If this Reaction had a previous KineticLaw, it will be destroyed.
   *
   * @return the new KineticLaw object.
   */ public
 KineticLaw createKineticLaw() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Reaction_createKineticLaw(swigCPtr);
    KineticLaw ret = (cPtr == global::System.IntPtr.Zero) ? null : new KineticLaw(cPtr, false);
    return ret;
  }

  
/**
   * Returns the list of reactants in this Reaction object.
   * 
   * @return the ListOfSpeciesReferences containing the references to the
   * species acting as reactants in this reaction.
   */ public
 ListOfSpeciesReferences getListOfReactants() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Reaction_getListOfReactants__SWIG_0(swigCPtr);
    ListOfSpeciesReferences ret = (cPtr == global::System.IntPtr.Zero) ? null : new ListOfSpeciesReferences(cPtr, false);
    return ret;
  }

  
/**
   * Returns the list of products in this Reaction object.
   * 
   * @return the ListOfSpeciesReferences containing the references to the
   * species acting as products in this reaction.
   */ public
 ListOfSpeciesReferences getListOfProducts() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Reaction_getListOfProducts__SWIG_0(swigCPtr);
    ListOfSpeciesReferences ret = (cPtr == global::System.IntPtr.Zero) ? null : new ListOfSpeciesReferences(cPtr, false);
    return ret;
  }

  
/**
   * Returns the list of modifiers in this Reaction object.
   * 
   * @return the ListOfSpeciesReferences containing the references to the
   * species acting as modifiers in this reaction.
   */ public
 ListOfSpeciesReferences getListOfModifiers() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Reaction_getListOfModifiers__SWIG_0(swigCPtr);
    ListOfSpeciesReferences ret = (cPtr == global::System.IntPtr.Zero) ? null : new ListOfSpeciesReferences(cPtr, false);
    return ret;
  }

  
/**
   * Returns the nth reactant species (as a SpeciesReference object) in 
   * the list of reactants in this Reaction.
   *
   * Callers should first call getNumReactants() to find out how many
   * reactants there are, to avoid using an invalid index number.
   *
   * @param n the index of the reactant sought.
   * 
   * @return the nth reactant (as a SpeciesReference object) of this
   * Reaction.
   * If the index @p n is invalid, @c null is returned.
   */ public
 SpeciesReference getReactant(long n) {
	SpeciesReference ret
	    = (SpeciesReference) libsbml.DowncastSBase(libsbmlPINVOKE.Reaction_getReactant__SWIG_0(swigCPtr, n), false);
	return ret;
}

  
/**
   * Returns the reactant species (as a SpeciesReference object) having 
   * a specific identifier in this Reaction.
   *
   * @param species the identifier of the reactant Species ('species' 
   * attribute of the reactant SpeciesReference object).
   *
   * @return a SpeciesReference object, or @c null if no species with the
   * given identifier @p species appears as a reactant in this Reaction.
   */ public
 SpeciesReference getReactant(string species) {
	SpeciesReference ret
	    = (SpeciesReference) libsbml.DowncastSBase(libsbmlPINVOKE.Reaction_getReactant__SWIG_2(swigCPtr, species), false);
	return ret;
}

  
/**
   * Returns the nth product species (as a SpeciesReference object) in 
   * the list of products in this Reaction.
   *
   * Callers should first call getNumProducts() to find out how many
   * products there are, to avoid using an invalid index number.
   *
   * @param n the index of the product sought.
   * 
   * @return the nth product (as a SpeciesReference object) of this
   * Reaction.
   * If the index @p n is invalid, @c null is returned.
   */ public
 SpeciesReference getProduct(long n) {
	SpeciesReference ret
	    = (SpeciesReference) libsbml.DowncastSBase(libsbmlPINVOKE.Reaction_getProduct__SWIG_0(swigCPtr, n), false);
	return ret;
}

  
/**
   * Returns the product species (as a SpeciesReference object) having 
   * a specific identifier in this Reaction.
   *
   * @param species the identifier of the product Species ('species'
   * attribute of the product SpeciesReference object).
   *
   * @return a SpeciesReference object, or @c null if no species with the
   * given identifier @p species appears as a product in this Reaction.
   */ public
 SpeciesReference getProduct(string species) {
	SpeciesReference ret
	    = (SpeciesReference) libsbml.DowncastSBase(libsbmlPINVOKE.Reaction_getProduct__SWIG_2(swigCPtr, species), false);
	return ret;
}

  
/**
   * Returns the nth modifier species (as a ModifierSpeciesReference object) 
   * in the list of modifiers of this Reaction.
   *
   * Callers should first call getNumModifiers() to find out how many
   * modifiers there are, to avoid using an invalid index number.
   *
   * @param n the index of the modifier species sought.
   * 
   * @return the nth modifier (as a ModifierSpeciesReference object) of
   * this Reaction.
   * If the index @p n is invalid, @c null is returned.
   */ public
 ModifierSpeciesReference getModifier(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Reaction_getModifier__SWIG_0(swigCPtr, n);
    ModifierSpeciesReference ret = (cPtr == global::System.IntPtr.Zero) ? null : new ModifierSpeciesReference(cPtr, false);
    return ret;
  }

  
/**
   * Returns the modifier species (as a ModifierSpeciesReference object) 
   * having a specific identifier in this Reaction.
   *
   * @param species the identifier of the modifier Species ('species' 
   * attribute of the ModifierSpeciesReference object).
   *
   * @return a ModifierSpeciesReference object, or @c null if no species with
   * the given identifier @p species appears as a modifier in this
   * Reaction.
   */ public
 ModifierSpeciesReference getModifier(string species) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Reaction_getModifier__SWIG_2(swigCPtr, species);
    ModifierSpeciesReference ret = (cPtr == global::System.IntPtr.Zero) ? null : new ModifierSpeciesReference(cPtr, false);
    return ret;
  }

  
/**
   * Returns the number of reactant species in this Reaction.
   * 
   * @return the number of reactants in this Reaction.
   */ public
 long getNumReactants() { return (long)libsbmlPINVOKE.Reaction_getNumReactants(swigCPtr); }

  
/**
   * Returns the number of product species in this Reaction.
   * 
   * @return the number of products in this Reaction.
   */ public
 long getNumProducts() { return (long)libsbmlPINVOKE.Reaction_getNumProducts(swigCPtr); }

  
/**
   * Returns the number of modifier species in this Reaction.
   * 
   * @return the number of modifiers in this Reaction.
   */ public
 long getNumModifiers() { return (long)libsbmlPINVOKE.Reaction_getNumModifiers(swigCPtr); }

  
/**
   * Removes the nth reactant species (SpeciesReference object) in the list of 
   * reactants in this Reaction and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   * The caller should first call getNumReactants() to find out how many
   * reactants there are, to avoid using an invalid index number.
   *
   * @param n the index of the reactant SpeciesReference object to remove.
   *
   * @return the removed reactant SpeciesReference object, or @c null if the 
   * given index is out of range.
   */ public
 SpeciesReference removeReactant(long n) {
	SpeciesReference ret
	    = (SpeciesReference) libsbml.DowncastSBase(libsbmlPINVOKE.Reaction_removeReactant__SWIG_0(swigCPtr, n), true);
	return ret;
}

  
/**
   * Removes the reactant species (SpeciesReference object) having the given  
   * 'species' attribute in this Reaction and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param species the 'species' attribute of the reactant SpeciesReference 
   * object.
   *
   * @return the removed reactant SpeciesReference object, or @c null if no 
   * reactant SpeciesReference object with the given 'species' attribute 
   * @p species exists in this Reaction.
   */ public
 SpeciesReference removeReactant(string species) {
	SpeciesReference ret
	    = (SpeciesReference) libsbml.DowncastSBase(libsbmlPINVOKE.Reaction_removeReactant__SWIG_1(swigCPtr, species), true);
	return ret;
}

  
/**
   * Removes the nth product species (SpeciesReference object) in the list of 
   * products in this Reaction and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   * The caller should first call getNumProducts() to find out how many
   * products there are, to avoid using an invalid index number.
   *
   * @param n the index of the product SpeciesReference object to remove.
   *
   * @return the removed product SpeciesReference object, or @c null if the 
   * given index is out of range.
   */ public
 SpeciesReference removeProduct(long n) {
	SpeciesReference ret
	    = (SpeciesReference) libsbml.DowncastSBase(libsbmlPINVOKE.Reaction_removeProduct__SWIG_0(swigCPtr, n), true);
	return ret;
}

  
/**
   * Removes the product species (SpeciesReference object) having the given  
   * 'species' attribute in this Reaction and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param species the 'species' attribute of the product SpeciesReference 
   * object.
   *
   * @return the removed product SpeciesReference object, or @c null if no 
   * product SpeciesReference object with the given 'species' attribute 
   * @p species exists in this Reaction.
   */ public
 SpeciesReference removeProduct(string species) {
	SpeciesReference ret
	    = (SpeciesReference) libsbml.DowncastSBase(libsbmlPINVOKE.Reaction_removeProduct__SWIG_1(swigCPtr, species), true);
	return ret;
}

  
/**
   * Removes the nth modifier species (ModifierSpeciesReference object) in 
   * the list of  modifiers in this Reaction and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   * The caller should first call getNumModifiers() to find out how many
   * modifiers there are, to avoid using an invalid index number.
   *
   * @param n the index of the ModifierSpeciesReference object to remove.
   *
   * @return the removed ModifierSpeciesReference object, or @c null if the 
   * given index is out of range.
   */ public
 ModifierSpeciesReference removeModifier(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Reaction_removeModifier__SWIG_0(swigCPtr, n);
    ModifierSpeciesReference ret = (cPtr == global::System.IntPtr.Zero) ? null : new ModifierSpeciesReference(cPtr, true);
    return ret;
  }

  
/**
   * Removes the modifier species (ModifierSpeciesReference object) having 
   * the given 'species' attribute in this Reaction and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param species the 'species' attribute of the ModifierSpeciesReference 
   * object.
   *
   * @return the removed ModifierSpeciesReference object, or @c null if no 
   * ModifierSpeciesReference object with the given 'species' attribute @p 
   * species exists in this Reaction.
   */ public
 ModifierSpeciesReference removeModifier(string species) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Reaction_removeModifier__SWIG_1(swigCPtr, species);
    ModifierSpeciesReference ret = (cPtr == global::System.IntPtr.Zero) ? null : new ModifierSpeciesReference(cPtr, true);
    return ret;
  }

  public override void connectToChild() {
    libsbmlPINVOKE.Reaction_connectToChild(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public new
 void enablePackageInternal(string pkgURI, string pkgPrefix, bool flag) {
    libsbmlPINVOKE.Reaction_enablePackageInternal(swigCPtr, pkgURI, pkgPrefix, flag);
  }

  
/** */ /* libsbml-internal */ public new
 void updateSBMLNamespace(string package, long level, long version) {
    libsbmlPINVOKE.Reaction_updateSBMLNamespace(swigCPtr, package, level, version);
  }

  
/**
   * Returns the libSBML type code for this SBML object.
   * 
   *
 * 
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * @if clike The set of possible type codes for core elements is defined in
 * the enumeration #SBMLTypeCode_t, and in addition, libSBML plug-ins for
 * SBML Level&nbsp;3 packages define their own extra enumerations of type
 * codes (e.g., #SBMLLayoutTypeCode_t for the Level&nbsp;3 Layout
 * package).@endif@if java In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.  @endif@if python In the Python language
 * interface for libSBML, the type codes are defined as static integer
 * constants in the interface class @link libsbml@endlink.@endif@if csharp In
 * the C# language interface for libSBML, the type codes are defined as
 * static integer constants in the interface class
 * @link libsbmlcs.libsbml@endlink.@endif  Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the 
 * <code>@if conly SBase_getPackageName()
 * @else SBase::getPackageName()
 * @endif</code>
 * method on the object.
 *
 *
   *
   * @return the SBML type code for this object:
   * @link libsbml#SBML_REACTION SBML_REACTION@endlink (default).
   *
   *
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getTypeCode() and getPackageName()</strong>.</span>
 *
 *
   *
   * @see getElementName()
   * @see getPackageName()
   */ public new
 int getTypeCode() {
    int ret = libsbmlPINVOKE.Reaction_getTypeCode(swigCPtr);
    return ret;
  }

  
/**
   * Returns the XML element name of this object, which for Reaction, is
   * always @c 'reaction'.
   * 
   * @return the name of this element, i.e., @c 'reaction'.
   */ public new
 string getElementName() {
    string ret = libsbmlPINVOKE.Reaction_getElementName(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if all the required attributes for this
   * Reaction object have been set.
   *
   * The required attributes for a Reaction object are:
   * @li 'id' (or 'name' in SBML Level&nbsp;1)
   * @li 'fast' (in Level&nbsp;3 Version&nbsp;1 only, where it is defined as a required attribute)
   * @li 'reversible' (in Level&nbsp;3 only, where it is defined as a required attribute)
   *
   * @return @c true if the required attributes have been set, @c false
   * otherwise.
   */ public new
 bool hasRequiredAttributes() {
    bool ret = libsbmlPINVOKE.Reaction_hasRequiredAttributes(swigCPtr);
    return ret;
  }

}

}
