import pycountry


class Countries(object):
    AFGHANISTAN = 'af'
    ALAND_ISLANDS = 'ax'
    ALBANIA = 'al'
    ALGERIA = 'dz'
    AMERICAN_SAMOA = 'as'
    ANDORRA = 'ad'
    ANGOLA = 'ao'
    ANGUILLA = 'ai'
    ANTARCTICA = 'aq'
    ANTIGUA_AND_BARBUDA = 'ag'
    ARGENTINA = 'ar'
    ARMENIA = 'am'
    ARUBA = 'aw'
    AUSTRALIA = 'au'
    AUSTRIA = 'at'
    AZERBAIJAN = 'az'
    BAHAMAS = 'bs'
    BAHRAIN = 'bh'
    BANGLADESH = 'bd'
    BARBADOS = 'bb'
    BELARUS = 'by'
    BELGIUM = 'be'
    BELIZE = 'bz'
    BENIN = 'bj'
    BERMUDA = 'bm'
    BHUTAN = 'bt'
    BOLIVIA = 'bo'
    BONAIRE = 'bq'
    BOSNIA_AND_HERZEGOVINA = 'bq'
    BOTSWANA = 'bw'
    BOUVET_ISLAND = 'bv'
    BRAZIL = 'br'
    BRITISH_INDIAN_OCEAN_TERRITORY = 'io'
    BRITISH_VIRGIN_ISLANDS = 'vg'
    BRUNEI_DARUSSALAM = 'bn'
    BULGARIA = 'bg'
    BURKINA_FASO = 'bf'
    BURUNDI = 'bi'
    CAMBODIA = 'kh'
    CAMEROON = 'cm'
    CANADA = 'ca'
    CAPE_VERDE = 'cv'
    CAYMAN_ISLANDS = 'ky'
    CENTRAL_AFRICAN_REPUBLIC = 'cf'
    CHAD = 'td'
    CHILE = 'cl'
    CHINA = 'cn'
    CHRISTMAS_ISLAND = 'cx'
    COCOS_KEELING_ISLANDS = 'cc'
    COLOMBIA = 'co'
    COMOROS = 'km'
    COOK_ISLANDS = 'ck'
    COSTA_RICA = 'cr'
    COTE_DIVOIRE = 'ci'
    CROATIA = 'hr'
    CUBA = 'cu'
    CURACAO = 'cw'
    CYPRUS = 'cy'
    CZECH_REPUBLIC = 'cz'
    DENMARK = 'dk'
    DEMOCRATIC_REPUBLIC_OF_THE_CONGO = 'cd'
    DJIBOUTI = 'dj'
    DOMINICA = 'dm'
    DOMINICAN_REPUBLIC = 'do'
    ECUADOR = 'ec'
    EGYPT = 'eg'
    EL_SALVADOR = 'sv'
    EQUATORIAL_GUINEA = 'gq'
    ERITREA = 'er'
    ESTONIA = 'ee'
    ETHIOPIA = 'et'
    FALKLAND_ISLANDS_MALVINAS = 'fk'
    FAROE_ISLANDS = 'fo'
    FEDERATED_STATES_OF_MICRONESIA = 'fm'
    FIJI = 'fj'
    FINLAND = 'fi'
    FRANCE = 'fr'
    FRENCH_GUIANA = 'gf'
    FRENCH_POLYNESIA = 'pf'
    FRENCH_SOUTHERN_TERRITORIES = 'tf'
    GABON = 'ga'
    GAMBIA = 'gm'
    GEORGIA = 'ge'
    GERMANY = 'de'
    GHANA = 'gh'
    GIBRALTAR = 'gi'
    GREECE = 'gr'
    GREENLAND = 'gl'
    GRENADA = 'gd'
    GUADELOUPE = 'gp'
    GUAM = 'gu'
    GUATEMALA = 'gt'
    GUERNSEY = 'gg'
    GUINEA = 'gn'
    GUINEA_BISSAU = 'gw'
    GUYANA = 'gy'
    HAITI = 'ht'
    HEARD_ISLAND_AND_MCDONALD_ISLANDS = 'hm'
    HONDURAS = 'hn'
    HONG_KONG = 'hk'
    HUNGARY = 'hu'
    ICELAND = 'is'
    INDIA = 'in'
    INDONESIA = 'id'
    IRAN = 'ir'
    IRAQ = 'iq'
    IRELAND = 'ie'
    ISLE_OF_MAN = 'im'
    ISRAEL = 'il'
    ITALY = 'it'
    JAMAICA = 'jm'
    JAPAN = 'jp'
    JERSEY = 'je'
    JORDAN = 'jo'
    KAZAKHSTAN = 'kz'
    KENYA = 'ke'
    KIRIBATI = 'ki'
    KUWAIT = 'kw'
    KYRGYZSTAN = 'kg'
    LAOS = 'la'
    LATVIA = 'lv'
    LEBANON = 'lb'
    LESOTHO = 'ls'
    LIBERIA = 'lr'
    LIBYA = 'ly'
    LIECHTENSTEIN = 'li'
    LITHUANIA = 'lt'
    LUXEMBOURG = 'lu'
    MACAO = 'mo'
    MACEDONIA = 'mk'
    MADAGASCAR = 'mg'
    MALAWI = 'mw'
    MALAYSIA = 'my'
    MALDIVES = 'mv'
    MALI = 'ml'
    MALTA = 'mt'
    MARSHALL_ISLANDS = 'mh'
    MARTINIQUE = 'mq'
    MAURITANIA = 'mr'
    MAURITIUS = 'mu'
    MAYOTTE = 'yt'
    MEXICO = 'mx'
    MOLDOVA = 'md'
    MONACO = 'mc'
    MONGOLIA = 'mn'
    MONTENEGRO = 'me'
    MONTSERRAT = 'ms'
    MOROCCO = 'ma'
    MOZAMBIQUE = 'mz'
    MYANMAR = 'mm'
    NAMIBIA = 'na'
    NAURU = 'nr'
    NEPAL = 'np'
    NETHERLANDS = 'nl'
    NEW_CALEDONIA = 'nc'
    NEW_ZEALAND = 'nz'
    NICARAGUA = 'ni'
    NIGER = 'ne'
    NIGERIA = 'ng'
    NIUE = 'nu'
    NORFOLK_ISLAND = 'nf'
    NORTH_KOREA = 'kp'
    NORTHERN_MARIANA_ISLANDS = 'mp'
    NORWAY = 'no'
    OMAN = 'om'
    PAKISTAN = 'pk'
    PALAU = 'pw'
    PALESTINE = 'ps'
    PANAMA = 'pa'
    PAPUA_NEW_GUINEA = 'pg'
    PARAGUAY = 'py'
    PERU = 'pe'
    PHILIPPINES = 'ph'
    PITCAIRN_ISLANDS = 'pn'
    POLAND = 'pl'
    PORTUGAL = 'pt'
    PUERTO_RICO = 'pr'
    QATAR = 'qa'
    REPUBLIC_OF_CONGO = 'cg'
    REUNION = 're'
    ROMANIA = 'ro'
    RUSSIA = 'ru'
    RWANDA = 'rw'
    SAINT_BARTHELEMY = 'bl'
    SAINT_HELENA_ASCENSION_AND_TRISTAN_DA_CUNHA = 'sh'
    SAINT_KITTS_AND_NEVIS = 'kn'
    SAINT_LUCIA = 'lc'
    SAINT_MARTIN = 'mf'
    SAINT_PIERRE_AND_MIQUELON = 'pm'
    SAINT_VINCENT_AND_THE_GRENADINES = 'vc'
    SAMOA = 'ws'
    SAN_MARINO = 'sm'
    SAO_TOME_AND_PRINCIPE = 'st'
    SAUDI_ARABIA = 'sa'
    SENEGAL = 'sn'
    SERBIA = 'rs'
    SEYCHELLES = 'sc'
    SIERRA_LEONE = 'sl'
    SINGAPORE = 'sg'
    SINT_MAARTEN = 'sx'
    SLOVAKIA = 'sk'
    SLOVENIA = 'si'
    SOLOMON_ISLANDS = 'sb'
    SOMALIA = 'so'
    SOUTH_AFRICA = 'za'
    SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS = 'gs'
    SOUTH_KOREA = 'kr'
    SOUTH_SUDAN = 'ss'
    SPAIN = 'es'
    SRI_LANKA = 'lk'
    SUDAN = 'sd'
    SURINAME = 'sr'
    SVALBARD_AND_JAN_MAYEN = 'sj'
    SWAZILAND = 'sz'
    SWEDEN = 'se'
    SWITZERLAND = 'ch'
    SYRIA = 'sy'
    TAIWAN = 'tw'
    TAJIKISTAN = 'tj'
    TANZANIA = 'tz'
    THAILAND = 'th'
    TIMOR_LESTE = 'tl'
    TOGO = 'tg'
    TOKELAU = 'tk'
    TONGA = 'to'
    TRINIDAD_AND_TOBAGO = 'tt'
    TUNISIA = 'tn'
    TURKEY = 'tr'
    TURKMENISTAN = 'tm'
    TURKS_AND_CAICOS_ISLANDS = 'tc'
    TUVALU = 'tv'
    UGANDA = 'ug'
    UKRAINE = 'ua'
    UNITED_ARAB_EMIRATES = 'ae'
    UNITED_KINGDOM = 'gb'
    UNITED_STATES = 'us'
    UNITED_STATES_MINOR_OUTLYING_ISLANDS = 'um'
    URUGUAY = 'uy'
    US_VIRGIN_ISLANDS = 'vi'
    UZBEKISTAN = 'uz'
    VANUATU = 'vu'
    VATICAN = 'va'
    VENEZUELA = 've'
    VIETNAM = 'vn'
    WALLIS_AND_FUTUNA = 'wf'
    WESTERN_SAHARA = 'eh'
    YEMEN = 'ye'
    ZAMBIA = 'zm'
    ZIMBABWE = 'zw'

    FORMER_SOVIET_UNION_COUNTRIES = set([RUSSIA, UKRAINE, BELARUS, KAZAKHSTAN, AZERBAIJAN, KYRGYZSTAN, GEORGIA, UZBEKISTAN, ARMENIA, TAJIKISTAN, MOLDOVA, TURKMENISTAN, LATVIA, LITHUANIA, ESTONIA])
    CJK_COUNTRIES = set([CHINA, JAPAN, SOUTH_KOREA, TAIWAN, HONG_KONG, MACAO])

    all_country_iso_codes = set([c.alpha2.lower() for c in pycountry.countries])

    @classmethod
    def is_valid_country_code(cls, alpha2_code):
        return alpha2_code and alpha2_code.lower() in cls.all_country_iso_codes
