/* -*- pftp-c -*- */
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#if HAVE_STDLIB_H
# include <stdlib.h>
#endif
#if HAVE_STDIO_H
# include <stdio.h>
#endif
#if HAVE_INTTYPES_H
# include <inttypes.h>
#endif
#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

#include "pftp_que.h"

typedef struct que_item_s *que_item_t;

struct que_item_s {
    void *QueData;
    que_item_t pNext;
};

static que_item_t CreateQueItem(void *QD)
{
    que_item_t Obj = malloc(sizeof(struct que_item_s));
    Obj->QueData = QD;
    Obj->pNext = NULL;
    return Obj;
}

struct pftp_que_s {
    que_item_t pFirst;
    que_item_t pLast;
    int NrItems;
};

pftp_que_t pftp_CreateQue(void)
{
    pftp_que_t Obj = malloc(sizeof(struct pftp_que_s));
    Obj->pFirst = NULL;
    Obj->pLast = NULL;
    Obj->NrItems = 0;
    return Obj;
}

void pftp_FreeQue(pftp_que_t q)
{
    free(q);
}

void* pftp_deque(pftp_que_t Q)
{
    void *tmp = NULL;
    que_item_t old;

    if ((old = Q->pFirst)) {
	tmp = old->QueData;
	Q->pFirst = old->pNext;
	free(old);
	Q->NrItems--;
    }
    
    return tmp;
}

size_t pftp_queLength(pftp_que_t Q)
{
/*
    que_item_t cur = Q->pFirst;
    size_t ret = 0;

    while (cur) {
	ret++;
	cur = cur->pNext;
    }
*/
    return (size_t)Q->NrItems;
}

void* pftp_peek(pftp_que_t Q, size_t pos)
{
    que_item_t cur = Q->pFirst;
    
    while (cur && pos--)
	cur = cur->pNext;
    
    if (cur)
	return cur->QueData;
    else
	return NULL;
}

void pftp_addFirst(void *Item, pftp_que_t Q)
{
    que_item_t tmp = CreateQueItem(Item);
    if(Q->NrItems == 0)
	Q->pLast = tmp;
    
    tmp->pNext = Q->pFirst;
    Q->pFirst = tmp;
    (Q->NrItems)++;
}

void pftp_addLast(void *Item, pftp_que_t Q)
{
    que_item_t tmp = CreateQueItem(Item);
    if(Q->NrItems == 0)
	Q->pFirst = tmp;
    else
	Q->pLast->pNext = tmp;
    Q->pLast = tmp;
    Q->NrItems++;
}

void pftp_moveUp(int index, pftp_que_t Q)
{
    int I;
    que_item_t pCur, pTmp, pTmp2;

    if((Q->NrItems != 0 || Q->NrItems != 1) && 
       (index != 0 && index < Q->NrItems)) {
	pCur = Q->pFirst;
	if (index == 1) {
	    pTmp = pCur->pNext;
	    pCur->pNext = pTmp->pNext;
	    pTmp->pNext = pCur;
	    Q->pFirst = pTmp;
	} else {
	    for(I = 2; I < index; I++)
		pCur = pCur->pNext;	    
	    
	    pTmp = pCur->pNext;
	    pTmp2 = pTmp->pNext;
	    pCur->pNext = pTmp2;
	    pTmp->pNext = pTmp2->pNext;
	    pTmp2->pNext = pTmp;
	}
    }
}

void pftp_moveDown(int index, pftp_que_t Q)
{
    int I;
    que_item_t pCur, pTmp, pTmp2;
    
    if ((Q->NrItems != 1 || Q->NrItems != 0) && index < Q->NrItems-1) {
	pCur = Q->pFirst;
	for(I = 1; I < index; I++) 
	    pCur = pCur->pNext;	
	pTmp = pCur->pNext;
	if (index == 0) {
	    pCur->pNext = pTmp->pNext;
	    pTmp->pNext = pCur;
	    Q->pFirst = pTmp;
	} else {
	    pTmp2 = pTmp->pNext;
	    pCur->pNext = pTmp2;
	    pTmp->pNext = pTmp2->pNext;
	    pTmp2->pNext = pTmp;
	}
	
    }
}

void* pftp_delete(int index, pftp_que_t Q)
{
    int I;
    void* DeletedItem = NULL;
    que_item_t pCur, pTmp;
    if (Q->NrItems > 0 || index < Q->NrItems) {
	if (Q->NrItems == 1) {
	    DeletedItem = Q->pFirst->QueData;
	    free(Q->pFirst);
	    Q->pFirst = NULL;
	    Q->pLast = NULL;	    
	} else {
	    pCur = Q->pFirst;
	    for (I = 1; I < index; I++)
		pCur = pCur->pNext;
	    if (index == 0) {
		Q->pFirst = pCur->pNext;
		DeletedItem = pCur->QueData;
		free(pCur);
	    } else if (index == Q->NrItems -1) {
		DeletedItem = pCur->pNext->QueData;
		free(pCur->pNext);
		pCur->pNext = NULL;
	    } else {
		pTmp = pCur->pNext;
		pCur->pNext = pTmp->pNext;
		DeletedItem = pTmp->QueData;
		free(pTmp);
	    }
	}
	
	Q->NrItems--;
    }

    return DeletedItem;
}
