/* -*- pftp-c -*- */
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#if HAVE_STDIO_H
# include <stdio.h>
#endif
#if HAVE_STDLIB_H
# include <stdlib.h>
#endif
#if HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#if HAVE_STRING_H
# include <string.h>
#endif
#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

#include "getline.h"

#if !HAVE_GETLINE

ssize_t rpl_getline(char **line, size_t *line_len, FILE *stream)
{
    size_t _line_len = 0;
    char *_line = malloc(_line_len + 2);
    int ret;
    
    for (;;) {
	ret = fgetc(stream);
	if (ret == EOF) {
	    if (_line_len == 0) {
		free(_line);
		return -1;
	    } else {
		_line[++_line_len] = '\0';
		(*line_len) = _line_len + 1;
		(*line) = realloc((*line), (*line_len));
		memcpy((*line), _line, (*line_len));
		free(_line);
		return (ssize_t) _line_len;
	    }
	}
	_line[_line_len] = (char)(ret & 0xFF);
	if (_line[_line_len] == '\n') {
	    _line[++_line_len] = '\0';
	    (*line_len) = _line_len + 1;
	    (*line) = realloc((*line), (*line_len));
	    memcpy((*line), _line, (*line_len));
	    free(_line);
	    return (ssize_t) _line_len;
	}	
	_line_len++;
	_line = realloc(_line, _line_len + 2);
    }
}

#endif
