/* -*- pftp-c -*- */
#ifndef PFTPUTIL_COMM_H
#define PFTPUTIL_COMM_H

#ifndef LIBPFTPUTIL_API
# ifdef WIN32
#  include "w32-libpftputil.h"
# else
#  define LIBPFTPUTIL_API 
# endif
#endif

#include <pftp_comm.h>

#define PFTPUTIL_INITQUE (PFTPUTIL_BASE+0x001)
/* Ignores return value.
   param1: (size_t) number of items in que
   param2: NULL
*/
#define PFTPUTIL_UPDATEQUELENGTH (PFTPUTIL_BASE+0x002)
/* Ignores return value.
   param1: (size_t) number of items in que (Que_size + que_pos)
   param2: NULL
*/
#define PFTPUTIL_UPDATEQUE (PFTPUTIL_BASE+0x003)
/* Return: 0 => cancel que now. !0 => continue
   param1: (size_t) number of items left in que
   param2: (size_t) number of ok items since start
*/
#define PFTPUTIL_DONEQUE (PFTPUTIL_BASE+0x004)
/* Ignores return value.
   param1: (int) error : 0 => OK, !0 => Error
   param2: (size_t) skipped items
*/
#define PFTPUTIL_NEEDCURFTP (PFTPUTIL_BASE+0x005)
/* Return: 0  => OK, param2 contains pftp_server_t
           !0 => Error, param2 is null.
   param1: (const char *) ftp name
   param2: (pftp_server_t *) ftp control
*/
#define PFTPUTIL_ERROR (PFTPUTIL_BASE+0x006)
/* Ignores return.
   param1: (const char *)msg
   param2: NULL
*/

#endif /* PFTPUTIL_COMM_H */
