/* -*- pftp-c -*- */
#ifndef PFTPUTIL_H
#define PFTPUTIL_H

#ifndef LIBPFTPUTIL_API
# ifdef WIN32
#  include "w32-libpftputil.h"
# else
#  define LIBPFTPUTIL_API 
# endif
#endif

#include <pftp_settings.h>
#include <pftp_default.h>
#include <pftp.h>
#include "pftp_item.h"
#include "pftputil_comm.h"
#include "pftp_getconf.h"

LIBPFTPUTIL_API void pftp_initUtil(pftp_comm_centralFunc_t comm_central);
LIBPFTPUTIL_API void pftp_freeUtil(void);

LIBPFTPUTIL_API pftp_settings_t pftp_getFTPSettings(const char *ftpname);
LIBPFTPUTIL_API pftp_server_t pftp_getFTPCtrl(const char *ftpname);
LIBPFTPUTIL_API int pftp_getFTPConnected(const char *ftpname);
LIBPFTPUTIL_API void pftp_closeFTPCtrl(const char *ftpname);
LIBPFTPUTIL_API void pftp_createFTPSettings(const char *ftpname, 
					    const char *username,
					    const char *passwd, 
					    const char *hostname, 
					    unsigned short port, 
					    int ssl, int sftp);
LIBPFTPUTIL_API pftp_default_t pftp_getDefaultSettings(void);
LIBPFTPUTIL_API pftp_conf_t pftp_getConfig(void);
LIBPFTPUTIL_API int pftp_saveFTPSettings(const char *orgname, 
					 const char *targetname,
					 int save_password,
					 int clear_password);

LIBPFTPUTIL_API size_t pftp_getFreeFTPID(void);

LIBPFTPUTIL_API size_t pftp_getNrOfSettings(void);
LIBPFTPUTIL_API pftp_settings_t pftp_getFTPSettings2(size_t id);

LIBPFTPUTIL_API int pftp_makePath(const char *ftpname, const char *path);

#endif /* PFTPUTIL_H */
