/* -*- pftp-c -*- */
#ifndef PFTP_CLIENT_H
#define PFTP_CLIENT_H

#ifndef LIBPFTPUTIL_API
# ifdef WIN32
#  include "w32-libpftputil.h"
# else
#  define LIBPFTPUTIL_API 
# endif
#endif

#define PFTP_DLG_OVERWRITE 0x1
#define PFTP_DLG_RESUME 0x2
#define PFTP_DLG_SKIP 0x4
#define PFTP_DLG_ALL 0x10
#define PFTP_DLG_ABORT 0x100

#define PFTP_ERROR_FAILED 0x2

LIBPFTPUTIL_API typedef unsigned int (*pftp_ExistingFilefunc_t)(const pftp_file_t existing, 
								const pftp_item_t transfering);

LIBPFTPUTIL_API pftp_directory_t *pftp_trans_ls(const char *ftp_name, 
						const char *pattern, 
						char **path, int hidden, 
						int link_names);
LIBPFTPUTIL_API pftp_directory_t *pftp_trans_ls2(pftp_server_t ftp, 
						 const char *pattern, 
						 char **path, int hidden, 
						 int link_names);
LIBPFTPUTIL_API int pftp_get_path_dir(const char *ftpserver, char **path);
LIBPFTPUTIL_API void pftp_apply_mask(pftp_directory_t *filelist, 
				     const char *mask, int hidden);
LIBPFTPUTIL_API int pftp_get_files_ordered(const char *from, const char *to, 
					   const char *srcpath, 
					   pftp_directory_t *FileList, 
					   pftp_que_t fileque, int last, 
					   unsigned int preserve,
					   pftp_item_action_t action,
					   unsigned int mode);
LIBPFTPUTIL_API int pftp_begin_trans(pftp_ExistingFilefunc_t dialog, 
				     pftp_que_t fileque, pftp_que_t errorque);
LIBPFTPUTIL_API int pftp_does_exist(pftp_item_t item, 
				    pftp_ExistingFilefunc_t dialog, 
				    uint64_t *filesize);

LIBPFTPUTIL_API int pftp_mirror(const char *srcftp, const char *srcpath,
				const char *dstftp, const char *dstpath,
				pftp_que_t fileque,
				int delete_dst, int recursive, int only_new, 
				int ign_time);

LIBPFTPUTIL_API int pftp_valid_hostname(const char *hostname);

#endif /* PFTP_CLIENT_H */
