/* -*- pftp-c -*- */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <inttypes.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif

#include "pftp_item.h"
#include "patternmatch.h"
#include "pftputil.h"
#include "str.h"

void pftp_clear_que(pftp_que_t Q)
{
    pftp_item_t item;

    while ((item = (pftp_item_t) pftp_deque(Q)))
	pftp_free_queitem(&item);
}

pftp_item_t pftp_get_next(pftp_que_t Q)
{
    return (pftp_item_t)pftp_deque(Q);
}

pftp_item_t pftp_que_peek(pftp_que_t Q, size_t pos)
{
    return (pftp_item_t)pftp_peek(Q, pos);
}

void pftp_que_add_first(pftp_item_t Item, pftp_que_t Q)
{
    pftp_addFirst(Item, Q);
}

void pftp_que_add_last(pftp_item_t Item, pftp_que_t Q)
{
    pftp_addLast(Item, Q);
}

pftp_item_t pftp_remove_item(int index, pftp_que_t Q)
{
    return (pftp_item_t) pftp_delete(index, Q);
}

#define safe_free(__x__) if (__x__) free(__x__)

void pftp_free_queitem(pftp_item_t *item)
{
    if (item && (*item)) {
	safe_free((*item)->ftp_from);
	safe_free((*item)->ftp_to);
	safe_free((*item)->filename);
	safe_free((*item)->changed);
	safe_free((*item)->srcpath);
	safe_free((*item)->destpath);
	safe_free((*item)->target);
	free((*item));
	(*item) = NULL;
    }
}

int pftp_que_add_dir(const char *srcftp, const char *destftp,
		     const char *srcpath, const char *destpath,
		     const pftp_directory_t *in_dir, pftp_que_t que, int last)
{
    pftp_item_t file;
    size_t f;
    pftp_directory_t dir;
    char **ignore_list = NULL;
    size_t ignore_list_len = 0;
    pftp_settings_t s_srcftp = pftp_getFTPSettings(srcftp);
    pftp_settings_t s_destftp = pftp_getFTPSettings(destftp);
    pftp_default_t s_global = pftp_getDefaultSettings();

    if (!in_dir->length)
	return 0;
    
    dir.length = in_dir->length;
    dir.files = malloc(dir.length * sizeof(pftp_file_t));
    memcpy(dir.files, in_dir->files, dir.length * sizeof(pftp_file_t));

    /* Feeding ignore list */
    if (s_srcftp && s_srcftp->ignore_list && s_srcftp->ignore_list_len) {
	ignore_list = realloc(ignore_list, (ignore_list_len + 
					    s_srcftp->ignore_list_len) *
			      sizeof(char *));
	memcpy(ignore_list + ignore_list_len, s_srcftp->ignore_list,
	       s_srcftp->ignore_list_len * sizeof(char *));
	ignore_list_len += s_srcftp->ignore_list_len;
    }
    
    if (s_destftp && s_destftp->ignore_list && s_destftp->ignore_list_len){
	ignore_list = realloc(ignore_list, (ignore_list_len + 
					    s_destftp->ignore_list_len) *
			      sizeof(char *));
	memcpy(ignore_list + ignore_list_len, s_destftp->ignore_list,
	       s_destftp->ignore_list_len * sizeof(char *));
	ignore_list_len += s_destftp->ignore_list_len;
    }
    
    if (!ignore_list_len || (s_srcftp && s_srcftp->include_global_ignore) ||
	(s_destftp && s_destftp->include_global_ignore)) {
	if (s_global->ignore_list && s_global->ignore_list_len) {
	    ignore_list = realloc(ignore_list, (ignore_list_len + 
						s_global->ignore_list_len) *
				  sizeof(char *));
	    memcpy(ignore_list + ignore_list_len, s_global->ignore_list,
		   s_global->ignore_list_len * sizeof(char *));
	    ignore_list_len += s_global->ignore_list_len;
	}
    }
    
    if (ignore_list && ignore_list_len) {
	for (f = 0; f < dir.length; f++) {
	    if (!listfnmatch(dir.files[f].name, ignore_list, 
			     ignore_list_len)) {
		dir.length--;
		memmove(dir.files + f, dir.files + f + 1, (dir.length - f) *
			sizeof(pftp_file_t));
		f--;
	    }
	}
    }
    
    if (ignore_list)
	free(ignore_list);
    
    if (!dir.length) {
	free(dir.files);
	return 0;
    }
    
    if (s_destftp) {
	if (s_destftp->prio_list) {
	    priolist(&dir, s_destftp->prio_list, s_destftp->prio_list_len);
	    
	    if (s_destftp->include_global_prio) 
		priolist(&dir, s_global->prio_list, s_global->prio_list_len); 
	} else if (s_global->prio_list) {
	    priolist(&dir, s_global->prio_list, s_global->prio_list_len);
	}
    } else if (s_srcftp) {
	if (s_srcftp->prio_list) {
	    priolist(&dir, s_srcftp->prio_list, s_srcftp->prio_list_len);
	    
	    if (s_srcftp->include_global_prio) 
		priolist(&dir, s_global->prio_list, s_global->prio_list_len); 
	} else if (s_global->prio_list) {
	    priolist(&dir, s_global->prio_list, s_global->prio_list_len);
	}
    }
    
    for (f = dir.length; f > 0; f--) {
	file = malloc(sizeof(struct pftp_item_s));
	memset(file, 0, sizeof(struct pftp_item_s));
	file->ftp_from = alloc_strcpy(srcftp);
	file->ftp_to = alloc_strcpy(destftp);
	file->srcpath = alloc_strcpy(srcpath);
	file->filename = alloc_strcpy(dir.files[f - 1].name);
	file->destpath = alloc_strcpy(destpath);
	file->size = dir.files[f - 1].size;
	file->changed = alloc_strcpy(dir.files[f - 1].changed);
	file->dir = (dir.files[f - 1].type == pft_directory);
	if (last)
	    pftp_que_add_last(file, que);	
	else
	    pftp_que_add_first(file, que);	
    }

    free(dir.files);
    
    return 0;
}
