/* -*- pftp-c -*- */
/* str.h - String helper functions */

#ifndef STR_H
#define STR_H

char *realloc_strncat(char *str, const char *newstr, size_t len);
char *realloc_strncpy(char *str, const char *newstr, size_t len);
char *realloc_strcat(char *str, const char *newstr);
char *realloc_strcpy(char *str, const char *newstr);
char *alloc_strncpy(const char *newstr, size_t len);
char *alloc_strcpy(const char *newstr);

size_t split(const char *str, const char *needle, char ***part, ...);
void free_split(char ***part, size_t *parts);

char *unsplit(const char **str, size_t str_count, const char *seporator);

void unbackslash(char *str);

int is_whitespace(char c);
void trim_left(char *str);
void trim_right(char *str);
void trim(char *str);

char *strtolower(char *str);
char *strtoupper(char *str);

char *alloc_strreplace(const char *body, const char *needle, 
		       const char *new);
char *realloc_strreplace(char *str, const char *needle, const char *new);

#ifndef xisspace
#define xisspace(_c_) isspace((int)_c_)
#endif /* xisspace */

#ifndef xisdigit
#define xisdigit(_c_) isdigit((int)_c_)
#endif /* xisdigit */

#ifndef xisascii
#define xisascii(_c_) isascii((int)_c_)
#endif /* xisascii */

#ifndef xisalpha
#define xisalpha(_c_) isalpha((int)_c_)
#endif /* xisalpha */

#ifndef xislower
#define xislower(_c_) islower((int)_c_)
#endif /* xislower */

#ifndef xisupper
#define xisupper(_c_) isupper((int)_c_)
#endif /* xisupper */

#endif /* STR_H */
