/* -*- pftp-c -*- */
#ifndef PFTP_ITEM_H
#define PFTP_ITEM_H

#include <pftp_directory.h>
#include <pftp_settings.h>
#include "pftp_que.h"

typedef struct pftp_item_s *pftp_item_t;

struct pftp_item_s {
    char *ftp_from, *ftp_to;
    uint64_t size;
    int dir;
    char *filename, *changed, *target;
    char *srcpath, *destpath;
};

pftp_item_t pftp_get_next(pftp_que_t Q);
pftp_item_t pftp_que_peek(pftp_que_t Q, size_t pos);
void pftp_que_add_first(pftp_item_t Item, pftp_que_t Q);
void pftp_que_add_last(pftp_item_t Item, pftp_que_t Q);
pftp_item_t pftp_remove_item(int index, pftp_que_t Q);
void pftp_free_queitem(pftp_item_t *item);
void pftp_clear_que(pftp_que_t Q);
int pftp_que_add_dir(const char *srcftp,  const char *destftp,
		     const char *srcpath, const char *destpath,
		     const pftp_directory_t *dir, pftp_que_t que, int last);

#endif /* PFTP_ITEM */
