/* -*- pftp-c -*- */
#ifndef PFTP_CLIENT_H
#define PFTP_CLIENT_H

#define PFTP_DLG_OVERWRITE 0x1
#define PFTP_DLG_RESUME 0x2
#define PFTP_DLG_SKIP 0x4
#define PFTP_DLG_ALL 0x10
#define PFTP_DLG_ABORT 0x100

typedef int (*pftp_ExistingFilefunc_t)(const pftp_file_t existing, 
				       const pftp_item_t transfering);

int pftp_deleteDirectoryFTP(pftp_server_t ftp, const char *path,
			    const char *dirname);
pftp_directory_t *pftp_trans_ls(const char *ftp_name, const char *pattern, 
				char **path, int hidden, int link_names);
pftp_directory_t *pftp_trans_ls2(pftp_server_t ftp, const char *pattern, 
				 char **path, int hidden, int link_names);
int pftp_get_path_dir(const char *ftpserver, char **path);
void pftp_apply_mask(pftp_directory_t *filelist, const char *mask, int hidden);
int pftp_get_files_ordered(const char *from, const char *to, 
			   const char *srcpath, pftp_directory_t *FileList, 
			   pftp_que_t fileque, int last);
int pftp_begin_trans(char *args, pftp_ExistingFilefunc_t dialog, 
		     pftp_que_t fileque, pftp_que_t errorque);
int pftp_does_exist(pftp_item_t item, pftp_ExistingFilefunc_t dialog, 
		    uint64_t *filesize);

#endif /* PFTP_CLIENT_H */
