#include "config.h"

#include "liboss/soundcard.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <dirent.h>
#include <sys/stat.h>
#include <string.h>

/* FIXME: Add capability for recording with 'libosscat /dev/audio > somefile' */


/* How to play the sound */
#define BUF_SIZE	ESD_BUF_SIZE
#define DEVICE		"/dev/dsp"

/* What kind of sound is this, anyway? */
/* NB: .wav is usually {1, 16, 20500, 0} */
#define STEREO		ESD_STEREO
#define BITS		ESD_BITS16
#define RATE		ESD_DEFAULT_RATE
#define ENDIAN		LITTLE_ENDIAN


int main(int argc, char **argv)
{
	int retval = 0, arg = 0;
	int play, sz, format;                        

	int stereo = STEREO, speed = RATE;
	int bits = BITS;

	char buf[BUF_SIZE];

	FILE *source = NULL;
	char *name = NULL;
	
	for (arg = 1; arg < argc; arg++)
	{
		if (!strcmp("-h",argv[arg]))
		{
			printf("usage:\n\t%s {-b} [-m} [-r freq] < file\n",
				argv[0]);
			exit(0);
		}
		else if (!strcmp("-b", argv[arg]))
			bits = ESD_BITS8;
		else if (!strcmp("-m", argv[arg]))
			stereo = ESD_MONO;
		else if (!strcmp("-r", argv[arg]))
		{
			arg++;
			speed = atoi(argv[arg]);
		} else if (source) {
			printf("%s: ignoring extra file '%s'\n", argv[0],
				argv[arg]);
		} else {	
			name = argv[arg];
			if ((source = fopen(name, "r")) == NULL)
			{
				printf("%s: couldn't open sound file: %s\n",
					argv[0], name);
				return 1;
			}
		}
	}

	if (!source)
		source = stdin;

	if ((play = open(DEVICE, O_WRONLY, 0)) < 0) {
		fprintf(stderr, "%s could not be opened.\n", DEVICE);
		exit(1);
	}

        format = (bits == 16) ? AFMT_S16_NE : AFMT_S8;
	retval = ioctl(play, SNDCTL_DSP_SETFMT, &format);
	if (retval < 0)
		return retval;

	retval = ioctl(play, SNDCTL_DSP_STEREO, &stereo);
	if (retval < 0)
		return retval;

	retval = ioctl(play, SNDCTL_DSP_SPEED, &speed);
	if (retval < 0)
		return retval;

	while ( (sz = fread(buf, 1, BUF_SIZE, source)) > 0 ) {
                if (write(play, buf, sz) <= 0)
			return 1;
	}
	
	return 0;
}
