/* GNOME DB library
 * Copyright (C) 1999-2002 The GNOME Foundation.
 *
 * AUTHORS:
 * 	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef BUILD_WITH_GNOME
#include <bonobo/bonobo-ui-main.h>
#endif
#ifdef HAVE_LIBGLADE
#include <glade/glade-init.h>
#endif
#include <libgda/libgda.h>
#ifdef BUILD_WITH_GNOME
#include <libgnomeui/gnome-ui-init.h>
#endif
#include <libgnomedb/libgnomedb.h>
#include "gnome-db-i18n.h"

extern void gnome_db_stock_init (void);

/*
 * Public functions
 */

void
gnome_db_init (const gchar *app_id, const gchar *version, gint nargs, gchar *args[])
{
	static gboolean initialized = FALSE;

	if (initialized) {
		gda_log_error (_("Attempt to initialize an already initialized client"));
		return;
	}

	bindtextdomain(GETTEXT_PACKAGE, LIBGNOMEDB_LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");

	gda_init (app_id, version, nargs, args);
#ifdef BUILD_WITH_GNOME
	gnome_program_init (app_id, version, LIBGNOMEUI_MODULE, nargs, args,
			    GNOME_PROGRAM_STANDARD_PROPERTIES, NULL);

	if (!bonobo_ui_is_initialized ())
		bonobo_ui_init (app_id, version, &nargs, args);
#else
	gtk_init (nargs, args);
#endif

#ifdef HAVE_LIBGLADE
	glade_init ();
#endif
	gnome_db_stock_init ();
}

typedef struct {
	GdaInitFunc init_func;
	gpointer user_data;
} InitCbData;

static gboolean
idle_cb (gpointer user_data)
{
	InitCbData *cb_data = (InitCbData *) user_data;

	g_return_val_if_fail (cb_data != NULL, FALSE);

	if (cb_data->init_func)
		cb_data->init_func (cb_data->user_data);

	g_free (cb_data);

	return FALSE;
}

/**
 * gnome_db_main_run
 * @init_func: function to be called when everything has been initialized
 * @user_data: data to be passed to the init function
 *
 * Runs the GNOME-DB main loop, which is nothing more than the Bonobo UI main
 * loop, but with internally added stuff specific for applications using
 * libgda/libgnomedb.
 *
 * You can specify a function to be called after everything has been correctly
 * initialized (that is, for initializing your own stuff).
 */
void
gnome_db_main_run (GdaInitFunc init_func, gpointer user_data)
{
	if (init_func) {
		InitCbData *cb_data;

		cb_data = g_new (InitCbData, 1);
		cb_data->init_func = init_func;
		cb_data->user_data = user_data;

		g_idle_add ((GSourceFunc) idle_cb, cb_data);
	}

#ifdef BUILD_WITH_GNOME
	bonobo_ui_main ();
#else
	gtk_main();
#endif	
}

/**
 * gnome_db_main_quit
 */
void
gnome_db_main_quit (void)
{
	gtk_main_quit ();
}
