/**
 * @file
 * @brief  The generated interface for the register allocator.
 *          Contains register classes and types and register constraints
 *          for all nodes where constraints were given in spec.
 * @note    DO NOT EDIT THIS FILE, your changes will be lost.
 *          Edit ir/be/arm/arm_spec.pl instead.
 *          created by: ir/be/scripts/generate_regalloc_if.pl ir/be/arm/arm_spec.pl ir/be/arm
 * $date    Mon Nov 19 18:12:23 2012
 */
#include "config.h"

#include "gen_arm_regalloc_if.h"
#include "bearch_arm_t.h"
#include "irmode.h"

static const arch_register_req_t arm_class_reg_req_flags = {
	arch_register_req_type_normal,
	&arm_reg_classes[CLASS_arm_flags],
	NULL,
	0,
	0,
	1
};
static const unsigned arm_limited_flags_fl [] = { (1 << REG_FLAGS_FL) };
static const arch_register_req_t arm_single_reg_req_flags_fl = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_flags],
	arm_limited_flags_fl,
	0,
	0,
	1
};
static const arch_register_req_t arm_class_reg_req_gp = {
	arch_register_req_type_normal,
	&arm_reg_classes[CLASS_arm_gp],
	NULL,
	0,
	0,
	1
};
static const unsigned arm_limited_gp_r0 [] = { (1 << REG_GP_R0) };
static const arch_register_req_t arm_single_reg_req_gp_r0 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_gp],
	arm_limited_gp_r0,
	0,
	0,
	1
};
static const unsigned arm_limited_gp_r1 [] = { (1 << REG_GP_R1) };
static const arch_register_req_t arm_single_reg_req_gp_r1 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_gp],
	arm_limited_gp_r1,
	0,
	0,
	1
};
static const unsigned arm_limited_gp_r2 [] = { (1 << REG_GP_R2) };
static const arch_register_req_t arm_single_reg_req_gp_r2 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_gp],
	arm_limited_gp_r2,
	0,
	0,
	1
};
static const unsigned arm_limited_gp_r3 [] = { (1 << REG_GP_R3) };
static const arch_register_req_t arm_single_reg_req_gp_r3 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_gp],
	arm_limited_gp_r3,
	0,
	0,
	1
};
static const unsigned arm_limited_gp_r4 [] = { (1 << REG_GP_R4) };
static const arch_register_req_t arm_single_reg_req_gp_r4 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_gp],
	arm_limited_gp_r4,
	0,
	0,
	1
};
static const unsigned arm_limited_gp_r5 [] = { (1 << REG_GP_R5) };
static const arch_register_req_t arm_single_reg_req_gp_r5 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_gp],
	arm_limited_gp_r5,
	0,
	0,
	1
};
static const unsigned arm_limited_gp_r6 [] = { (1 << REG_GP_R6) };
static const arch_register_req_t arm_single_reg_req_gp_r6 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_gp],
	arm_limited_gp_r6,
	0,
	0,
	1
};
static const unsigned arm_limited_gp_r7 [] = { (1 << REG_GP_R7) };
static const arch_register_req_t arm_single_reg_req_gp_r7 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_gp],
	arm_limited_gp_r7,
	0,
	0,
	1
};
static const unsigned arm_limited_gp_r8 [] = { (1 << REG_GP_R8) };
static const arch_register_req_t arm_single_reg_req_gp_r8 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_gp],
	arm_limited_gp_r8,
	0,
	0,
	1
};
static const unsigned arm_limited_gp_r9 [] = { (1 << REG_GP_R9) };
static const arch_register_req_t arm_single_reg_req_gp_r9 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_gp],
	arm_limited_gp_r9,
	0,
	0,
	1
};
static const unsigned arm_limited_gp_r10 [] = { (1 << REG_GP_R10) };
static const arch_register_req_t arm_single_reg_req_gp_r10 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_gp],
	arm_limited_gp_r10,
	0,
	0,
	1
};
static const unsigned arm_limited_gp_r11 [] = { (1 << REG_GP_R11) };
static const arch_register_req_t arm_single_reg_req_gp_r11 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_gp],
	arm_limited_gp_r11,
	0,
	0,
	1
};
static const unsigned arm_limited_gp_r12 [] = { (1 << REG_GP_R12) };
static const arch_register_req_t arm_single_reg_req_gp_r12 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_gp],
	arm_limited_gp_r12,
	0,
	0,
	1
};
static const unsigned arm_limited_gp_sp [] = { (1 << REG_GP_SP) };
static const arch_register_req_t arm_single_reg_req_gp_sp = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_gp],
	arm_limited_gp_sp,
	0,
	0,
	1
};
static const unsigned arm_limited_gp_lr [] = { (1 << REG_GP_LR) };
static const arch_register_req_t arm_single_reg_req_gp_lr = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_gp],
	arm_limited_gp_lr,
	0,
	0,
	1
};
static const unsigned arm_limited_gp_pc [] = { (1 << REG_GP_PC) };
static const arch_register_req_t arm_single_reg_req_gp_pc = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_gp],
	arm_limited_gp_pc,
	0,
	0,
	1
};
static const arch_register_req_t arm_class_reg_req_fpa = {
	arch_register_req_type_normal,
	&arm_reg_classes[CLASS_arm_fpa],
	NULL,
	0,
	0,
	1
};
static const unsigned arm_limited_fpa_f0 [] = { (1 << REG_FPA_F0) };
static const arch_register_req_t arm_single_reg_req_fpa_f0 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_fpa],
	arm_limited_fpa_f0,
	0,
	0,
	1
};
static const unsigned arm_limited_fpa_f1 [] = { (1 << REG_FPA_F1) };
static const arch_register_req_t arm_single_reg_req_fpa_f1 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_fpa],
	arm_limited_fpa_f1,
	0,
	0,
	1
};
static const unsigned arm_limited_fpa_f2 [] = { (1 << REG_FPA_F2) };
static const arch_register_req_t arm_single_reg_req_fpa_f2 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_fpa],
	arm_limited_fpa_f2,
	0,
	0,
	1
};
static const unsigned arm_limited_fpa_f3 [] = { (1 << REG_FPA_F3) };
static const arch_register_req_t arm_single_reg_req_fpa_f3 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_fpa],
	arm_limited_fpa_f3,
	0,
	0,
	1
};
static const unsigned arm_limited_fpa_f4 [] = { (1 << REG_FPA_F4) };
static const arch_register_req_t arm_single_reg_req_fpa_f4 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_fpa],
	arm_limited_fpa_f4,
	0,
	0,
	1
};
static const unsigned arm_limited_fpa_f5 [] = { (1 << REG_FPA_F5) };
static const arch_register_req_t arm_single_reg_req_fpa_f5 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_fpa],
	arm_limited_fpa_f5,
	0,
	0,
	1
};
static const unsigned arm_limited_fpa_f6 [] = { (1 << REG_FPA_F6) };
static const arch_register_req_t arm_single_reg_req_fpa_f6 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_fpa],
	arm_limited_fpa_f6,
	0,
	0,
	1
};
static const unsigned arm_limited_fpa_f7 [] = { (1 << REG_FPA_F7) };
static const arch_register_req_t arm_single_reg_req_fpa_f7 = {
	arch_register_req_type_limited,
	&arm_reg_classes[CLASS_arm_fpa],
	arm_limited_fpa_f7,
	0,
	0,
	1
};

arch_register_class_t arm_reg_classes[] = {
	{ 0, "arm_flags", 1, NULL, &arm_registers[REG_FL], arch_register_class_flag_manual_ra, &arm_class_reg_req_flags },
	{ 1, "arm_gp", 16, NULL, &arm_registers[REG_R0], arch_register_class_flag_none, &arm_class_reg_req_gp },
	{ 2, "arm_fpa", 8, NULL, &arm_registers[REG_F0], arch_register_class_flag_none, &arm_class_reg_req_fpa }
};


/** The array of all registers in the arm architecture, sorted by its global index.*/
const arch_register_t arm_registers[] = {
	{
		"fl",
		&arm_reg_classes[CLASS_arm_flags],
		REG_FLAGS_FL,
		REG_FL,
		arch_register_type_none,
		&arm_single_reg_req_flags_fl,
		0
	},
	{
		"r0",
		&arm_reg_classes[CLASS_arm_gp],
		REG_GP_R0,
		REG_R0,
		arch_register_type_none,
		&arm_single_reg_req_gp_r0,
		0
	},
	{
		"r1",
		&arm_reg_classes[CLASS_arm_gp],
		REG_GP_R1,
		REG_R1,
		arch_register_type_none,
		&arm_single_reg_req_gp_r1,
		1
	},
	{
		"r2",
		&arm_reg_classes[CLASS_arm_gp],
		REG_GP_R2,
		REG_R2,
		arch_register_type_none,
		&arm_single_reg_req_gp_r2,
		2
	},
	{
		"r3",
		&arm_reg_classes[CLASS_arm_gp],
		REG_GP_R3,
		REG_R3,
		arch_register_type_none,
		&arm_single_reg_req_gp_r3,
		3
	},
	{
		"r4",
		&arm_reg_classes[CLASS_arm_gp],
		REG_GP_R4,
		REG_R4,
		arch_register_type_none,
		&arm_single_reg_req_gp_r4,
		4
	},
	{
		"r5",
		&arm_reg_classes[CLASS_arm_gp],
		REG_GP_R5,
		REG_R5,
		arch_register_type_none,
		&arm_single_reg_req_gp_r5,
		5
	},
	{
		"r6",
		&arm_reg_classes[CLASS_arm_gp],
		REG_GP_R6,
		REG_R6,
		arch_register_type_none,
		&arm_single_reg_req_gp_r6,
		6
	},
	{
		"r7",
		&arm_reg_classes[CLASS_arm_gp],
		REG_GP_R7,
		REG_R7,
		arch_register_type_none,
		&arm_single_reg_req_gp_r7,
		7
	},
	{
		"r8",
		&arm_reg_classes[CLASS_arm_gp],
		REG_GP_R8,
		REG_R8,
		arch_register_type_none,
		&arm_single_reg_req_gp_r8,
		8
	},
	{
		"r9",
		&arm_reg_classes[CLASS_arm_gp],
		REG_GP_R9,
		REG_R9,
		arch_register_type_none,
		&arm_single_reg_req_gp_r9,
		9
	},
	{
		"r10",
		&arm_reg_classes[CLASS_arm_gp],
		REG_GP_R10,
		REG_R10,
		arch_register_type_none,
		&arm_single_reg_req_gp_r10,
		10
	},
	{
		"r11",
		&arm_reg_classes[CLASS_arm_gp],
		REG_GP_R11,
		REG_R11,
		arch_register_type_none,
		&arm_single_reg_req_gp_r11,
		11
	},
	{
		"r12",
		&arm_reg_classes[CLASS_arm_gp],
		REG_GP_R12,
		REG_R12,
		arch_register_type_none,
		&arm_single_reg_req_gp_r12,
		12
	},
	{
		"sp",
		&arm_reg_classes[CLASS_arm_gp],
		REG_GP_SP,
		REG_SP,
		arch_register_type_none,
		&arm_single_reg_req_gp_sp,
		13
	},
	{
		"lr",
		&arm_reg_classes[CLASS_arm_gp],
		REG_GP_LR,
		REG_LR,
		arch_register_type_none,
		&arm_single_reg_req_gp_lr,
		14
	},
	{
		"pc",
		&arm_reg_classes[CLASS_arm_gp],
		REG_GP_PC,
		REG_PC,
		arch_register_type_none,
		&arm_single_reg_req_gp_pc,
		15
	},
	{
		"f0",
		&arm_reg_classes[CLASS_arm_fpa],
		REG_FPA_F0,
		REG_F0,
		arch_register_type_none,
		&arm_single_reg_req_fpa_f0,
		96
	},
	{
		"f1",
		&arm_reg_classes[CLASS_arm_fpa],
		REG_FPA_F1,
		REG_F1,
		arch_register_type_none,
		&arm_single_reg_req_fpa_f1,
		97
	},
	{
		"f2",
		&arm_reg_classes[CLASS_arm_fpa],
		REG_FPA_F2,
		REG_F2,
		arch_register_type_none,
		&arm_single_reg_req_fpa_f2,
		98
	},
	{
		"f3",
		&arm_reg_classes[CLASS_arm_fpa],
		REG_FPA_F3,
		REG_F3,
		arch_register_type_none,
		&arm_single_reg_req_fpa_f3,
		99
	},
	{
		"f4",
		&arm_reg_classes[CLASS_arm_fpa],
		REG_FPA_F4,
		REG_F4,
		arch_register_type_none,
		&arm_single_reg_req_fpa_f4,
		100
	},
	{
		"f5",
		&arm_reg_classes[CLASS_arm_fpa],
		REG_FPA_F5,
		REG_F5,
		arch_register_type_none,
		&arm_single_reg_req_fpa_f5,
		101
	},
	{
		"f6",
		&arm_reg_classes[CLASS_arm_fpa],
		REG_FPA_F6,
		REG_F6,
		arch_register_type_none,
		&arm_single_reg_req_fpa_f6,
		102
	},
	{
		"f7",
		&arm_reg_classes[CLASS_arm_fpa],
		REG_FPA_F7,
		REG_F7,
		arch_register_type_none,
		&arm_single_reg_req_fpa_f7,
		103
	},

};

/**
 * Initializes arm register classes.
 */
void arm_register_init(void)
{
	arm_reg_classes[CLASS_arm_flags].mode = mode_Bu;
	arm_reg_classes[CLASS_arm_gp].mode = mode_Iu;
	arm_reg_classes[CLASS_arm_fpa].mode = mode_F;

}
