/**
 * @file
 * @brief     Generated functions to emit code for assembler ir nodes.
 * @note      DO NOT EDIT THIS FILE, your changes will be lost.
 *            Edit ir/be/arm/arm_spec.pl instead.
 *            created by: ir/be/scripts/generate_emitter.pl ir/be/arm/arm_spec.pl ir/be/arm
 * @date      Mon Nov 19 18:12:23 2012
 */
#include "config.h"

#include <stdio.h>
#include <assert.h>

#include "irnode.h"
#include "irop_t.h"
#include "irprog_t.h"
#include "beemitter.h"

#include "gen_arm_emitter.h"
#include "arm_new_nodes.h"
#include "arm_emitter.h"

static void emit_arm_Mvf(const ir_node *node)
{
	arm_emitf(node, "mvf%MA %S0, %D0");
}

static void emit_arm_Ldr(const ir_node *node)
{
	arm_emitf(node, "ldr%ML %D0, [%S0, #%o]");
}

static void emit_arm_Rsb(const ir_node *node)
{
	arm_emitf(node, "rsb %D0, %S0, %O");
}

static void emit_arm_Mla(const ir_node *node)
{
	arm_emitf(node, "mla %D0, %S0, %S1, %S2");
}

static void emit_arm_LinkMovPC(const ir_node *node)
{
	arm_emitf(node, "mov lr, pc");
	arm_emitf(node, "mov pc, %O");
}

static void emit_arm_Mov(const ir_node *node)
{
	arm_emitf(node, "mov %D0, %O");
}

static void emit_arm_FltX(const ir_node *node)
{
	arm_emitf(node, "flt%MA %D0, %S0");
}

static void emit_arm_Or(const ir_node *node)
{
	arm_emitf(node, "orr %D0, %S0, %O");
}

static void emit_arm_EmptyReg(const ir_node *node)
{
	arm_emitf(node, "/* %D0 now available for calculations */");
}

static void emit_arm_Cmp(const ir_node *node)
{
	arm_emitf(node, "cmp %S0, %O");
}

static void emit_arm_Smull(const ir_node *node)
{
	arm_emitf(node, "smull %D0, %D1, %S0, %S1");
}

static void emit_arm_Add(const ir_node *node)
{
	arm_emitf(node, "add %D0, %S0, %O");
}

static void emit_arm_LinkLdrPC(const ir_node *node)
{
	arm_emitf(node, "mov lr, pc");
	arm_emitf(node, "ldr pc, %O");
}

static void emit_arm_Ldf(const ir_node *node)
{
	arm_emitf(node, "ldf%MF %D0, [%S0, #%o]");
}

static void emit_arm_Mvn(const ir_node *node)
{
	arm_emitf(node, "mvn %D0, %O");
}

static void emit_arm_LoadStackM3Epilogue(const ir_node *node)
{
	arm_emitf(node, "ldmfd %S0, {%D0, %D1, %D2}");
}

static void emit_arm_Tst(const ir_node *node)
{
	arm_emitf(node, "tst %S0, %O");
}

static void emit_arm_Umull(const ir_node *node)
{
	arm_emitf(node, "umull %D0, %D1, %S0, %S1");
}

static void emit_arm_Bic(const ir_node *node)
{
	arm_emitf(node, "bic %D0, %S0, %O");
}

static void emit_arm_Sub(const ir_node *node)
{
	arm_emitf(node, "sub %D0, %S0, %O");
}

static void emit_arm_Mul(const ir_node *node)
{
	arm_emitf(node, "mul %D0, %S0, %S1");
}

static void emit_arm_Adf(const ir_node *node)
{
	arm_emitf(node, "adf%MA %D0, %S0, %S1");
}

static void emit_arm_Bl(const ir_node *node)
{
	arm_emitf(node, "bl %I");
}

static void emit_arm_Stf(const ir_node *node)
{
	arm_emitf(node, "stf%MF %S1, [%S0, #%o]");
}

static void emit_arm_Clz(const ir_node *node)
{
	arm_emitf(node, "clz %D0, %S0");
}

static void emit_arm_Suf(const ir_node *node)
{
	arm_emitf(node, "suf%MA %D0, %S0, %S1");
}

static void emit_arm_Cmfe(const ir_node *node)
{
	arm_emitf(node, "cmfe %S0, %S1");
}

static void emit_arm_And(const ir_node *node)
{
	arm_emitf(node, "and %D0, %S0, %O");
}

static void emit_arm_Str(const ir_node *node)
{
	arm_emitf(node, "str%MS %S1, [%S0, #%o]");
}

static void emit_arm_Dvf(const ir_node *node)
{
	arm_emitf(node, "dvf%MA %D0, %S0, %S1");
}

static void emit_arm_StoreStackM4Inc(const ir_node *node)
{
	arm_emitf(node, "stmfd %S0!, {%S1, %S2, %S3, %S4}");
}

static void emit_arm_Muf(const ir_node *node)
{
	arm_emitf(node, "muf%MA %D0, %S0, %S1");
}

static void emit_arm_Eor(const ir_node *node)
{
	arm_emitf(node, "eor %D0, %S0, %O");
}


typedef void (*emit_func)(const ir_node *node);

static void arm_register_emitter(ir_op *op, emit_func func)
{
	assert(op->ops.generic == NULL);
	op->ops.generic = (op_func)func;
}

/**
 * Enters the emitter functions for handled nodes into the generic
 * pointer of an opcode.
 */
void arm_register_spec_emitters(void)
{
  arm_register_emitter(op_arm_Mvf, emit_arm_Mvf);
  arm_register_emitter(op_arm_Ldr, emit_arm_Ldr);
  arm_register_emitter(op_arm_Rsb, emit_arm_Rsb);
  arm_register_emitter(op_arm_Mla, emit_arm_Mla);
  arm_register_emitter(op_arm_LinkMovPC, emit_arm_LinkMovPC);
  arm_register_emitter(op_arm_Mov, emit_arm_Mov);
  arm_register_emitter(op_arm_FltX, emit_arm_FltX);
  arm_register_emitter(op_arm_Or, emit_arm_Or);
  arm_register_emitter(op_arm_EmptyReg, emit_arm_EmptyReg);
  arm_register_emitter(op_arm_Cmp, emit_arm_Cmp);
  arm_register_emitter(op_arm_Smull, emit_arm_Smull);
  arm_register_emitter(op_arm_Add, emit_arm_Add);
  arm_register_emitter(op_arm_LinkLdrPC, emit_arm_LinkLdrPC);
  arm_register_emitter(op_arm_Ldf, emit_arm_Ldf);
  arm_register_emitter(op_arm_Mvn, emit_arm_Mvn);
  arm_register_emitter(op_arm_LoadStackM3Epilogue, emit_arm_LoadStackM3Epilogue);
  arm_register_emitter(op_arm_Tst, emit_arm_Tst);
  arm_register_emitter(op_arm_Umull, emit_arm_Umull);
  arm_register_emitter(op_arm_Bic, emit_arm_Bic);
  arm_register_emitter(op_arm_Sub, emit_arm_Sub);
  arm_register_emitter(op_arm_Mul, emit_arm_Mul);
  arm_register_emitter(op_arm_Adf, emit_arm_Adf);
  arm_register_emitter(op_arm_Bl, emit_arm_Bl);
  arm_register_emitter(op_arm_Stf, emit_arm_Stf);
  arm_register_emitter(op_arm_Clz, emit_arm_Clz);
  arm_register_emitter(op_arm_Suf, emit_arm_Suf);
  arm_register_emitter(op_arm_Cmfe, emit_arm_Cmfe);
  arm_register_emitter(op_arm_And, emit_arm_And);
  arm_register_emitter(op_arm_Str, emit_arm_Str);
  arm_register_emitter(op_arm_Dvf, emit_arm_Dvf);
  arm_register_emitter(op_arm_StoreStackM4Inc, emit_arm_StoreStackM4Inc);
  arm_register_emitter(op_arm_Muf, emit_arm_Muf);
  arm_register_emitter(op_arm_Eor, emit_arm_Eor);
}

