/**
 * @file
 * @brief     Generated functions to emit code for assembler ir nodes.
 * @note      DO NOT EDIT THIS FILE, your changes will be lost.
 *            Edit ir/be/amd64/amd64_spec.pl instead.
 *            created by: ir/be/scripts/generate_emitter.pl ir/be/amd64/amd64_spec.pl ir/be/amd64
 * @date      Mon Nov 19 18:12:23 2012
 */
#include "config.h"

#include <stdio.h>
#include <assert.h>

#include "irnode.h"
#include "irop_t.h"
#include "irprog_t.h"
#include "beemitter.h"

#include "gen_amd64_emitter.h"
#include "amd64_new_nodes.h"
#include "amd64_emitter.h"

static void emit_amd64_Store(const ir_node *node)
{
	amd64_emitf(node, "mov %S1, %O(%S0)");
}

static void emit_amd64_Immediate(const ir_node *node)
{
	amd64_emitf(node, "mov %C, %D0");
}

static void emit_amd64_Push(const ir_node *node)
{
	amd64_emitf(node, "push %S0");
}

static void emit_amd64_Neg(const ir_node *node)
{
	amd64_emitf(node, "neg %S0");
}

static void emit_amd64_Cmp(const ir_node *node)
{
	amd64_emitf(node, "cmp %S0, %S1");
}

static void emit_amd64_Load(const ir_node *node)
{
	amd64_emitf(node, "mov %O(%S0), %D0");
}

static void emit_amd64_Mul(const ir_node *node)
{
	amd64_emitf(node, "mul %S1");
}


typedef void (*emit_func)(const ir_node *node);

static void amd64_register_emitter(ir_op *op, emit_func func)
{
	assert(op->ops.generic == NULL);
	op->ops.generic = (op_func)func;
}

/**
 * Enters the emitter functions for handled nodes into the generic
 * pointer of an opcode.
 */
void amd64_register_spec_emitters(void)
{
  amd64_register_emitter(op_amd64_Store, emit_amd64_Store);
  amd64_register_emitter(op_amd64_Immediate, emit_amd64_Immediate);
  amd64_register_emitter(op_amd64_Push, emit_amd64_Push);
  amd64_register_emitter(op_amd64_Neg, emit_amd64_Neg);
  amd64_register_emitter(op_amd64_Cmp, emit_amd64_Cmp);
  amd64_register_emitter(op_amd64_Load, emit_amd64_Load);
  amd64_register_emitter(op_amd64_Mul, emit_amd64_Mul);
}

