/* LIBDS
 * =====
 * This software is Copyright (c) 2002-03 Malcolm Smith.
 * No warranty is provided, including but not limited to
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * This code is licenced subject to the GNU General
 * Public Licence (GPL).  See the COPYING file for more.
 */
#ifndef WIN32_NO_CONFIG_H
#include "../config.h"
#else
#include "../winconf.h"
#endif
#include "DSTreeElement.h"
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

DSTreeElement::DSTreeElement(int newCleanup)
{
	flags=0;
	setDataPtr(NULL);
	setCleanup(newCleanup);
}

DSTreeElement::DSTreeElement(void* newData,int newCleanup)
{
	flags=0;
	setDataPtr(newData);
	setCleanup(newCleanup);
}


DSTreeElement::DSTreeElement(unsigned int newData,int newCleanup)
{
	flags=0;
	setDataInt(newData);
	setCleanup(newCleanup);
}

DSTreeElement::~DSTreeElement()
{
	cleanupData();
}

void DSTreeElement::cleanupData()
{
	if (flags&VALUETYPE_STRING) {
		if ((flags&CLEANUP_VALUE_FREE)&&pData) {
			free(pData);
		}
	}
}

void* DSTreeElement::getDataPtr()
{
	if (flags&VALUETYPE_STRING) {
		return(pData);
	} else {
		return NULL;
	}
}

unsigned int DSTreeElement::getDataInt()
{
	if ((~flags)&VALUETYPE_STRING) {
		return(nData);
	} else {
		return 0;
	}
}

void DSTreeElement::setCleanup(int newCleanup)
{
	newCleanup=newCleanup&CLEANUP_ALL;
	flags=flags&(~CLEANUP_ALL);
	flags=flags|newCleanup;
}

void DSTreeElement::setDataInt(unsigned int newData)
{
	cleanupData();
	nData=newData;
	flags=flags&(~VALUETYPE_STRING);
}

void DSTreeElement::setDataPtr(void* newData)
{
	cleanupData();
	pData=newData;
	flags=flags|VALUETYPE_STRING;
}

