/* LIBDS
 * =====
 * This software is Copyright (c) 2002-03 Malcolm Smith.
 * No warranty is provided, including but not limited to
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * This code is licenced subject to the GNU General
 * Public Licence (GPL).  See the COPYING file for more.
 */

#include <DSTree.h>
#include <stdio.h>

DSTree::DSTree(int nNodes)
{
	int i;
	this->nNodes=nNodes;
	nodes=(DSTree **)malloc((nNodes+1)*sizeof(DSTree *));
	for (i=0;i<(nNodes+1);i++)
		nodes[i]=NULL;
	value=NULL;

}

DSTree::~DSTree()
{
	close();
	free(nodes);
}

void DSTree::close()
{
	int i;
	if (value) delete value;
	for (i=0;i<(nNodes+1);i++) {
		if (nodes[i]!=NULL) delete nodes[i];
		nodes[i]=NULL;
	}
}

BOOL DSTree::insert(int * path, int npathelements, DSTreeElement * le)
{
	if (npathelements==0) {
		/* If there is only one elements in the path, we're at the data
		 * node */
		if (value!=NULL) {
			/* Data's there already!! */
			return FALSE;
		} else {
			value=le;
			return TRUE;
		}
	} else {
		if (path[0]>nNodes) return FALSE;
		if (nodes[path[0]]==NULL) {
			nodes[path[0]]=new DSTree(nNodes);
		}
		/* This place already has more nodes under it. */
		return nodes[path[0]]->insert(&path[1], npathelements-1,
			le);
	}
}

BOOL DSTree::insert(int * path, int npathelements, void * data, int cleanup)
{
	DSTreeElement * te;
	te=new DSTreeElement(data, cleanup);
	return insert(path, npathelements, te);
}

BOOL DSTree::insert(int * path, int npathelements, unsigned int data, int cleanup)
{
	DSTreeElement * te;
	te=new DSTreeElement(data, cleanup);
	return insert(path, npathelements, te);
}

DSTreeElement * DSTree::getElement(int * path, int npathelements)
{
	if (npathelements==0) {
		/* If there is only one elements in the path, we're at the data
		 * node */
		return value;
	} else {
		if (path[0]>nNodes) return NULL;
		if (nodes[path[0]]==NULL) return NULL;
		/* This place already has more nodes under it. */
		return nodes[path[0]]->getElement(&path[1], npathelements-1);
	}
}

void * DSTree::getValue(int * path, int npathelements)
{
	DSTreeElement * te;
	te=getElement(path, npathelements);
	if (te) return te->getDataPtr();
	return NULL;
}

unsigned int DSTree::getInt(int * path, int npathelements)
{
	DSTreeElement * te;
	te=getElement(path, npathelements);
	if (te) return te->getDataInt();
	return 0;
}


DSTreeElement * DSTree::getClosestElement(int * path, int npathelements)
{
	if (npathelements==0) {
		/* If there is only one elements in the path, we're at the data
		 * node */
		return value;
	} else {
		DSTreeElement * ret;
		if (path[0]>nNodes) return NULL;
		if (nodes[path[0]]==NULL) return value;
		/* This place already has more nodes under it. */
		ret=nodes[path[0]]->getClosestElement(&path[1], npathelements-1);
		if (ret==NULL) return value;
		return ret;
	}
}


void * DSTree::getClosestValue(int * path, int npathelements)
{
	DSTreeElement * te;
	te=getClosestElement(path, npathelements);
	if (te) return te->getDataPtr();
	return NULL;
}

unsigned int DSTree::getClosestInt(int * path, int npathelements)
{
	DSTreeElement * te;
	te=getClosestElement(path, npathelements);
	if (te) return te->getDataInt();
	return 0;
}


