/* LIBDS
 * =====
 * This software is Copyright (c) 2002-03 Malcolm Smith.
 * No warranty is provided, including but not limited to
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * This code is licenced subject to the GNU General
 * Public Licence (GPL).  See the COPYING file for more.
 */

#ifndef WIN32_NO_CONFIG_H
#include "../config.h"
#else
#include "../winconf.h"
#endif

#include "DSStrTok.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

DSStrTok::DSStrTok(char * string, char sep)
{
	char *a,*b;
	int num=0;
	a=string;
	while ((a=strchr(a,sep))) {
		num++;
		a++;
	}
	num++;
	nElements=num;

	Elements=(char **)malloc(sizeof(char *)*nElements);

	a=string;
	num=0;
	while ((b=strchr(a,sep))) {
		Elements[num]=(char *)malloc(b-a+1);
		strncpy(Elements[num],a,b-a);
		Elements[num][b-a]='\0';
		a=b+1;
		num++;
	}
	Elements[num]=(char *)malloc(strlen(a)+1);
	strcpy(Elements[num],a);
}

DSStrTok::~DSStrTok()
{
	int i;
	for (i=0;i<nElements;i++) {
		free(Elements[i]);
	}
	free(Elements);
}

char * DSStrTok::getElement(int i)
{
	if (i>=0&&i<nElements) {
		return Elements[i];
	} else
		return NULL;
}

int DSStrTok::getNumElements()
{
	return nElements;
}
