/* LIBDS
 * =====
 * This software is Copyright (c) 2002-03 Malcolm Smith.
 * No warranty is provided, including but not limited to
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * This code is licenced subject to the GNU General
 * Public Licence (GPL).  See the COPYING file for more.
 */

#ifndef WIN32_NO_CONFIG_H
#include "../config.h"
#else
#include "../winconf.h"
#endif
#ifdef HAVE_CTYPE_H
#include <ctype.h>
#endif
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "DSParams.h"

DSParams::DSParams() : DSHashTable()
{
	lsmask=0;
	lfmask=0;
}

BOOL DSParams::setFlagSwitch(char c)
{
	int flag;
	if (!isalpha(c)) return 0;
	c=tolower(c);
	flag=1<<(c-'a');
	lfmask=lfmask|flag;
	return TRUE;
}

BOOL DSParams::setStringSwitch(char c)
{
	int flag;
	if (!isalpha(c)) return 0;
	c=tolower(c);
	flag=1<<(c-'a');
	lsmask=lsmask|flag;
	return TRUE;
}

BOOL DSParams::process(int argc, char * argv[])
{
	int i;
	char c;
	int flag;
	char * upto;
	char * a;
	for (i=1;i<argc;i++) {
		upto=argv[i];
		if (*upto=='-') {
			upto++;
			while (*upto) {
				c=*upto;
				if (isalpha(c)) {
					c=tolower(c);
					flag=1<<(c-'a');
					if (flag&lsmask) {
						a=(char *)malloc(strlen(upto));
						strcpy(a,upto+1);
						insert(c,a,DSListElement::CLEANUP_VALUE_FREE);
						break;
					} else if (flag&lfmask) {
						insert(c,1,0);
					} else {
						printf("WARNING: Flag %c unknown\n",c);
					}
				}
				upto++;
			}
		} else {
			/* Not flag */
			a=(char *)malloc(strlen(upto)+1);
			strcpy(a,upto);
			insert((unsigned int)0,upto,0);
		}
	}
	return TRUE;
}

BOOL DSParams::process(char * arg)
{
	char c;
	int flag;
	char * upto;
	char * a;
	upto=arg;
	while (upto) {
		if (*upto=='-') {
			upto++;
			while (*upto) {
				c=*upto;
				if (isalpha(c)) {
					c=tolower(c);
					flag=1<<(c-'a');
					if (flag&lsmask) {
						a=(char *)malloc(strlen(upto));
						strcpy(a,upto+1);
						insert(c,a,DSListElement::CLEANUP_VALUE_FREE);
						break;
					} else if (flag&lfmask) {
						insert(c,1,0);
					} else {
						printf("WARNING: Flag %c unknown\n",c);
					}
				}
				upto++;
			}
		} else {
			/* Not flag */
			a=(char *)malloc(strlen(upto)+1);
			strcpy(a,upto);
			insert((unsigned int)0,upto,0);
			upto++;
		}
		upto=strchr(upto,' ');
	}
	return TRUE;
}


int DSParams::Process(char * ch)
{
	BOOL b;
	b=process(ch);
	if (b) return 1;
	return 0;
}

int DSParams::Process(int argc, char * argv[])
{
	BOOL b;
	b=process(argc, argv);
	if (b) return 1;
	return 0;
}


int DSParams::setFlagArg(char c)
{
	BOOL b;
	b=setFlagSwitch(c);
	if (b) return 1;
	return 0;
}

int DSParams::setStringArg(char c)
{
	BOOL b;
	b=setStringSwitch(c);
	if (b) return 1;
	return 0;
}

