/* LIBDS
 * =====
 * This software is Copyright (c) 2002-03 Malcolm Smith.
 * No warranty is provided, including but not limited to
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * This code is licenced subject to the GNU General
 * Public Licence (GPL).  See the COPYING file for more.
 */
#ifndef DS_CORE_H
#define DS_CORE_H

/*!
 * @header DSCore
 * @discussion DSCore is included if any DS header is included.  It provides
 * base functionality including data types, the libds version, and compiler
 * settings.
 */

#define LIBDS_VERSION 0x00010503

#ifndef EXPSYM
#define EXPSYM
#endif

/*!
 * @typedef BOOL
 * @discussion Create a TRUE/FALSE type called BOOL.  This already exists on Win32 and qt.
 */
typedef int BOOL;

#ifndef HAVE_TRUEFALSE
/*
Some constants, predefined on Windows.
*/
#ifndef FALSE
/*!
 * @constant FALSE
 * @discussion Define FALSE as a boolean type, if it's not already.
 */
const int FALSE = 0;
#endif
#ifndef TRUE
/*!
 * @constant TRUE
 * @discussion Define TRUE as a boolean type, if it's not already.
 */
const int TRUE = (!FALSE);
#endif
#endif

#if ( __GNUC__ == 3 && __GNUC_MINOR__ > 0 ) || __GNUC__ > 3
#define DEPRECATED    __attribute__((deprecated))
#else
#define DEPRECATED
#endif


#endif

