/* LIBDS
 * =====
 * This software is Copyright (c) 2002-03 Malcolm Smith.
 * No warranty is provided, including but not limited to
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * This code is licenced subject to the GNU General
 * Public Licence (GPL).  See the COPYING file for more.
 */

#include <DSBinaryTree.h>
#include <stdio.h>

DSBinaryTree::DSBinaryTree(): DSTree(1)
{
}

DSBinaryTree::~DSBinaryTree()
{
}

int * DSBinaryTree::generateElements(unsigned int path, int npathelements)
{
	int * buf;
	int i;
	int mask;
	buf=(int *)malloc(npathelements*sizeof(int));
	for (i=0;i<npathelements;i++) {
		mask=(0x80000000)>>i;
		if (path&mask) {
			buf[i]=1;
		} else {
			buf[i]=0;
		}
	}
	return buf;
}

BOOL DSBinaryTree::insert(unsigned int path, int npathelements, DSTreeElement * le)
{
	BOOL ret;
	int * buf;
	buf=generateElements(path, npathelements);
	ret=DSTree::insert(buf, npathelements, le);
	free(buf);
	return ret;
}

BOOL DSBinaryTree::insert(unsigned int path, int npathelements, void * data, int cleanup)
{
	DSTreeElement * te;
	te=new DSTreeElement(data, cleanup);
	return insert(path, npathelements, te);
}

BOOL DSBinaryTree::insert(unsigned int path, int npathelements, unsigned int data, int cleanup)
{
	DSTreeElement * te;
	te=new DSTreeElement(data, cleanup);
	return insert(path, npathelements, te);
}

DSTreeElement * DSBinaryTree::getElement(unsigned int path, int npathelements)
{
	int * buf;
	DSTreeElement * te;
	buf=generateElements(path, npathelements);
	te=DSTree::getElement(buf, npathelements);
	free(buf);
	return te;
}

void * DSBinaryTree::getValue(unsigned int path, int npathelements)
{
	DSTreeElement * te;
	te=getElement(path, npathelements);
	if (te) return te->getDataPtr();
	return NULL;
}

unsigned int DSBinaryTree::getInt(unsigned int path, int npathelements)
{
	DSTreeElement * te;
	te=getElement(path, npathelements);
	if (te) return te->getDataInt();
	return 0;
}

DSTreeElement * DSBinaryTree::getClosestElement(unsigned int path, int npathelements)
{
	int * buf;
	DSTreeElement * te;
	buf=generateElements(path, npathelements);
	te=DSTree::getClosestElement(buf, npathelements);
	free(buf);
	return te;
}

void * DSBinaryTree::getClosestValue(unsigned int path, int npathelements)
{
	DSTreeElement * te;
	te=getClosestElement(path, npathelements);
	if (te) return te->getDataPtr();
	return NULL;
}

unsigned int DSBinaryTree::getClosestInt(unsigned int path, int npathelements)
{
	DSTreeElement * te;
	te=getClosestElement(path, npathelements);
	if (te) return te->getDataInt();
	return 0;
}

