/*++

Copyright (C) 2019 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.0-develop.

Abstract: This is an autogenerated C++ Header file for the Node wrapper class 
 of the 3MF Library

Interface version: 2.3.1

*/


#ifndef LIB3MF_NODEWRAPPER_H
#define LIB3MF_NODEWRAPPER_H

#include "lib3mf_dynamic.h"
#include <node.h>
#include <node_object_wrap.h>
#include <string>
#include <stdexcept>

#define NODEWRAPPER_FIELDCOUNT 4
#define NODEWRAPPER_TABLEINDEX 2
#define NODEWRAPPER_HANDLEINDEX 3
/*************************************************************************************************************************
 Forward declarations 
**************************************************************************************************************************/

class CLib3MFWrapper;

/*************************************************************************************************************************
 Class CLib3MFBaseClass 
**************************************************************************************************************************/

class CLib3MFBaseClass : public node::ObjectWrap {
private:
protected:
public:
	CLib3MFBaseClass();
	static void RaiseError(v8::Isolate * isolate, std::string Message);
	static void CheckError(v8::Isolate * isolate, sLib3MFDynamicWrapperTable * sWrapperTable, Lib3MFHandle pInstance, Lib3MFResult errorCode);
	static void setHandle(Lib3MFHandle pHandle);
	static Lib3MFHandle getHandle(v8::Local<v8::Object> objecthandle);
	static sLib3MFDynamicWrapperTable * getDynamicWrapperTable(v8::Local<v8::Object> objecthandle);
};


/*************************************************************************************************************************
 Class CLib3MFBase 
**************************************************************************************************************************/
class CLib3MFBase : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void ClassTypeId(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFBase();
	~CLib3MFBase();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFWriter 
**************************************************************************************************************************/
class CLib3MFWriter : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void WriteToFile(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetStreamSize(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void WriteToBuffer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void WriteToCallback(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetProgressCallback(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetDecimalPrecision(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetDecimalPrecision(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetStrictModeActive(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetStrictModeActive(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetWarning(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetWarningCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddKeyWrappingCallback(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetContentEncryptionCallback(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFWriter();
	~CLib3MFWriter();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFReader 
**************************************************************************************************************************/
class CLib3MFReader : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void ReadFromFile(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ReadFromBuffer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ReadFromCallback(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetProgressCallback(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddRelationToRead(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveRelationToRead(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetStrictModeActive(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetStrictModeActive(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetWarning(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetWarningCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddKeyWrappingCallback(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetContentEncryptionCallback(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFReader();
	~CLib3MFReader();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFPackagePart 
**************************************************************************************************************************/
class CLib3MFPackagePart : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetPath(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetPath(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFPackagePart();
	~CLib3MFPackagePart();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFResource 
**************************************************************************************************************************/
class CLib3MFResource : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetResourceID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetUniqueResourceID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void PackagePart(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetPackagePart(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetModelResourceID(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFResource();
	~CLib3MFResource();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFResourceIterator 
**************************************************************************************************************************/
class CLib3MFResourceIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void MoveNext(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void MovePrevious(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetCurrent(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void Clone(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void Count(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFResourceIterator();
	~CLib3MFResourceIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFSliceStackIterator 
**************************************************************************************************************************/
class CLib3MFSliceStackIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentSliceStack(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFSliceStackIterator();
	~CLib3MFSliceStackIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFObjectIterator 
**************************************************************************************************************************/
class CLib3MFObjectIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentObject(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFObjectIterator();
	~CLib3MFObjectIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMeshObjectIterator 
**************************************************************************************************************************/
class CLib3MFMeshObjectIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentMeshObject(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFMeshObjectIterator();
	~CLib3MFMeshObjectIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFComponentsObjectIterator 
**************************************************************************************************************************/
class CLib3MFComponentsObjectIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentComponentsObject(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFComponentsObjectIterator();
	~CLib3MFComponentsObjectIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFTexture2DIterator 
**************************************************************************************************************************/
class CLib3MFTexture2DIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentTexture2D(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFTexture2DIterator();
	~CLib3MFTexture2DIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFBaseMaterialGroupIterator 
**************************************************************************************************************************/
class CLib3MFBaseMaterialGroupIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentBaseMaterialGroup(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFBaseMaterialGroupIterator();
	~CLib3MFBaseMaterialGroupIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFColorGroupIterator 
**************************************************************************************************************************/
class CLib3MFColorGroupIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentColorGroup(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFColorGroupIterator();
	~CLib3MFColorGroupIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFTexture2DGroupIterator 
**************************************************************************************************************************/
class CLib3MFTexture2DGroupIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentTexture2DGroup(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFTexture2DGroupIterator();
	~CLib3MFTexture2DGroupIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFCompositeMaterialsIterator 
**************************************************************************************************************************/
class CLib3MFCompositeMaterialsIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentCompositeMaterials(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFCompositeMaterialsIterator();
	~CLib3MFCompositeMaterialsIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMultiPropertyGroupIterator 
**************************************************************************************************************************/
class CLib3MFMultiPropertyGroupIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentMultiPropertyGroup(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFMultiPropertyGroupIterator();
	~CLib3MFMultiPropertyGroupIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMetaData 
**************************************************************************************************************************/
class CLib3MFMetaData : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetNameSpace(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetNameSpace(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetKey(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMustPreserve(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetMustPreserve(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetValue(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetValue(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFMetaData();
	~CLib3MFMetaData();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMetaDataGroup 
**************************************************************************************************************************/
class CLib3MFMetaDataGroup : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetMetaDataCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMetaData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMetaDataByKey(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveMetaDataByIndex(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveMetaData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMetaData(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFMetaDataGroup();
	~CLib3MFMetaDataGroup();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFObject 
**************************************************************************************************************************/
class CLib3MFObject : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetPartNumber(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetPartNumber(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void IsMeshObject(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void IsComponentsObject(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void IsValid(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetAttachmentAsThumbnail(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetThumbnailAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ClearThumbnailAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutbox(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMetaDataGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetSlicesMeshResolution(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSlicesMeshResolution(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void HasSlices(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ClearSliceStack(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSliceStack(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AssignSliceStack(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFObject();
	~CLib3MFObject();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMeshObject 
**************************************************************************************************************************/
class CLib3MFMeshObject : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetVertexCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTriangleCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetVertex(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetVertex(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddVertex(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetVertices(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTriangle(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetTriangle(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddTriangle(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTriangleIndices(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetObjectLevelProperty(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetObjectLevelProperty(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetTriangleProperties(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTriangleProperties(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetAllTriangleProperties(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAllTriangleProperties(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ClearAllProperties(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetGeometry(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void IsManifoldAndOriented(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void BeamLattice(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFMeshObject();
	~CLib3MFMeshObject();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFBeamLattice 
**************************************************************************************************************************/
class CLib3MFBeamLattice : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetMinLength(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetMinLength(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetClipping(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetClipping(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetRepresentation(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetRepresentation(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBallOptions(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetBallOptions(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBeamCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBeam(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddBeam(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetBeam(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetBeams(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBeams(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBallCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBall(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddBall(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetBall(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetBalls(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBalls(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBeamSetCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddBeamSet(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBeamSet(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFBeamLattice();
	~CLib3MFBeamLattice();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFComponent 
**************************************************************************************************************************/
class CLib3MFComponent : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetObjectResource(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetObjectResourceID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void HasTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetTransform(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFComponent();
	~CLib3MFComponent();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFComponentsObject 
**************************************************************************************************************************/
class CLib3MFComponentsObject : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void AddComponent(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetComponent(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetComponentCount(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFComponentsObject();
	~CLib3MFComponentsObject();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFBeamSet 
**************************************************************************************************************************/
class CLib3MFBeamSet : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void SetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetIdentifier(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetIdentifier(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetReferenceCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetReferences(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetReferences(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBallReferenceCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetBallReferences(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBallReferences(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFBeamSet();
	~CLib3MFBeamSet();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFBaseMaterialGroup 
**************************************************************************************************************************/
class CLib3MFBaseMaterialGroup : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAllPropertyIDs(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMaterial(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveMaterial(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetDisplayColor(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetDisplayColor(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFBaseMaterialGroup();
	~CLib3MFBaseMaterialGroup();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFColorGroup 
**************************************************************************************************************************/
class CLib3MFColorGroup : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAllPropertyIDs(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddColor(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveColor(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetColor(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetColor(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFColorGroup();
	~CLib3MFColorGroup();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFTexture2DGroup 
**************************************************************************************************************************/
class CLib3MFTexture2DGroup : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAllPropertyIDs(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddTex2Coord(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTex2Coord(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveTex2Coord(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTexture2D(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFTexture2DGroup();
	~CLib3MFTexture2DGroup();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFCompositeMaterials 
**************************************************************************************************************************/
class CLib3MFCompositeMaterials : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAllPropertyIDs(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBaseMaterialGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddComposite(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveComposite(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetComposite(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFCompositeMaterials();
	~CLib3MFCompositeMaterials();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMultiPropertyGroup 
**************************************************************************************************************************/
class CLib3MFMultiPropertyGroup : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAllPropertyIDs(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMultiProperty(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetMultiProperty(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMultiProperty(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveMultiProperty(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetLayerCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddLayer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetLayer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveLayer(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFMultiPropertyGroup();
	~CLib3MFMultiPropertyGroup();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFAttachment 
**************************************************************************************************************************/
class CLib3MFAttachment : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetPath(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetPath(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void PackagePart(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetRelationShipType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetRelationShipType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void WriteToFile(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ReadFromFile(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ReadFromCallback(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetStreamSize(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void WriteToBuffer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ReadFromBuffer(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFAttachment();
	~CLib3MFAttachment();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFTexture2D 
**************************************************************************************************************************/
class CLib3MFTexture2D : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetContentType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetContentType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTileStyleUV(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetTileStyleUV(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetFilter(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetFilter(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFTexture2D();
	~CLib3MFTexture2D();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFBuildItem 
**************************************************************************************************************************/
class CLib3MFBuildItem : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetObjectResource(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetObjectResourceID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void HasObjectTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetObjectTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetObjectTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetPartNumber(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetPartNumber(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMetaDataGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutbox(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFBuildItem();
	~CLib3MFBuildItem();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFBuildItemIterator 
**************************************************************************************************************************/
class CLib3MFBuildItemIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void MoveNext(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void MovePrevious(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetCurrent(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void Clone(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void Count(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFBuildItemIterator();
	~CLib3MFBuildItemIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFSlice 
**************************************************************************************************************************/
class CLib3MFSlice : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void SetVertices(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetVertices(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetVertexCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddPolygon(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetPolygonCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetPolygonIndices(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetPolygonIndices(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetPolygonIndexCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetZTop(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFSlice();
	~CLib3MFSlice();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFSliceStack 
**************************************************************************************************************************/
class CLib3MFSliceStack : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetBottomZ(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSliceCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSlice(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddSlice(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSliceRefCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddSliceStackReference(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSliceStackReference(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void CollapseSliceReferences(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetOwnPath(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOwnPath(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFSliceStack();
	~CLib3MFSliceStack();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFConsumer 
**************************************************************************************************************************/
class CLib3MFConsumer : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetConsumerID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetKeyID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetKeyValue(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFConsumer();
	~CLib3MFConsumer();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFAccessRight 
**************************************************************************************************************************/
class CLib3MFAccessRight : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetConsumer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetWrappingAlgorithm(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMgfAlgorithm(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetDigestMethod(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFAccessRight();
	~CLib3MFAccessRight();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFContentEncryptionParams 
**************************************************************************************************************************/
class CLib3MFContentEncryptionParams : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetEncryptionAlgorithm(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetKey(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInitializationVector(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAuthenticationTag(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetAuthenticationTag(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAdditionalAuthenticationData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetDescriptor(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetKeyUUID(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFContentEncryptionParams();
	~CLib3MFContentEncryptionParams();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFResourceData 
**************************************************************************************************************************/
class CLib3MFResourceData : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetPath(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetEncryptionAlgorithm(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetCompression(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAdditionalAuthenticationData(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFResourceData();
	~CLib3MFResourceData();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFResourceDataGroup 
**************************************************************************************************************************/
class CLib3MFResourceDataGroup : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetKeyUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddAccessRight(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FindAccessRightByConsumer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveAccessRight(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFResourceDataGroup();
	~CLib3MFResourceDataGroup();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFKeyStore 
**************************************************************************************************************************/
class CLib3MFKeyStore : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void AddConsumer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetConsumerCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetConsumer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveConsumer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FindConsumer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetResourceDataGroupCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddResourceDataGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetResourceDataGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveResourceDataGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FindResourceDataGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddResourceData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveResourceData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FindResourceData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetResourceDataCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetResourceData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetUUID(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFKeyStore();
	~CLib3MFKeyStore();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFModel 
**************************************************************************************************************************/
class CLib3MFModel : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void RootModelPart(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FindOrCreatePackagePart(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetUnit(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetUnit(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetLanguage(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetLanguage(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void QueryWriter(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void QueryReader(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetResourceByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTexture2DByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetPropertyTypeByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBaseMaterialGroupByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTexture2DGroupByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetCompositeMaterialsByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMultiPropertyGroupByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMeshObjectByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetComponentsObjectByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetColorGroupByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSliceStackByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBuildUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetBuildUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBuildItems(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutbox(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetResources(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetObjects(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMeshObjects(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetComponentsObjects(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTexture2Ds(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBaseMaterialGroups(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetColorGroups(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTexture2DGroups(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetCompositeMaterials(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMultiPropertyGroups(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSliceStacks(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void MergeToModel(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMeshObject(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddComponentsObject(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddSliceStack(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddTexture2DFromAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddBaseMaterialGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddColorGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddTexture2DGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddCompositeMaterials(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMultiPropertyGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddBuildItem(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveBuildItem(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMetaDataGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FindAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAttachmentCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void HasPackageThumbnailAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void CreatePackageThumbnailAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetPackageThumbnailAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemovePackageThumbnailAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddCustomContentType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveCustomContentType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetRandomNumberCallback(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetKeyStore(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFModel();
	~CLib3MFModel();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFWrapper 
**************************************************************************************************************************/

class CLib3MFWrapper : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetLibraryVersion(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetPrereleaseInformation(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBuildInformation(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSpecificationVersion(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void CreateModel(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void Release(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void Acquire(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetJournal(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetLastError(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSymbolLookupMethod(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RetrieveProgressMessage(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RGBAToColor(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FloatRGBAToColor(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ColorToRGBA(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ColorToFloatRGBA(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetIdentityTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetUniformScaleTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetScaleTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTranslationTransform(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFWrapper();
	~CLib3MFWrapper();
	static void Init();
	static v8::Local<v8::Object> NewInstance(const v8::FunctionCallbackInfo<v8::Value>& args);
};

#endif // LIB3MF_NODEWRAPPER_H

