import argparse
import collections

parser = argparse.ArgumentParser(description="""Compares two files generated by leanchecker -v.
Displays absolute difference of file2 timings - file 1 timings, provided absolute and relative
differences are above a threshold.""")
parser.add_argument('filename1', metavar='filename1', type=str, help='the first file')
parser.add_argument('filename2', metavar='filename1', type=str, help='the second file')

args = parser.parse_args()

d = collections.defaultdict(dict)
def read_file(name, index):
    with open(name, 'r') as f:
        for line in f.readlines():
            try:
                timing, function_name = line.split(" s: ")
                d[function_name.strip()][index] = float(timing)
            except ValueError:
                pass

read_file(args.filename1, 1)
read_file(args.filename2, 2)

RELATIVE_THRESHOLD = 0.2
ABSOLUTE_THRESHOLD = 0.5
for k in d:
    if (len(d[k]) == 2 and not (d[k][1] != 0 and 1 - RELATIVE_THRESHOLD <= d[k][2]/d[k][1] <= 1 + RELATIVE_THRESHOLD)
        and abs(d[k][2]-d[k][1]) > ABSOLUTE_THRESHOLD):
        d[k]["difference"] = d[k][2] - d[k][1]

output = [(d[k]['difference'], f"{d[k]['difference']:.6f} s: {k}") for k in d if "difference" in d[k]]
output.sort(reverse=True)
for line in output:
    print(line[1])