/*
 * LALXMLVCSInfo.h - LALXML VCS Information
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALXMLVCSINFO_H
#define _LALXMLVCSINFO_H

#include <lal/LALVCSInfoType.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \defgroup LALXMLVCSInfo_h Header LALXMLVCSInfo.h
 * \ingroup lalxml_general
 * \brief VCS information for LALXML
 */
/*@{*/

/** \name Global variables for LALXML VCS information */
/*@{*/
extern const char *const lalXMLVCSVersion;
extern const char *const lalXMLVCSId;
extern const char *const lalXMLVCSDate;
extern const char *const lalXMLVCSBranch;
extern const char *const lalXMLVCSTag;
extern const char *const lalXMLVCSAuthor;
extern const char *const lalXMLVCSCommitter;
extern const char *const lalXMLVCSStatus;
/*@}*/

/** \name Identable global variables for LALXML VCS information */
/*@{*/
extern const char *const lalXMLVCSIdentId;
extern const char *const lalXMLVCSIdentDate;
extern const char *const lalXMLVCSIdentBranch;
extern const char *const lalXMLVCSIdentTag;
extern const char *const lalXMLVCSIdentAuthor;
extern const char *const lalXMLVCSIdentCommitter;
extern const char *const lalXMLVCSIdentStatus;
/*@}*/

/** LALXML VCS information */
extern const LALVCSInfo lalXMLVCSInfo;

/** List of VCS information for LALXML and its LALSuite dependencies (<tt>NULL</tt>-terminated) */
extern const LALVCSInfo *const lalXMLVCSInfoList[32];

/** LALXML <tt>configure</tt> arguments */
extern const char *const lalXMLConfigureArgs;

/** LALXML <tt>configure</tt> date */
extern const char *const lalXMLConfigureDate;

/** LALXML build date */
extern const char *const lalXMLBuildDate;

/** Check LALXML VCS information for compile-time/run-time version mismatch */
#ifndef SWIG /* exclude from SWIG interface */
int XLALXMLVCSInfoCheck(void);
#endif /* SWIG */


/*@}*/

#ifdef __cplusplus
}
#endif

#endif /* _LALXMLVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
