%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalxml
Version: 1.2.2
Release: 1%{?dist}
Summary: LSC Algorithm XML Library
License: GPL
Group: LAL
Source: %{name}-%{version}.tar.xz
URL: https://wiki.ligo.org/DASWG/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: libxml2-devel
BuildRequires: numpy
BuildRequires: octave-devel
BuildRequires: python-devel
BuildRequires: swig
BuildRequires: lal-devel >= 6.16.1
BuildRequires: lal-python >= 6.16.1
BuildRequires: lal-octave >= 6.16.1
Requires: gsl
Requires: libxml2
Requires:lal >= 6.16.1
Prefix: %{_prefix}

%description
The LSC Algorithm XML Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL XML library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL XML
Group: LAL
Requires: %{name} = %{version}
Requires: gsl-devel
Requires: libxml2-devel
Requires: lal-devel >= 6.16.1
%description devel
The LSC Algorithm XML Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL XML
library.

%package python
Summary: Python bindings for LALXML
Group: LAL
Requires: %{name} = %{version}
Requires: numpy
Requires: python
Requires: lal-python >= 6.16.1
%description python
This package provides the Python bindings for LALXML.

%package octave
Summary: Octave bindings for LALXML
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.16.1
%description octave
This package provides the Octave bindings for LALXML.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so*
%{_sysconfdir}/*
%{_prefix}/share/lalxml/*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
%{_includedir}/lal

%files python
%defattr(-,root,root)
%{_libdir}/python*/site-packages/lalxml/*.py
%{_libdir}/python*/site-packages/lalxml/*.pyc
%{_libdir}/python*/site-packages/lalxml/_lalxml.so*
%exclude %{_libdir}/python*/site-packages/lalxml/*.pyo

%files octave
%defattr(-,root,root)
%{_prefix}/lib*/octave/*/site/oct/*/lalxml.oct*

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.2.2-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.2.1-1
- Pre O2 packaging test release
