/*
 * LALAppsVCSInfo.h - LALApps VCS Information
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALAPPSVCSINFO_H
#define _LALAPPSVCSINFO_H

#include <lal/LALVCSInfoType.h>

#ifdef __cplusplus
extern "C" {
#endif

/* global variables for vcs information */
extern const char *const lalAppsVCSVersion;
extern const char *const lalAppsVCSId;
extern const char *const lalAppsVCSDate;
extern const char *const lalAppsVCSBranch;
extern const char *const lalAppsVCSTag;
extern const char *const lalAppsVCSAuthor;
extern const char *const lalAppsVCSCommitter;
extern const char *const lalAppsVCSStatus;

/* global variables for vcs information - identable */
extern const char *const lalAppsVCSIdentId;
extern const char *const lalAppsVCSIdentDate;
extern const char *const lalAppsVCSIdentBranch;
extern const char *const lalAppsVCSIdentTag;
extern const char *const lalAppsVCSIdentAuthor;
extern const char *const lalAppsVCSIdentCommitter;
extern const char *const lalAppsVCSIdentStatus;

/* library vcs information structure */
extern const struct tagLALVCSInfo lalAppsVCSInfo;

/* configure arguments */
extern const char *const lalAppsConfigureArgs;

/* configure date */
extern const char *const lalAppsConfigureDate;

/* build date */
extern const char *const lalAppsBuildDate;

#ifdef __cplusplus
}
#endif

#endif /* _LALAPPSVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
