/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.format;

import com.google.common.base.MoreObjects;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtToken;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\u0019\u001a\u00020\u0003H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000eR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/facebook/ktfmt/format/KotlinTok;", "Lcom/google/googlejavaformat/Input$Tok;", "index", "", "originalText", "", "text", "position", "columnI", "isToken", "", "kind", "Lorg/jetbrains/kotlin/lexer/KtToken;", "(ILjava/lang/String;Ljava/lang/String;IIZLorg/jetbrains/kotlin/lexer/KtToken;)V", "()Z", "getColumn", "getIndex", "getOriginalText", "getPosition", "getText", "isComment", "isJavadocComment", "isNewline", "isSlashSlashComment", "isSlashStarComment", "length", "toString", "ktfmt"})
public final class KotlinTok
implements Input.Tok {
    private final int index;
    @NotNull
    private final String originalText;
    @NotNull
    private final String text;
    private final int position;
    private final int columnI;
    private final boolean isToken;
    @NotNull
    private final KtToken kind;

    public KotlinTok(int index, @NotNull String originalText, @NotNull String text, int position, int columnI, boolean isToken, @NotNull KtToken kind) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        this.index = index;
        this.originalText = originalText;
        this.text = text;
        this.position = position;
        this.columnI = columnI;
        this.isToken = isToken;
        this.kind = kind;
    }

    public final boolean isToken() {
        return this.isToken;
    }

    public int getIndex() {
        return this.index;
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    @NotNull
    public String getOriginalText() {
        return this.originalText;
    }

    public int length() {
        return this.originalText.length();
    }

    public int getPosition() {
        return this.position;
    }

    public int getColumn() {
        return this.columnI;
    }

    public boolean isNewline() {
        return Newlines.isNewline((String)this.text);
    }

    public boolean isSlashSlashComment() {
        return StringsKt.startsWith$default((String)this.text, (String)"//", (boolean)false, (int)2, null);
    }

    public boolean isSlashStarComment() {
        return StringsKt.startsWith$default((String)this.text, (String)"/*", (boolean)false, (int)2, null);
    }

    public boolean isJavadocComment() {
        return StringsKt.startsWith$default((String)this.text, (String)"/**", (boolean)false, (int)2, null) && this.text.length() > 4;
    }

    public boolean isComment() {
        return this.isSlashSlashComment() || this.isSlashStarComment();
    }

    @NotNull
    public final KtToken kind() {
        return this.kind;
    }

    @NotNull
    public String toString() {
        String string = MoreObjects.toStringHelper(this).add("index", this.index).add("text", this.text).add("position", this.position).add("columnI", this.columnI).add("isToken", this.isToken).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toStringHelper(this)\n   \u2026oken)\n        .toString()");
        return string;
    }
}

