/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Function;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.TextColumnType;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u001a\u0010\u0004\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001f\u0010\u0004\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/exposed/sql/Concat;", "Lorg/jetbrains/exposed/sql/Function;", "", "separator", "expr", "", "Lorg/jetbrains/exposed/sql/Expression;", "(Ljava/lang/String;[Lorg/jetbrains/exposed/sql/Expression;)V", "getExpr", "()[Lorg/jetbrains/exposed/sql/Expression;", "[Lorg/jetbrains/exposed/sql/Expression;", "getSeparator", "()Ljava/lang/String;", "toQueryBuilder", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "exposed-core"})
public final class Concat
extends Function<String> {
    @NotNull
    private final String separator;
    @NotNull
    private final Expression<?>[] expr;

    public Concat(@NotNull String separator, Expression<?> ... expr) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        super(new TextColumnType(null, false, 3, null));
        this.separator = separator;
        this.expr = expr;
    }

    @NotNull
    public final String getSeparator() {
        return this.separator;
    }

    @NotNull
    public final Expression<?>[] getExpr() {
        return this.expr;
    }

    @Override
    public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        Expression<?>[] expressionArray = this.expr;
        DefaultKt.getCurrentDialect().getFunctionProvider().concat(this.separator, queryBuilder, Arrays.copyOf(expressionArray, expressionArray.length));
    }
}

