/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.fir.analysis.LighterTreeElementFinderByType;
import org.jetbrains.kotlin.fir.analysis.PsiElementFinderByType;
import org.jetbrains.kotlin.fir.declarations.FirImport;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a4\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a4\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u00112\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a2\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010\u0012\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a2\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a8\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\b*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"IMPORT_PARENT_TOKEN_TYPES", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "buildChildSourceElement", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "childNode", "Lcom/intellij/lang/LighterASTNode;", "getChild", "Lorg/jetbrains/kotlin/KtSourceElement;", "types", "", "Lcom/intellij/psi/tree/IElementType;", "index", "", "depth", "reverse", "", "Lorg/jetbrains/kotlin/KtPsiSourceElement;", "type", "getSourceForImportSegment", "Lorg/jetbrains/kotlin/fir/declarations/FirImport;", "indexFromLast", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSourceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSourceUtils.kt\norg/jetbrains/kotlin/fir/analysis/FirSourceUtilsKt\n+ 2 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n515#2,4:73\n521#2,6:77\n1#3:83\n*S KotlinDebug\n*F\n+ 1 FirSourceUtils.kt\norg/jetbrains/kotlin/fir/analysis/FirSourceUtilsKt\n*L\n36#1:73,4\n50#1:77,6\n*E\n"})
public final class FirSourceUtilsKt {
    @NotNull
    private static final TokenSet IMPORT_PARENT_TOKEN_TYPES;

    @Nullable
    public static final KtSourceElement getChild(@NotNull KtSourceElement $this$getChild, @NotNull IElementType type2, int index2, int depth, boolean reverse) {
        Intrinsics.checkNotNullParameter((Object)$this$getChild, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return FirSourceUtilsKt.getChild($this$getChild, (Set<? extends IElementType>)SetsKt.setOf((Object)type2), index2, depth, reverse);
    }

    public static /* synthetic */ KtSourceElement getChild$default(KtSourceElement ktSourceElement, IElementType iElementType, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return FirSourceUtilsKt.getChild(ktSourceElement, iElementType, n, n2, bl);
    }

    @Nullable
    public static final KtSourceElement getChild(@NotNull KtSourceElement $this$getChild, @NotNull TokenSet types2, int index2, int depth, boolean reverse) {
        Intrinsics.checkNotNullParameter((Object)$this$getChild, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)types2, (String)"types");
        IElementType[] iElementTypeArray = types2.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"types.types");
        return FirSourceUtilsKt.getChild($this$getChild, (Set<? extends IElementType>)ArraysKt.toSet((Object[])iElementTypeArray), index2, depth, reverse);
    }

    public static /* synthetic */ KtSourceElement getChild$default(KtSourceElement ktSourceElement, TokenSet tokenSet, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return FirSourceUtilsKt.getChild(ktSourceElement, tokenSet, n, n2, bl);
    }

    @Nullable
    public static final KtSourceElement getChild(@NotNull KtSourceElement $this$getChild, @NotNull Set<? extends IElementType> types2, int index2, int depth, boolean reverse) {
        Intrinsics.checkNotNullParameter((Object)$this$getChild, (String)"<this>");
        Intrinsics.checkNotNullParameter(types2, (String)"types");
        KtSourceElement ktSourceElement = $this$getChild;
        return ktSourceElement instanceof KtPsiSourceElement ? FirSourceUtilsKt.getChild((KtPsiSourceElement)$this$getChild, types2, index2, depth, reverse) : (ktSourceElement instanceof KtLightSourceElement ? FirSourceUtilsKt.getChild((KtLightSourceElement)$this$getChild, types2, index2, depth, reverse) : null);
    }

    public static /* synthetic */ KtSourceElement getChild$default(KtSourceElement ktSourceElement, Set set, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return FirSourceUtilsKt.getChild(ktSourceElement, (Set<? extends IElementType>)set, n, n2, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final KtSourceElement getChild(KtPsiSourceElement $this$getChild, Set<? extends IElementType> types2, int index2, int depth, boolean reverse) {
        KtPsiSourceElement ktPsiSourceElement;
        PsiElementFinderByType visitor2 = new PsiElementFinderByType((Collection<? extends IElementType>)types2, index2, depth, reverse);
        PsiElement psiElement = visitor2.find($this$getChild.getPsi());
        if (psiElement != null) {
            PsiElement $this$toKtPsiSourceElement_u24default$iv = psiElement;
            KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
            boolean $i$f$toKtPsiSourceElement = false;
            KtSourceElementKind ktSourceElementKind = kind$iv;
            if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv);
                return ktPsiSourceElement;
            } else {
                if (!(ktSourceElementKind instanceof KtFakeSourceElementKind)) throw new NoWhenBranchMatchedException();
                ktPsiSourceElement = new KtFakeSourceElement($this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
            }
            return ktPsiSourceElement;
        } else {
            ktPsiSourceElement = null;
        }
        return ktPsiSourceElement;
    }

    private static final KtSourceElement getChild(KtLightSourceElement $this$getChild, Set<? extends IElementType> types2, int index2, int depth, boolean reverse) {
        LighterTreeElementFinderByType visitor2 = new LighterTreeElementFinderByType($this$getChild.getTreeStructure(), (Collection<? extends IElementType>)types2, index2, depth, reverse);
        LighterASTNode lighterASTNode2 = visitor2.find($this$getChild.getLighterASTNode());
        if (lighterASTNode2 == null) {
            return null;
        }
        LighterASTNode childNode = lighterASTNode2;
        return FirSourceUtilsKt.buildChildSourceElement($this$getChild, childNode);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtLightSourceElement buildChildSourceElement(@NotNull KtLightSourceElement $this$buildChildSourceElement, @NotNull LighterASTNode childNode) {
        void tree$iv;
        void endOffset$iv;
        void startOffset$iv;
        void $this$toKtLightSourceElement_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)$this$buildChildSourceElement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)childNode, (String)"childNode");
        int offsetDelta = $this$buildChildSourceElement.getStartOffset() - $this$buildChildSourceElement.getLighterASTNode().getStartOffset();
        LighterASTNode lighterASTNode2 = childNode;
        FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = $this$buildChildSourceElement.getTreeStructure();
        int n = childNode.getStartOffset() + offsetDelta;
        int n2 = childNode.getEndOffset() + offsetDelta;
        KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
        boolean $i$f$toKtLightSourceElement = false;
        return new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, (int)startOffset$iv, (int)endOffset$iv, (FlyweightCapableTreeStructure<LighterASTNode>)tree$iv, kind$iv);
    }

    @Nullable
    public static final KtSourceElement getSourceForImportSegment(@NotNull FirImport $this$getSourceForImportSegment, int indexFromLast) {
        KtSourceElement ktSourceElement;
        Intrinsics.checkNotNullParameter((Object)$this$getSourceForImportSegment, (String)"<this>");
        KtSourceElement segmentSource = null;
        KtSourceElement ktSourceElement2 = $this$getSourceForImportSegment.getSource();
        if (ktSourceElement2 == null) {
            return null;
        }
        segmentSource = ktSourceElement2;
        int n = indexFromLast + 1;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            if (FirSourceUtilsKt.getChild$default(segmentSource, IMPORT_PARENT_TOKEN_TYPES, 0, 1, false, 10, null) != null) continue;
            return null;
        }
        KtSourceElement it = ktSourceElement = segmentSource;
        boolean bl = false;
        KtSourceElement ktSourceElement3 = Intrinsics.areEqual((Object)it.getElementType(), (Object)KtNodeTypes.REFERENCE_EXPRESSION) ? ktSourceElement : null;
        if (ktSourceElement3 == null) {
            IElementType iElementType = KtNodeTypes.REFERENCE_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"REFERENCE_EXPRESSION");
            ktSourceElement3 = FirSourceUtilsKt.getChild$default(segmentSource, iElementType, 0, 1, true, 2, null);
        }
        return ktSourceElement3;
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{KtNodeTypes.DOT_QUALIFIED_EXPRESSION, KtNodeTypes.REFERENCE_EXPRESSION};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(KtNodeTypes.DOT_Q\u2026pes.REFERENCE_EXPRESSION)");
        IMPORT_PARENT_TOKEN_TYPES = tokenSet;
    }
}

