/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.KotlinModificationTrackerService;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclarationKt;
import org.jetbrains.kotlin.cli.jvm.compiler.ClassFilterForFacade;
import org.jetbrains.kotlin.cli.jvm.compiler.CliExtraDiagnosticsProviderKt;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.builder.CodeGenerationResult;
import org.jetbrains.kotlin.cli.jvm.compiler.builder.LightClassBuilderKt;
import org.jetbrains.kotlin.cli.jvm.compiler.builder.LightClassConstructionContext;
import org.jetbrains.kotlin.codegen.MultifileClassCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/CliExtraDiagnosticsProvider;", "", "()V", "calculateForFacade", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "forClassOrObject", "kclass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "forFacade", "cli"})
@SourceDebugExtension(value={"SMAP\nCliExtraDiagnosticsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliExtraDiagnosticsProvider.kt\norg/jetbrains/kotlin/cli/jvm/compiler/CliExtraDiagnosticsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class CliExtraDiagnosticsProvider {
    @NotNull
    public static final CliExtraDiagnosticsProvider INSTANCE;

    @NotNull
    public final Diagnostics forClassOrObject(@NotNull KtClassOrObject kclass) {
        Intrinsics.checkNotNullParameter((Object)kclass, (String)"kclass");
        if (KtLightClassForSourceDeclarationKt.shouldNotBeVisibleAsLightClass(kclass)) {
            return Diagnostics.Companion.getEMPTY();
        }
        Object t = CliExtraDiagnosticsProviderKt.access$getLightClassCachedValue(kclass).getValue();
        Intrinsics.checkNotNullExpressionValue(t, (String)"getLightClassCachedValue(kclass).value");
        return (Diagnostics)t;
    }

    @NotNull
    public final Diagnostics forFacade(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Object t = CachedValuesManager.getCachedValue(file2, new CachedValueProvider(file2){
            final /* synthetic */ KtFile $file;

            @Nullable
            public final CachedValueProvider.Result<Diagnostics> compute() {
                Diagnostics diagnostics2 = CliExtraDiagnosticsProvider.access$calculateForFacade(CliExtraDiagnosticsProvider.INSTANCE, this.$file);
                Object[] objectArray = new Object[1];
                Project project = this.$file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                objectArray[0] = KotlinModificationTrackerService.Companion.getInstance(project).getOutOfBlockModificationTracker();
                return CachedValueProvider.Result.create(diagnostics2, objectArray);
            }
            {
                this.$file = ktFile;
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"CachedValuesManager.getC\u2026nTracker,\n        )\n    }");
        return (Diagnostics)t;
    }

    private final Diagnostics calculateForFacade(KtFile file2) {
        Project project = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        Project project2 = project;
        FqName facadeFqName = JvmFileClassUtilKt.getJavaFileFacadeFqName(file2);
        KotlinAsJavaSupport kotlinAsJavaSupport = KotlinAsJavaSupport.Companion.getInstance(project2);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(project2);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
        Collection<KtFile> collection = kotlinAsJavaSupport.findFilesForFacade(facadeFqName, globalSearchScope);
        if (collection.isEmpty()) {
            boolean bl = false;
            return Diagnostics.Companion.getEMPTY();
        }
        Collection<KtFile> facadeCollection = collection;
        LightClassGenerationSupport lightClassGenerationSupport = LightClassGenerationSupport.Companion.getInstance(project2);
        if (lightClassGenerationSupport == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport");
        }
        LightClassConstructionContext context = ((CliLightClassGenerationSupport)lightClassGenerationSupport).getContext();
        FqName fqName2 = facadeFqName.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"facadeFqName.parent()");
        CodeGenerationResult codeGenerationResult = LightClassBuilderKt.extraJvmDiagnosticsFromBackend(fqName2, facadeCollection, ClassFilterForFacade.INSTANCE, context, (Function2<? super GenerationState, ? super Collection<? extends KtFile>, Unit>)((Function2)new Function2<GenerationState, Collection<? extends KtFile>, Unit>(facadeFqName){
            final /* synthetic */ FqName $facadeFqName;

            public final void invoke(@NotNull GenerationState state, @NotNull Collection<? extends KtFile> files2) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter(files2, (String)"files");
                KtFile representativeFile = (KtFile)CollectionsKt.first((Iterable)files2);
                JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(representativeFile);
                if (!fileClassInfo.getWithJvmMultifileClass()) {
                    PackageCodegen packageCodegen = state.getFactory().forPackage(representativeFile.getPackageFqName(), files2);
                    Intrinsics.checkNotNullExpressionValue((Object)packageCodegen, (String)"state.factory.forPackage\u2026ile.packageFqName, files)");
                    PackageCodegen codegen2 = packageCodegen;
                    codegen2.generate();
                    state.getFactory().done();
                    return;
                }
                MultifileClassCodegen multifileClassCodegen = state.getFactory().forMultifileClass(this.$facadeFqName, files2);
                Intrinsics.checkNotNullExpressionValue((Object)multifileClassCodegen, (String)"state.factory.forMultifi\u2026lass(facadeFqName, files)");
                MultifileClassCodegen codegen3 = multifileClassCodegen;
                codegen3.generate();
                state.getFactory().done();
            }
            {
                this.$facadeFqName = fqName2;
                super(2);
            }
        }));
        Diagnostics diagnostics2 = codeGenerationResult.component3();
        return diagnostics2;
    }

    private CliExtraDiagnosticsProvider() {
    }

    static {
        CliExtraDiagnosticsProvider cliExtraDiagnosticsProvider;
        INSTANCE = cliExtraDiagnosticsProvider = new CliExtraDiagnosticsProvider();
    }

    public static final /* synthetic */ Diagnostics access$calculateForFacade(CliExtraDiagnosticsProvider $this, KtFile file2) {
        return $this.calculateForFacade(file2);
    }
}

