/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.openapi.util.Key;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.ConflictFilterProcessor;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MethodsProcessor
extends ConflictFilterProcessor
implements ElementClassHint {
    private static final ElementFilter ourFilter = ElementClassFilter.METHOD;
    private boolean myStaticScopeFlag;
    private boolean myIsConstructor;
    protected PsiElement myCurrentFileContext;
    PsiClass myAccessClass;
    private PsiExpressionList myArgumentList;
    private PsiType[] myTypeArguments;
    private final LanguageLevel myLanguageLevel;

    MethodsProcessor(PsiConflictResolver @NotNull [] resolvers, @NotNull List<CandidateInfo> container, @NotNull PsiElement place, @NotNull PsiFile placeFile) {
        if (container == null) {
            MethodsProcessor.$$$reportNull$$$0(0);
        }
        if (place == null) {
            MethodsProcessor.$$$reportNull$$$0(1);
        }
        if (placeFile == null) {
            MethodsProcessor.$$$reportNull$$$0(2);
        }
        if (resolvers == null) {
            MethodsProcessor.$$$reportNull$$$0(3);
        }
        super(null, ourFilter, resolvers, container, place, placeFile);
        this.myLanguageLevel = PsiUtil.getLanguageLevel(placeFile);
    }

    public PsiExpressionList getArgumentList() {
        return this.myArgumentList;
    }

    public void setArgumentList(@Nullable PsiExpressionList argList) {
        this.myArgumentList = argList;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel;
        if (languageLevel == null) {
            MethodsProcessor.$$$reportNull$$$0(4);
        }
        return languageLevel;
    }

    public void obtainTypeArguments(@NotNull PsiCallExpression callExpression) {
        PsiType[] typeArguments;
        if (callExpression == null) {
            MethodsProcessor.$$$reportNull$$$0(5);
        }
        if ((typeArguments = callExpression.getTypeArguments()).length > 0) {
            this.setTypeArguments(typeArguments);
        }
    }

    private void setTypeArguments(PsiType[] typeParameters2) {
        this.myTypeArguments = typeParameters2;
    }

    public PsiType[] getTypeArguments() {
        return this.myTypeArguments;
    }

    boolean isInStaticScope() {
        return this.myStaticScopeFlag;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            MethodsProcessor.$$$reportNull$$$0(6);
        }
        if (JavaScopeProcessorEvent.isEnteringStaticScope(event, associated)) {
            this.myStaticScopeFlag = true;
        } else if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event)) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    public void setAccessClass(PsiClass accessClass) {
        this.myAccessClass = accessClass;
    }

    public boolean isConstructor() {
        return this.myIsConstructor;
    }

    public PsiElement getCurrentFileContext() {
        return this.myCurrentFileContext;
    }

    public void setIsConstructor(boolean myIsConstructor) {
        this.myIsConstructor = myIsConstructor;
    }

    public void forceAddResult(@NotNull PsiMethod method) {
        if (method == null) {
            MethodsProcessor.$$$reportNull$$$0(7);
        }
        this.add(new CandidateInfo(method, PsiSubstitutor.EMPTY, false, false, this.myCurrentFileContext));
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            MethodsProcessor.$$$reportNull$$$0(8);
        }
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }

    @Override
    public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind) {
        if (kind == null) {
            MethodsProcessor.$$$reportNull$$$0(9);
        }
        return kind == ElementClassHint.DeclarationKind.METHOD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/scope/processor/MethodsProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintKey";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/scope/processor/MethodsProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "obtainTypeArguments";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forceAddResult";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcess";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

