/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt;

import com.intellij.openapi.util.text.StringUtil;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.javacs.kt.SourcePath;
import org.javacs.kt.SourceVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u0007H\u0086\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0007J\u0014\u0010\u0011\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0007J\u0019\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\bH\u0086\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/javacs/kt/NotifySourcePath;", "", "sp", "Lorg/javacs/kt/SourcePath;", "(Lorg/javacs/kt/SourcePath;)V", "files", "", "Ljava/net/URI;", "Lorg/javacs/kt/SourceVersion;", "keys", "", "getKeys", "()Ljava/util/Set;", "get", "uri", "remove", "", "removeAll", "rm", "", "removeIfTemporary", "", "set", "source", "server"})
@SourceDebugExtension(value={"SMAP\nSourceFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceFiles.kt\norg/javacs/kt/NotifySourcePath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n1855#2,2:242\n*S KotlinDebug\n*F\n+ 1 SourceFiles.kt\norg/javacs/kt/NotifySourcePath\n*L\n57#1:242,2\n*E\n"})
final class NotifySourcePath {
    @NotNull
    private final SourcePath sp;
    @NotNull
    private final Map<URI, SourceVersion> files;

    public NotifySourcePath(@NotNull SourcePath sp) {
        Intrinsics.checkNotNullParameter((Object)sp, (String)"sp");
        this.sp = sp;
        this.files = new LinkedHashMap();
    }

    @Nullable
    public final SourceVersion get(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.files.get(uri);
    }

    public final void set(@NotNull URI uri, @NotNull SourceVersion source) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String string = StringUtil.convertLineSeparators((String)source.getContent());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        String content = string;
        this.files.put(uri, source);
        this.sp.put(uri, content, source.getLanguage(), source.isTemporary());
    }

    public final void remove(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.files.remove(uri);
        this.sp.delete(uri);
    }

    public final boolean removeIfTemporary(@NotNull URI uri) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (this.sp.deleteIfTemporary(uri)) {
            this.files.remove(uri);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeAll(@NotNull Collection<URI> rm) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter(rm, (String)"rm");
        CollectionsKt.removeAll((Collection)this.files.keySet(), (Iterable)rm);
        Iterable iterable = rm;
        SourcePath sourcePath = this.sp;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            URI p0 = (URI)element$iv;
            boolean bl = false;
            sourcePath.delete(p0);
        }
    }

    @NotNull
    public final Set<URI> getKeys() {
        return this.files.keySet();
    }
}

