/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/types/ConeFlexibleTypeBoundsChecker;", "", "()V", "baseTypesToMutableEquivalent", "", "Lorg/jetbrains/kotlin/name/ClassId;", "mutableToBaseMap", "areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability", "", "a", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "b", "getBaseBoundFqNameByMutability", "providers"})
public final class ConeFlexibleTypeBoundsChecker {
    @NotNull
    public static final ConeFlexibleTypeBoundsChecker INSTANCE;
    @NotNull
    private static final Map<ClassId, ClassId> baseTypesToMutableEquivalent;
    @NotNull
    private static final Map<ClassId, ClassId> mutableToBaseMap;

    private ConeFlexibleTypeBoundsChecker() {
    }

    public final boolean areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability(@NotNull ConeKotlinType a, @NotNull ConeKotlinType b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        ClassId classId = ConeTypeUtilsKt.getClassId(a);
        if (classId == null) {
            return false;
        }
        ClassId classId2 = classId;
        ClassId classId3 = baseTypesToMutableEquivalent.get(classId2);
        if (classId3 == null && (classId3 = mutableToBaseMap.get(classId2)) == null) {
            return false;
        }
        ClassId possiblePairBound = classId3;
        return Intrinsics.areEqual((Object)possiblePairBound, (Object)ConeTypeUtilsKt.getClassId(b));
    }

    @Nullable
    public final ClassId getBaseBoundFqNameByMutability(@NotNull ConeKotlinType a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        ClassId classId = ConeTypeUtilsKt.getClassId(a);
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        if (baseTypesToMutableEquivalent.containsKey(classId2)) {
            return classId2;
        }
        return mutableToBaseMap.get(classId2);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        INSTANCE = new ConeFlexibleTypeBoundsChecker();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)StandardClassIds.INSTANCE.getIterable(), (Object)StandardClassIds.INSTANCE.getMutableIterable()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getIterator(), (Object)StandardClassIds.INSTANCE.getMutableIterator()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getListIterator(), (Object)StandardClassIds.INSTANCE.getMutableListIterator()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getList(), (Object)StandardClassIds.INSTANCE.getMutableList()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getCollection(), (Object)StandardClassIds.INSTANCE.getMutableCollection()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getSet(), (Object)StandardClassIds.INSTANCE.getMutableSet()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getMap(), (Object)StandardClassIds.INSTANCE.getMutableMap()), TuplesKt.to((Object)StandardClassIds.INSTANCE.getMapEntry(), (Object)StandardClassIds.INSTANCE.getMutableMapEntry())};
        baseTypesToMutableEquivalent = MapsKt.mapOf((Pair[])pairArray);
        Iterable $this$associateBy$iv = baseTypesToMutableEquivalent.entrySet();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            ClassId classId = (ClassId)it.getValue();
            boolean bl2 = false;
            ClassId classId2 = (ClassId)it.getKey();
            map.put(classId, classId2);
        }
        mutableToBaseMap = destination$iv$iv;
    }
}

