/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.inline;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\nH\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/inline/InlinerExpressionLocationHint;", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "inlineAtSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)V", "functionFileOrNull", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getFunctionFileOrNull", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "functionNameOrDefaultToString", "", "getFunctionNameOrDefaultToString", "()Ljava/lang/String;", "getInlineAtSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "toString", "ir.backend.common"})
public final class InlinerExpressionLocationHint
implements IrStatementOrigin {
    @NotNull
    private final IrSymbol inlineAtSymbol;

    public InlinerExpressionLocationHint(@NotNull IrSymbol inlineAtSymbol) {
        Intrinsics.checkNotNullParameter((Object)inlineAtSymbol, (String)"inlineAtSymbol");
        this.inlineAtSymbol = inlineAtSymbol;
    }

    @NotNull
    public final IrSymbol getInlineAtSymbol() {
        return this.inlineAtSymbol;
    }

    @NotNull
    public String toString() {
        Object object;
        return '(' + this.getClass().getSimpleName() + " : " + this.getFunctionNameOrDefaultToString() + " @" + ((object = this.getFunctionFileOrNull()) != null && (object = ((IrFile)object).getFileEntry()) != null ? object.getName() : null) + ')';
    }

    private final IrFile getFunctionFileOrNull() {
        IrSymbol irSymbol2 = this.inlineAtSymbol;
        IrFunction irFunction2 = irSymbol2 instanceof IrFunction ? (IrFunction)((Object)irSymbol2) : null;
        return irFunction2 != null ? IrUtilsKt.getFile(irFunction2) : null;
    }

    private final String getFunctionNameOrDefaultToString() {
        String string2;
        IrSymbol irSymbol2 = this.inlineAtSymbol;
        Object object = irSymbol2 instanceof IrFunction ? (IrFunction)((Object)irSymbol2) : null;
        if ((object != null && (object = object.getName()) != null ? ((Name)object).asString() : (string2 = null)) == null) {
            string2 = this.inlineAtSymbol.toString();
        }
        return string2;
    }
}

