/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsStatementTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u0014J\f\u0010\u0017\u001a\u00020\u0006*\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;)V", "isExpression", "", "lastStatementTransformer", "Lkotlin/Function1;", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;ZLkotlin/jvm/functions/Function1;)V", "jsEqeq", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "jsEqeqeq", "buildJsSwitch", "switch", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchData;", "detectSwitch", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "tryOptimize", "irWhen", "isSuitableForSwitch", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isTrueConstant", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "SwitchBranchData", "SwitchData", "backend.js"})
@SourceDebugExtension(value={"SMAP\nSwitchOptimizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwitchOptimizer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n1549#2:190\n1620#2,2:191\n1622#2:194\n1#3:193\n*S KotlinDebug\n*F\n+ 1 SwitchOptimizer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer\n*L\n145#1:190\n145#1:191,2\n145#1:194\n*E\n"})
public final class SwitchOptimizer {
    @NotNull
    private final JsGenerationContext context;
    private final boolean isExpression;
    @NotNull
    private final Function1<Function0<? extends JsStatement>, JsStatement> lastStatementTransformer;
    @NotNull
    private final IrSimpleFunctionSymbol jsEqeqeq;
    @NotNull
    private final IrSimpleFunctionSymbol jsEqeq;

    public SwitchOptimizer(@NotNull JsGenerationContext context2, boolean isExpression, @NotNull Function1<? super Function0<? extends JsStatement>, ? extends JsStatement> lastStatementTransformer2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(lastStatementTransformer2, (String)"lastStatementTransformer");
        this.context = context2;
        this.isExpression = isExpression;
        this.lastStatementTransformer = lastStatementTransformer2;
        this.jsEqeqeq = this.context.getStaticContext().getBackendContext().getIntrinsics().getJsEqeqeq();
        this.jsEqeq = this.context.getStaticContext().getBackendContext().getIntrinsics().getJsEqeq();
    }

    public SwitchOptimizer(@NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this(context2, false, (Function1<? super Function0<? extends JsStatement>, ? extends JsStatement>)((Function1)1.INSTANCE));
    }

    private final boolean isTrueConstant(IrConst<?> $this$isTrueConstant) {
        if ($this$isTrueConstant.getKind() != IrConstKind.Boolean.INSTANCE) {
            return false;
        }
        Object obj = $this$isTrueConstant.getValue();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Boolean");
        return (Boolean)obj;
    }

    private final SwitchData detectSwitch(IrWhen expression2) {
        Ref.ObjectRef varSymbol = new Ref.ObjectRef();
        List cases = new ArrayList();
        int caseCount = 0;
        for (IrBranch branch : expression2.getBranches()) {
            IrExpression condition = branch.getCondition();
            if (condition instanceof IrCall) {
                IrConst<?> constant;
                if (SwitchOptimizer.detectSwitch$tryToExtractEqeqeqConst(this, (Ref.ObjectRef<IrValueSymbol>)varSymbol, (IrCall)condition) == null) {
                    return null;
                }
                ++caseCount;
                ((Collection)cases).add(new SwitchBranchData.SwitchCaseData(CollectionsKt.listOf(constant), branch.getResult()));
                continue;
            }
            if (condition instanceof IrWhen) {
                List orConstants = new ArrayList();
                if (SwitchOptimizer.detectSwitch$checkForPrimitiveOrPattern(this, (Ref.ObjectRef<IrValueSymbol>)varSymbol, (IrWhen)condition, orConstants)) {
                    caseCount += orConstants.size();
                    ((Collection)cases).add(new SwitchBranchData.SwitchCaseData(orConstants, branch.getResult()));
                    continue;
                }
                return null;
            }
            if (condition instanceof IrConst) {
                if (!this.isTrueConstant((IrConst)condition)) continue;
                ++caseCount;
                ((Collection)cases).add(new SwitchBranchData.SwitchDefaultData(branch.getResult()));
                break;
            }
            return null;
        }
        IrValueSymbol s = (IrValueSymbol)varSymbol.element;
        if (caseCount < 3) {
            return null;
        }
        Object object = s;
        boolean bl = object != null && (object = object.getOwner()) != null && (object = object.getType()) != null ? this.isSuitableForSwitch((IrType)object) : false;
        if (bl) {
            return new SwitchData(s, cases);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final JsStatement buildJsSwitch(SwitchData switchData) {
        IrElementToJsExpressionTransformer exprTransformer = new IrElementToJsExpressionTransformer();
        IrElementToJsStatementTransformer stmtTransformer2 = new IrElementToJsStatementTransformer();
        JsNameRef jsNameRef = this.context.getNameForValueDeclaration(switchData.getSubject().getOwner()).makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"makeRef(...)");
        JsNameRef jsExpr = jsNameRef;
        List jsCases = new ArrayList();
        for (SwitchBranchData switchBranchData : switchData.getCases()) {
            JsStatement lastStatement2;
            JsStatement jsStatement;
            JsSwitchMember jsCase;
            JsSwitchMember jsSwitchMember;
            Iterable iterable;
            Object object;
            if (switchBranchData instanceof SwitchBranchData.SwitchCaseData) {
                void $this$mapTo$iv$iv;
                object = jsCases;
                Iterable $this$map$iv = ((SwitchBranchData.SwitchCaseData)switchBranchData).getCases();
                boolean $i$f$map = false;
                iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsCase jsCase2;
                    IrConst irConst = (IrConst)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    JsCase $this$buildJsSwitch_u24lambda_u241_u24lambda_u240 = jsCase2 = new JsCase();
                    boolean bl2 = false;
                    $this$buildJsSwitch_u24lambda_u241_u24lambda_u240.setCaseExpression((JsExpression)it.accept(exprTransformer, this.context));
                    collection.add(jsCase2);
                }
                $this$map$iv = (List)destination$iv$iv;
                CollectionsKt.addAll((Collection)object, (Iterable)$this$map$iv);
                jsSwitchMember = (JsSwitchMember)CollectionsKt.last((List)jsCases);
            } else {
                Object it = object = new JsDefault();
                boolean bl = false;
                ((Collection)jsCases).add(it);
                jsSwitchMember = jsCase = (JsSwitchMember)object;
            }
            if (this.isExpression) {
                JsStatement lastStatement3 = (JsStatement)this.lastStatementTransformer.invoke((Object)new Function0<JsStatement>(switchBranchData, exprTransformer, this){
                    final /* synthetic */ SwitchBranchData $case;
                    final /* synthetic */ IrElementToJsExpressionTransformer $exprTransformer;
                    final /* synthetic */ SwitchOptimizer this$0;
                    {
                        this.$case = $case;
                        this.$exprTransformer = $exprTransformer;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final JsStatement invoke() {
                        JsStatement jsStatement = ((JsExpression)this.$case.getBody().accept(this.$exprTransformer, SwitchOptimizer.access$getContext$p(this.this$0))).makeStmt();
                        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
                        return jsStatement;
                    }
                });
                List<JsStatement> list2 = jsCase.getStatements();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getStatements(...)");
                ((Collection)list2).add(lastStatement3);
                jsStatement = lastStatement3;
            } else {
                JsStatement jsStatement2;
                JsBlock jsBody = JsAstUtilsKt.asBlock((JsStatement)switchBranchData.getBody().accept(stmtTransformer2, this.context));
                List<JsStatement> list3 = jsBody.getStatements();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"getStatements(...)");
                if ((JsStatement)CollectionsKt.lastOrNull(list3) != null) {
                    JsStatement it;
                    boolean bl = false;
                    jsStatement2 = (JsStatement)this.lastStatementTransformer.invoke((Object)new Function0<JsStatement>(it){
                        final /* synthetic */ JsStatement $it;
                        {
                            this.$it = $it;
                            super(0);
                        }

                        @NotNull
                        public final JsStatement invoke() {
                            return this.$it;
                        }
                    });
                } else {
                    jsStatement2 = null;
                }
                JsStatement lastStatement4 = jsStatement2;
                List<JsStatement> list4 = jsCase.getStatements();
                Intrinsics.checkNotNullExpressionValue(list4, (String)"getStatements(...)");
                iterable = list4;
                List<JsStatement> list5 = jsBody.getStatements();
                Intrinsics.checkNotNullExpressionValue(list5, (String)"getStatements(...)");
                CollectionsKt.addAll((Collection)iterable, (Iterable)list5);
                if (lastStatement4 != null) {
                    List<JsStatement> list6 = jsCase.getStatements();
                    List<JsStatement> list7 = jsCase.getStatements();
                    Intrinsics.checkNotNullExpressionValue(list7, (String)"getStatements(...)");
                    list6.set(CollectionsKt.getLastIndex(list7), lastStatement4);
                }
                jsStatement = lastStatement4;
            }
            if ((lastStatement2 = jsStatement) instanceof JsBreak || lastStatement2 instanceof JsContinue || lastStatement2 instanceof JsReturn || lastStatement2 instanceof JsThrow) continue;
            List<JsStatement> list8 = jsCase.getStatements();
            Intrinsics.checkNotNullExpressionValue(list8, (String)"getStatements(...)");
            Collection collection = list8;
            collection.add(new JsBreak());
        }
        return new JsSwitch(jsExpr, jsCases);
    }

    private final boolean isSuitableForSwitch(IrType $this$isSuitableForSwitch) {
        IrType notNullable;
        IrType $this$isSuitableForSwitch_u24lambda_u244 = notNullable = IrTypesKt.makeNotNull($this$isSuitableForSwitch);
        boolean bl = false;
        return IrTypePredicatesKt.isBoolean($this$isSuitableForSwitch_u24lambda_u244) || IrTypePredicatesKt.isByte($this$isSuitableForSwitch_u24lambda_u244) || IrTypePredicatesKt.isShort($this$isSuitableForSwitch_u24lambda_u244) || IrTypePredicatesKt.isInt($this$isSuitableForSwitch_u24lambda_u244) || IrTypePredicatesKt.isFloat($this$isSuitableForSwitch_u24lambda_u244) || IrTypePredicatesKt.isDouble($this$isSuitableForSwitch_u24lambda_u244) || IrTypePredicatesKt.isString($this$isSuitableForSwitch_u24lambda_u244);
    }

    @Nullable
    public final JsStatement tryOptimize(@NotNull IrWhen irWhen) {
        JsStatement jsStatement;
        Intrinsics.checkNotNullParameter((Object)irWhen, (String)"irWhen");
        SwitchData switchData = this.detectSwitch(irWhen);
        if (switchData != null) {
            SwitchData it = switchData;
            boolean bl = false;
            jsStatement = (JsStatement)JsAstUtilsKt.withSource$default(this.buildJsSwitch(it), irWhen, this.context, null, null, 12, null);
        } else {
            jsStatement = null;
        }
        return jsStatement;
    }

    private static final IrConst<?> detectSwitch$tryToExtractEqeqeqConst(SwitchOptimizer this$0, Ref.ObjectRef<IrValueSymbol> varSymbol, IrCall irCall) {
        if (irCall.getSymbol() != this$0.jsEqeqeq && irCall.getSymbol() != this$0.jsEqeq) {
            return null;
        }
        IrExpression irExpression = irCall.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression);
        IrExpression op1 = irExpression;
        IrExpression irExpression2 = irCall.getValueArgument(1);
        Intrinsics.checkNotNull((Object)irExpression2);
        IrExpression op2 = irExpression2;
        IrConst irConst = op1 instanceof IrConst ? (IrConst)op1 : null;
        if (irConst == null && (irConst = op2 instanceof IrConst ? (IrConst)op2 : null) == null) {
            return null;
        }
        IrConst constOp = irConst;
        IrGetValue irGetValue = op1 instanceof IrGetValue ? (IrGetValue)op1 : null;
        if (irGetValue == null && (irGetValue = op2 instanceof IrGetValue ? (IrGetValue)op2 : null) == null) {
            return null;
        }
        IrGetValue varOp = irGetValue;
        if (varSymbol.element == null) {
            varSymbol.element = varOp.getSymbol();
        }
        if (varSymbol.element != varOp.getSymbol()) {
            return null;
        }
        return constOp;
    }

    private static final boolean detectSwitch$checkForPrimitiveOrPattern$checkBranchIsOrPattern(SwitchOptimizer this$0, List<IrConst<?>> $constants, Ref.ObjectRef<IrValueSymbol> varSymbol, IrExpression constExpr, IrExpression branchExpr) {
        boolean bl;
        if (!(constExpr instanceof IrConst)) {
            return false;
        }
        if (!this$0.isTrueConstant((IrConst)constExpr)) {
            return false;
        }
        IrExpression irExpression = branchExpr;
        if (irExpression instanceof IrWhen) {
            bl = SwitchOptimizer.detectSwitch$checkForPrimitiveOrPattern(this$0, varSymbol, (IrWhen)branchExpr, $constants);
        } else if (irExpression instanceof IrCall) {
            IrConst<?> constant = SwitchOptimizer.detectSwitch$tryToExtractEqeqeqConst(this$0, varSymbol, (IrCall)branchExpr);
            if (constant == null) {
                bl = false;
            } else {
                ((Collection)$constants).add(constant);
                bl = true;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean detectSwitch$checkForPrimitiveOrPattern(SwitchOptimizer this$0, Ref.ObjectRef<IrValueSymbol> varSymbol, IrWhen irWhen, List<IrConst<?>> constants) {
        if (irWhen.getBranches().size() != 2) {
            return false;
        }
        IrBranch thenBranch = irWhen.getBranches().get(0);
        IrBranch elseBranch = irWhen.getBranches().get(1);
        if (!SwitchOptimizer.detectSwitch$checkForPrimitiveOrPattern$checkBranchIsOrPattern(this$0, constants, varSymbol, thenBranch.getResult(), thenBranch.getCondition())) {
            return false;
        }
        return SwitchOptimizer.detectSwitch$checkForPrimitiveOrPattern$checkBranchIsOrPattern(this$0, constants, varSymbol, elseBranch.getCondition(), elseBranch.getResult());
    }

    public static final /* synthetic */ JsGenerationContext access$getContext$p(SwitchOptimizer $this) {
        return $this.context;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchBranchData;", "", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "getBody", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "SwitchCaseData", "SwitchDefaultData", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchBranchData$SwitchCaseData;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchBranchData$SwitchDefaultData;", "backend.js"})
    private static abstract class SwitchBranchData {
        @NotNull
        private final IrExpression body;

        private SwitchBranchData(IrExpression body2) {
            this.body = body2;
        }

        @NotNull
        public final IrExpression getBody() {
            return this.body;
        }

        public /* synthetic */ SwitchBranchData(IrExpression body2, DefaultConstructorMarker $constructor_marker) {
            this(body2);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001b\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchBranchData$SwitchCaseData;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchBranchData;", "cases", "", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "(Ljava/util/Collection;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "getCases", "()Ljava/util/Collection;", "backend.js"})
        public static final class SwitchCaseData
        extends SwitchBranchData {
            @NotNull
            private final Collection<IrConst<?>> cases;

            public SwitchCaseData(@NotNull Collection<? extends IrConst<?>> cases, @NotNull IrExpression body2) {
                Intrinsics.checkNotNullParameter(cases, (String)"cases");
                Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                super(body2, null);
                this.cases = cases;
            }

            @NotNull
            public final Collection<IrConst<?>> getCases() {
                return this.cases;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchBranchData$SwitchDefaultData;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchBranchData;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "backend.js"})
        public static final class SwitchDefaultData
        extends SwitchBranchData {
            public SwitchDefaultData(@NotNull IrExpression body2) {
                Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                super(body2, null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchData;", "", "subject", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "cases", "", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchBranchData;", "(Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;Ljava/util/Collection;)V", "getCases", "()Ljava/util/Collection;", "getSubject", "()Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "backend.js"})
    private static final class SwitchData {
        @NotNull
        private final IrValueSymbol subject;
        @NotNull
        private final Collection<SwitchBranchData> cases;

        public SwitchData(@NotNull IrValueSymbol subject, @NotNull Collection<? extends SwitchBranchData> cases) {
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            Intrinsics.checkNotNullParameter(cases, (String)"cases");
            this.subject = subject;
            this.cases = cases;
        }

        @NotNull
        public final IrValueSymbol getSubject() {
            return this.subject;
        }

        @NotNull
        public final Collection<SwitchBranchData> getCases() {
            return this.cases;
        }
    }
}

