Name "Kitlist"

!define GTKMMDISTDIR "/opt/mingw/i686-pc-mingw32/redist"
!define VERSION "0.7.0"
!define PRODUCT_VERSION "${VERSION}.0"
!define COPYRIGHT "© 2008,2009 Frank Dean"

SetCompressor /FINAL /SOLID lzma

OutFile "kitlist-${VERSION}.exe"

InstallDir $PROGRAMFILES\Kitlist

InstallDirRegKey HKLM "Software\smartpixie\kitlist" "Install_Dir"

RequestExecutionLevel admin

Icon kitlist.ico
UninstallIcon kitlist.ico

LoadLanguageFile "${NSISDIR}\Contrib\Language files\English.nlf"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\Afrikaans.nlf"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\Dutch.nlf"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\French.nlf"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\German.nlf"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\Polish.nlf"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\Portuguese.nlf"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\Spanish.nlf"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\SpanishInternational.nlf"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\Welsh.nlf"

VIProductVersion ${PRODUCT_VERSION}
VIAddVersionKey /LANG=${LANG_ENGLISH} "ProductName" "Kitlist"
VIAddVersionKey /LANG=${LANG_ENGLISH} "Comments" "Installs Kitlist application"
VIAddVersionKey /LANG=${LANG_ENGLISH} "CompanyName" "Smart Pixie Limited"
VIAddVersionKey /LANG=${LANG_ENGLISH} "LegalCopyright" "${COPYRIGHT}"
VIAddVersionKey /LANG=${LANG_ENGLISH} "FileDescription" "Kitlist Application"
VIAddVersionKey /LANG=${LANG_ENGLISH} "FileVersion" "${VERSION}"

InstType "Full"
InstType "Typical"
InstType "Application Only (No gtkmm DLLs)"
;InstType /NOCUSTOM
;InstType /COMPONENTSONLYONCUSTOM

Page license
Page components
Page directory
Page instfiles
UninstPage uninstConfirm
UninstPage instfiles

CRCCheck force

XPStyle on

LicenseData COPYING

LangString ^ComponentsText ${LANG_ENGLISH} "Check the components you want to install and uncheck the components you don't want to install.  Normally you should select the gtkmm DLLs unless you know what you are doing.  Click Next to continue."

Var /GLOBAL shellvarcontext

Function .onInit
	;Check whether the user has admin rights
	ClearErrors
	UserInfo::GetName
	IfErrors Win9x ; Not an issue if Windows 9x
	Pop $0
	UserInfo::GetAccountType
	Pop $1
	;UserInfo::GetOriginalAccountType
	;Pop $2
	StrCmp $1 "Admin" 0 +3
		StrCpy $shellvarcontext "all"
		Goto language
		; MessageBox MB_OK|MB_ICONSTOP "You must be in the Administrator's group to install this application"
		; Abort
		StrCpy $shellvarcontext "current"

	Win9x:

	language:
	;Language selection dialog

	Push ""
	Push ${LANG_ENGLISH}
	Push English
	Push ${LANG_AFRIKAANS}
	Push Afrikaans
	Push ${LANG_DUTCH}
	Push Dutch
	Push ${LANG_FRENCH}
	Push French
	Push ${LANG_GERMAN}
	Push German
	Push ${LANG_POLISH}
	Push Polish
	Push ${LANG_PORTUGUESE}
	Push Portuguese
	Push ${LANG_SPANISH}
	Push Spanish
	Push ${LANG_SPANISHINTERNATIONAL}
	Push "Spanish International"
	Push ${LANG_WELSH}
	Push Welsh
	Push A ; A means auto count languages
		   ; for the auto count to work the first empty push (Push "") must remain
	LangDLL::LangDialog "Installer Language" "Please select the language of the installer"

	Pop $LANGUAGE
	StrCmp $LANGUAGE "cancel" 0 +2
		Abort

;	StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +2
;	 InstTypeSetText 0 "Full"
	StrCmp $LANGUAGE ${LANG_FRENCH} 0 +4
	InstTypeSetText 0 "Tout"
	InstTypeSetText 1 "Typique"
	InstTypeSetText 2 "Ne pas installer des DLL gtkmm"

FunctionEnd

Function un.onInit

	;Check whether the user has admin rights
	ClearErrors
	UserInfo::GetName
	IfErrors Win9x ; Not an issue if Windows 9x
	Pop $0
	UserInfo::GetAccountType
	Pop $1
	;UserInfo::GetOriginalAccountType
	;Pop $2
	StrCmp $1 "Admin" 0 +3
		StrCpy $shellvarcontext "all"
		Goto language
		; MessageBox MB_OK|MB_ICONSTOP "You must be in the Administrator's group to install this application"
		; Abort
		StrCpy $shellvarcontext "current"

	Win9x:

	language:
	;Language selection dialog

	Push ""
	Push ${LANG_ENGLISH}
	Push English
	Push ${LANG_AFRIKAANS}
	Push Afrikaans
	Push ${LANG_DUTCH}
	Push Dutch
	Push ${LANG_FRENCH}
	Push French
	Push ${LANG_GERMAN}
	Push German
	Push ${LANG_POLISH}
	Push Polish
	Push ${LANG_PORTUGUESE}
	Push Portuguese
	Push ${LANG_SPANISH}
	Push Spanish
	Push ${LANG_SPANISHINTERNATIONAL}
	Push "Spanish International"
	Push ${LANG_WELSH}
	Push Welsh
	Push A ; A means auto count languages
		   ; for the auto count to work the first empty push (Push "") must remain
	LangDLL::LangDialog "Installer Language" "Please select the language of the installer"

	Pop $LANGUAGE
	StrCmp $LANGUAGE "cancel" 0 +2
		Abort

FunctionEnd


Section "Kistlist (required)"
	SetShellVarContext all
	StrCmp $shellvarcontext "current" 0 +2
	SetShellVarContext current

	SectionIn RO

	SetOutPath $INSTDIR

	File src/kitlist.exe kitlist.ico kitlist.glade

	WriteRegStr SHCTX "Software\smartpixie\kitlist" "Install_Dir" "$INSTDIR"
	WriteRegStr SHCTX "Software\Microsoft\Windows\CurrentVersion\Uninstall\kitlist" \
					 "DisplayName" "Kitlist"
	WriteRegStr SHCTX "Software\Microsoft\Windows\CurrentVersion\Uninstall\kitlist" \
					 "UninstallString" '"$INSTDIR\uninstall.exe"'
	WriteRegDWORD SHCTX "Software\Microsoft\Windows\CurrentVersion\Uninstall\kitlist" \
					   "NoModify" 1
	WriteRegDWORD SHCTX "Software\Microsoft\Windows\CurrentVersion\Uninstall\kitlist" \
					   "NoRepair" 1
	WriteUninstaller "uninstall.exe"

SectionEnd


Section "gtkmm DLLs (optional)"
	SetShellVarContext all
	StrCmp $shellvarcontext "current" 0 +2
	SetShellVarContext current

	SectionIn 1 2

	SetOutPath $INSTDIR

	File "${GTKMMDISTDIR}/*.dll"

	WriteRegStr SHCTX "Software\smartpixie\kitlist" "Install_Dir" "$INSTDIR"

SectionEnd


Section "Start Menu Shortcuts"
	SetShellVarContext all
	StrCmp $shellvarcontext "current" 0 +2
	SetShellVarContext current

	SectionIn 1 2 3

	CreateDirectory "$SMPROGRAMS\Kitlist"
	CreateShortCut "$SMPROGRAMS\Kitlist\Kitlist.lnk" \
				   "$INSTDIR\kitlist.exe" "" \
				   "$INSTDIR\kitlist.ico" 0 SW_SHOWNORMAL
	CreateShortCut "$SMPROGRAMS\Kitlist\Uninstall.lnk" \
				   "$INSTDIR\uninstall.exe" "" \
				   "$INSTDIR\uninstall.exe" 0
SectionEnd


Section "Uninstall"
	SetShellVarContext all
	StrCmp $shellvarcontext "current" 0 +2
	SetShellVarContext current
  
	DeleteRegKey SHCTX "Software\Microsoft\Windows\CurrentVersion\Uninstall\kitlist"
	DeleteRegKey SHCTX "SOFTWARE\smartpixie\kitlist"

	Delete $INSTDIR\kitlist.exe
	Delete $INSTDIR\kitlist.glade
	Delete $INSTDIR\kitlist.ico
	Delete $INSTDIR\*.dll
	Delete $INSTDIR\uninstall.exe

	Delete "$SMPROGRAMS\Kitlist\*.*"

	RMDir "$SMPROGRAMS\Kitlist"
	RMDir "$INSTDIR"

SectionEnd
