/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.treetable;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.violetlib.treetable.TreeColumnModel;
import org.violetlib.treetable.event.TreeColumnModelEvent;
import org.violetlib.treetable.event.TreeColumnModelListener;

public abstract class AbstractTreeColumnModel
implements TreeColumnModel {
    protected EventListenerList listenerList = new EventListenerList();

    @Override
    public String getColumnName(int n) {
        String string = Character.toString((char)(65 + n % 26));
        while (n > 25) {
            n = n / 26 - 1;
            string = string + (char)(65 + n % 26);
        }
        return string;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return Object.class;
    }

    @Override
    public void setValueAt(Object object, Object object2, int n) {
    }

    protected Object convertValue(Object object, Object object2, int n) {
        try {
            return AbstractTreeColumnModel.convertValue(object, this.getColumnClass(n));
        }
        catch (NumberFormatException numberFormatException) {
            return this.convertValue(object, object2, n, numberFormatException);
        }
    }

    protected Object convertValue(Object object, Object object2, int n, NumberFormatException numberFormatException) {
        return object;
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        return false;
    }

    @Override
    public int getHierarchicalColumn() {
        return 0;
    }

    @Override
    public void addTreeColumnModelListener(TreeColumnModelListener treeColumnModelListener) {
        this.listenerList.add(TreeColumnModelListener.class, treeColumnModelListener);
    }

    @Override
    public void removeTreeColumnModelListener(TreeColumnModelListener treeColumnModelListener) {
        this.listenerList.remove(TreeColumnModelListener.class, treeColumnModelListener);
    }

    protected void fireTreeColumnChanged(TreePath treePath, int n) {
        AbstractTreeColumnModel.fireTreeColumnChanged(this.listenerList, this, treePath, n);
    }

    public static void fireTreeColumnChanged(EventListenerList eventListenerList, TreeColumnModel treeColumnModel, TreePath treePath, int n) {
        Object[] objectArray = eventListenerList.getListenerList();
        TreeColumnModelEvent treeColumnModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeColumnModelListener.class) continue;
            if (treeColumnModelEvent == null) {
                treeColumnModelEvent = new TreeColumnModelEvent(treeColumnModel, treePath, n);
            }
            ((TreeColumnModelListener)objectArray[i + 1]).treeColumnChanged(treeColumnModelEvent);
        }
    }

    public static TreePath pathToRoot(Object object, TreeNode treeNode) {
        if (treeNode == object || treeNode.getParent() == null) {
            return new TreePath(treeNode);
        }
        return AbstractTreeColumnModel.pathToRoot(object, treeNode.getParent()).pathByAddingChild(treeNode);
    }

    public static Object convertValue(Object object, Class<?> clazz) throws NumberFormatException {
        if (clazz == Object.class || clazz == String.class) {
            return object;
        }
        if (clazz == Boolean.class) {
            if (object instanceof Boolean) {
                return object;
            }
            return object == null ? Boolean.FALSE : Boolean.valueOf(object.toString());
        }
        if (Number.class.isAssignableFrom(clazz) && object instanceof String) {
            if (clazz == Integer.class) {
                object = Integer.valueOf((String)object);
            } else if (clazz == Long.class) {
                object = Long.valueOf((String)object);
            } else if (clazz == Float.class) {
                object = Float.valueOf((String)object);
            } else if (clazz == Double.class) {
                object = Double.valueOf((String)object);
            } else {
                if (clazz == BigInteger.class) {
                    return new BigInteger((String)object);
                }
                if (clazz == BigDecimal.class) {
                    return new BigDecimal((String)object);
                }
                if (clazz == Short.class) {
                    object = Short.valueOf((String)object);
                } else if (clazz == Byte.class) {
                    object = Byte.valueOf((String)object);
                }
            }
        }
        return object;
    }
}

