/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.geom.Rectangle2D;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.RasterDescription;
import org.violetlib.jnr.impl.RendererDescription;

public final class MultiResolutionRendererDescription
implements RendererDescription {
    @NotNull
    private final RendererDescription rd1;
    @NotNull
    private final RendererDescription rd2;

    public MultiResolutionRendererDescription(@NotNull RendererDescription rendererDescription, @NotNull RendererDescription rendererDescription2) {
        this.rd1 = rendererDescription;
        this.rd2 = rendererDescription2;
    }

    @Override
    public boolean isTrivial() {
        return this.rd1.isTrivial() && this.rd2.isTrivial();
    }

    @NotNull
    public RendererDescription getDescription1() {
        return this.rd1;
    }

    @NotNull
    public RendererDescription getDescription2() {
        return this.rd2;
    }

    @Override
    @NotNull
    public RasterDescription getRasterBounds(@NotNull Rectangle2D rectangle2D, int n) {
        return n == 1 ? this.rd1.getRasterBounds(rectangle2D, n) : this.rd2.getRasterBounds(rectangle2D, n);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MultiResolutionRendererDescription multiResolutionRendererDescription = (MultiResolutionRendererDescription)object;
        return Objects.equals(this.rd1, multiResolutionRendererDescription.rd1) && Objects.equals(this.rd2, multiResolutionRendererDescription.rd2);
    }

    public int hashCode() {
        return Objects.hash(this.rd1, this.rd2);
    }
}

