/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.text.DecimalFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.MultiResolutionRendererDescription;
import org.violetlib.jnr.impl.RendererDescription;

public class JNRUtils {
    @NotNull
    static final DecimalFormat df2 = new DecimalFormat("0.00");
    public static final float NO_CHANGE = -123456.0f;

    public static int size(@NotNull AquaUIPainter.Size size, int n, int n2, int n3) {
        switch (size) {
            case SMALL: {
                return n2;
            }
            case MINI: {
                return n3;
            }
        }
        return n;
    }

    public static float size2D(@NotNull AquaUIPainter.Size size, float f, float f2, float f3) {
        switch (size) {
            case SMALL: {
                return f2;
            }
            case MINI: {
                return f3;
            }
        }
        return f;
    }

    @NotNull
    public static String format2(double d) {
        return df2.format(d);
    }

    @Nullable
    public static BasicRendererDescription toBasicRendererDescription(@NotNull RendererDescription rendererDescription) {
        if (rendererDescription instanceof BasicRendererDescription) {
            return (BasicRendererDescription)rendererDescription;
        }
        return null;
    }

    @Nullable
    public static BasicRendererDescription toBasicRendererDescription(@NotNull RendererDescription rendererDescription, int n) {
        if (rendererDescription instanceof BasicRendererDescription) {
            return (BasicRendererDescription)rendererDescription;
        }
        if (rendererDescription instanceof MultiResolutionRendererDescription) {
            RendererDescription rendererDescription2;
            MultiResolutionRendererDescription multiResolutionRendererDescription = (MultiResolutionRendererDescription)rendererDescription;
            RendererDescription rendererDescription3 = rendererDescription2 = n == 1 ? multiResolutionRendererDescription.getDescription1() : multiResolutionRendererDescription.getDescription2();
            if (rendererDescription2 instanceof BasicRendererDescription) {
                return (BasicRendererDescription)rendererDescription2;
            }
        }
        return null;
    }

    @NotNull
    public static RendererDescription adjustRendererDescription(@NotNull RendererDescription rendererDescription, float f, float f2, float f3, float f4) throws UnsupportedOperationException {
        if (f == 0.0f && f2 == 0.0f && f3 == 0.0f && f4 == 0.0f) {
            return rendererDescription;
        }
        BasicRendererDescription basicRendererDescription = JNRUtils.toBasicRendererDescription(rendererDescription);
        if (basicRendererDescription != null) {
            return basicRendererDescription.withAdjustments(f, f2, f3, f4);
        }
        if (rendererDescription instanceof MultiResolutionRendererDescription) {
            MultiResolutionRendererDescription multiResolutionRendererDescription = (MultiResolutionRendererDescription)rendererDescription;
            BasicRendererDescription basicRendererDescription2 = JNRUtils.toBasicRendererDescription(multiResolutionRendererDescription.getDescription1());
            BasicRendererDescription basicRendererDescription3 = JNRUtils.toBasicRendererDescription(multiResolutionRendererDescription.getDescription2());
            if (basicRendererDescription2 != null && basicRendererDescription3 != null) {
                basicRendererDescription2 = basicRendererDescription2.withAdjustments(f, f2, f3, f4);
                basicRendererDescription3 = basicRendererDescription3.withAdjustments(f, f2, f3, f4);
                return new MultiResolutionRendererDescription(basicRendererDescription2, basicRendererDescription3);
            }
        }
        throw new UnsupportedOperationException("Renderer description cannot be adjusted");
    }

    @NotNull
    public static RendererDescription changeRendererDescription(@NotNull RendererDescription rendererDescription, float f, float f2, float f3, float f4) throws UnsupportedOperationException {
        if (f == -123456.0f && f2 == -123456.0f && f3 == -123456.0f && f4 == -123456.0f) {
            return rendererDescription;
        }
        BasicRendererDescription basicRendererDescription = JNRUtils.toBasicRendererDescription(rendererDescription);
        if (basicRendererDescription != null) {
            return JNRUtils.change(basicRendererDescription, f, f2, f3, f4);
        }
        if (rendererDescription instanceof MultiResolutionRendererDescription) {
            MultiResolutionRendererDescription multiResolutionRendererDescription = (MultiResolutionRendererDescription)rendererDescription;
            BasicRendererDescription basicRendererDescription2 = JNRUtils.toBasicRendererDescription(multiResolutionRendererDescription.getDescription1());
            BasicRendererDescription basicRendererDescription3 = JNRUtils.toBasicRendererDescription(multiResolutionRendererDescription.getDescription2());
            if (basicRendererDescription2 != null && basicRendererDescription3 != null) {
                basicRendererDescription2 = JNRUtils.change(basicRendererDescription2, f, f2, f3, f4);
                basicRendererDescription3 = JNRUtils.change(basicRendererDescription3, f, f2, f3, f4);
                return new MultiResolutionRendererDescription(basicRendererDescription2, basicRendererDescription3);
            }
        }
        throw new UnsupportedOperationException("Renderer description cannot be changed");
    }

    @NotNull
    private static BasicRendererDescription change(@NotNull BasicRendererDescription basicRendererDescription, float f, float f2, float f3, float f4) {
        float f5 = f == -123456.0f ? basicRendererDescription.getXOffset() : f;
        float f6 = f2 == -123456.0f ? basicRendererDescription.getYOffset() : f2;
        float f7 = f3 == -123456.0f ? basicRendererDescription.getWidthAdjustment() : f3;
        float f8 = f4 == -123456.0f ? basicRendererDescription.getHeightAdjustment() : f4;
        return new BasicRendererDescription(f5, f6, f7, f8);
    }

    public static int combine(int n, int n2) {
        int n3 = n2 >> 24 & 0xFF;
        if (n3 == 255) {
            return n2;
        }
        if (n3 == 0) {
            return n;
        }
        int n4 = n >> 24 & 0xFF;
        int n5 = n >> 16 & 0xFF;
        int n6 = n >> 8 & 0xFF;
        int n7 = n >> 0 & 0xFF;
        int n8 = n2 >> 16 & 0xFF;
        int n9 = n2 >> 8 & 0xFF;
        int n10 = n2 >> 0 & 0xFF;
        int n11 = 255 - n3;
        int n12 = n8 + (n5 * n11 >> 8) & 0xFF;
        int n13 = n9 + (n6 * n11 >> 8) & 0xFF;
        int n14 = n10 + (n7 * n11 >> 8) & 0xFF;
        int n15 = (255 * n3 + n4 * n11) / 255 & 0xFF;
        int n16 = (n15 << 24) + (n12 << 16) + (n13 << 8) + n14;
        return n16;
    }

    public static boolean describeRenderer(@NotNull BasicRenderer basicRenderer, int n, int n2, int n3) {
        int n4 = (int)Math.ceil(n3 * n);
        int n5 = (int)Math.ceil(n3 * n2);
        int[] nArray = new int[n4 * n5];
        basicRenderer.render(nArray, n4, n5, n, n2);
        return JNRUtils.describeRaster(nArray, n4, n5);
    }

    public static void showRenderer(@NotNull BasicRenderer basicRenderer, int n, int n2, int n3) {
        int n4 = (int)Math.ceil(n3 * n);
        int n5 = (int)Math.ceil(n3 * n2);
        int[] nArray = new int[n4 * n5];
        basicRenderer.render(nArray, n4, n5, n, n2);
        JNRUtils.showRaster(nArray, n4, n5);
    }

    public static boolean describeRaster(@NotNull int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 1000;
        int n11 = 0;
        int n12 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (n4 = 0; n4 < n2; ++n4) {
            for (int i = 0; i < n; ++i) {
                n3 = n4 * n + i;
                int n13 = nArray[n3];
                int n14 = n13 >> 24 & 0xFF;
                if (n14 == 0) continue;
                if (n14 > n7) {
                    n7 = n14;
                    n8 = n4;
                    n9 = i;
                }
                if (n14 < n10) {
                    n10 = n14;
                    n11 = n4;
                    n12 = i;
                }
                if (n14 == 255) {
                    ++n6;
                } else {
                    ++n5;
                }
                if (bl && bl2) continue;
                int n15 = n13 >> 16 & 0xFF;
                int n16 = n13 >> 8 & 0xFF;
                int n17 = n13 >> 0 & 0xFF;
                if (n15 <= 0 && n16 <= 0 && n17 <= 0) continue;
                if (n15 == n16 && n16 == n17) {
                    bl = true;
                    continue;
                }
                bl2 = true;
            }
        }
        n4 = n * n2;
        String string = "";
        if (n5 > 0) {
            n3 = Math.round((float)n5 * 100.0f / (float)n4);
            string = string + " " + n5 + " transparent pixels (" + n3 + "%)";
        }
        if (n6 > 0) {
            n3 = Math.round((float)n6 * 100.0f / (float)n4);
            string = string + " " + n5 + " opaque pixels (" + n3 + "%)";
        }
        if (n7 > 0) {
            string = string + " maximum alpha: " + n7 + " at " + n9 + ", " + n8;
        }
        if (n10 < 256) {
            string = string + " minimum alpha: " + n10 + " at " + n12 + ", " + n11;
        }
        if (string.isEmpty()) {
            System.out.println("Empty raster");
            return false;
        }
        System.out.println(string);
        return true;
    }

    public static void showRaster(@NotNull int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = i * n + j;
                int n4 = nArray[n3];
                int n5 = n4 >> 24 & 0xFF;
                if (n5 == 0) {
                    System.out.print("                 ");
                } else {
                    int n6 = n4 >> 16 & 0xFF;
                    int n7 = n4 >> 8 & 0xFF;
                    int n8 = n4 >> 0 & 0xFF;
                    if (n5 > 0) {
                        if (n6 > 0) {
                            n6 = n6 * 255 / n5;
                        }
                        if (n7 > 0) {
                            n7 = n7 * 255 / n5;
                        }
                        if (n8 > 0) {
                            n8 = n8 * 255 / n5;
                        }
                    }
                    System.out.print(String.format("%3d %3d %3d %3d", n6, n7, n8, n5));
                }
                System.out.print("  ");
            }
            System.out.println();
        }
    }

    static {
        df2.setDecimalSeparatorAlwaysShown(true);
    }
}

