/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.jrs;

import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.jrs.JRSRenderer;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.EmptyRenderer;
import org.violetlib.jnr.impl.jrs.JRSUIConstants;
import org.violetlib.jnr.impl.jrs.JRSUIControl;
import org.violetlib.jnr.impl.jrs.JRSUIState;
import org.violetlib.jnr.impl.jrs.JRSUIStateFactory;

public class JRSRendererMaker {
    @Nullable
    protected JRSUIConstants.Widget currentWidget;
    @Nullable
    protected JRSUIControl control;
    @Nullable
    protected JRSUIState state;
    private static final Method stateSetMethod = JRSRendererMaker.getStateSetMethod();

    private static Method getStateSetMethod() {
        Method[] methodArray;
        Class<JRSUIState> clazz = JRSUIState.class;
        for (Method method : methodArray = clazz.getMethods()) {
            if (!method.getName().equals("set")) continue;
            return method;
        }
        throw new UnsupportedOperationException("Set method on JRSUIState not found");
    }

    public void reset() {
        if (this.state != null) {
            this.state.reset();
        }
    }

    protected void setProperty(@NotNull Object object) {
        try {
            stateSetMethod.invoke((Object)this.state, object);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Unable to set JRSUIState property: " + exception);
        }
    }

    public void set(@NotNull JRSUIConstants.Size size) {
        this.setProperty(size);
    }

    public void set(@NotNull JRSUIConstants.State state) {
        this.setProperty(state);
    }

    public void set(@NotNull JRSUIConstants.Direction direction) {
        this.setProperty(direction);
    }

    public void set(@NotNull JRSUIConstants.Orientation orientation) {
        this.setProperty(orientation);
    }

    public void set(@NotNull JRSUIConstants.AlignmentVertical alignmentVertical) {
        this.setProperty(alignmentVertical);
    }

    public void set(@NotNull JRSUIConstants.AlignmentHorizontal alignmentHorizontal) {
        this.setProperty(alignmentHorizontal);
    }

    public void set(@NotNull JRSUIConstants.SegmentPosition segmentPosition) {
        this.setProperty(segmentPosition);
    }

    public void set(@NotNull JRSUIConstants.ScrollBarPart scrollBarPart) {
        this.setProperty(scrollBarPart);
    }

    public void set(@NotNull JRSUIConstants.Variant variant) {
        this.setProperty(variant);
    }

    public void set(@NotNull JRSUIConstants.WindowType windowType) {
        this.setProperty(windowType);
    }

    public void set(@NotNull JRSUIConstants.Focused focused) {
        this.setProperty(focused);
    }

    public void set(@NotNull JRSUIConstants.IndicatorOnly indicatorOnly) {
        this.setProperty(indicatorOnly);
    }

    public void set(@NotNull JRSUIConstants.NoIndicator noIndicator) {
        this.setProperty(noIndicator);
    }

    public void set(@NotNull JRSUIConstants.ArrowsOnly arrowsOnly) {
        this.setProperty(arrowsOnly);
    }

    public void set(@NotNull JRSUIConstants.FrameOnly frameOnly) {
        this.setProperty(frameOnly);
    }

    public void set(@NotNull JRSUIConstants.SegmentTrailingSeparator segmentTrailingSeparator) {
        this.setProperty(segmentTrailingSeparator);
    }

    public void set(@NotNull JRSUIConstants.SegmentLeadingSeparator segmentLeadingSeparator) {
        this.setProperty(segmentLeadingSeparator);
    }

    public void set(@NotNull JRSUIConstants.NothingToScroll nothingToScroll) {
        this.setProperty(nothingToScroll);
    }

    public void set(@NotNull JRSUIConstants.WindowTitleBarSeparator windowTitleBarSeparator) {
        this.setProperty(windowTitleBarSeparator);
    }

    public void set(@NotNull JRSUIConstants.WindowClipCorners windowClipCorners) {
        this.setProperty(windowClipCorners);
    }

    public void set(@NotNull JRSUIConstants.ShowArrows showArrows) {
        this.setProperty(showArrows);
    }

    public void set(@NotNull JRSUIConstants.BooleanValue booleanValue) {
        this.setProperty(booleanValue);
    }

    public void set(@NotNull JRSUIConstants.Animating animating) {
        this.setProperty(animating);
    }

    public void set(@NotNull JRSUIConstants.Widget widget) {
        if (widget == this.currentWidget) {
            return;
        }
        if (widget == JRSUIConstants.Widget.SCROLL_BAR) {
            this.state = JRSUIStateFactory.getScrollBar();
        } else if (widget == JRSUIConstants.Widget.PROGRESS_BAR || widget == JRSUIConstants.Widget.PROGRESS_INDETERMINATE_BAR || widget == JRSUIConstants.Widget.PROGRESS_RELEVANCE || widget == JRSUIConstants.Widget.PROGRESS_SPINNER) {
            this.state = JRSUIStateFactory.getProgressBar();
            this.setProperty(widget);
        } else if (widget == JRSUIConstants.Widget.DISCLOSURE_TRIANGLE) {
            this.state = JRSUIStateFactory.getDisclosureTriangle();
        } else if (widget == JRSUIConstants.Widget.BUTTON_CHECK_BOX || widget == JRSUIConstants.Widget.BUTTON_RADIO) {
            this.state = JRSUIStateFactory.getLabeledButton();
            this.setProperty(widget);
        } else if (widget == JRSUIConstants.Widget.WINDOW_FRAME) {
            this.state = JRSUIStateFactory.getTitleBar();
        } else if (widget == JRSUIConstants.Widget.TAB) {
            this.state = JRSUIStateFactory.getTab();
        } else if (widget == JRSUIConstants.Widget.DIVIDER_SPLITTER) {
            this.state = JRSUIStateFactory.getSplitPaneDivider();
        } else if (widget == JRSUIConstants.Widget.BUTTON_LITTLE_ARROWS) {
            this.state = JRSUIStateFactory.getSpinnerArrows();
        } else if (widget == JRSUIConstants.Widget.SLIDER_THUMB) {
            this.state = JRSUIStateFactory.getProgressBar();
            this.setProperty(widget);
        } else if (widget == JRSUIConstants.Widget.SLIDER || widget == JRSUIConstants.Widget.DIAL || widget == JRSUIConstants.Widget.BUTTON_BEVEL || widget == JRSUIConstants.Widget.BUTTON_BEVEL_ROUND || widget == JRSUIConstants.Widget.BUTTON_BEVEL_INSET || widget == JRSUIConstants.Widget.BUTTON_PUSH_TEXTURED || widget == JRSUIConstants.Widget.BUTTON_ROUND) {
            this.state = JRSUIStateFactory.getProgressBar();
            this.setProperty(widget);
        } else {
            this.state = JRSUIState.getInstance();
            this.setProperty(widget);
        }
        this.control = new JRSUIControl(false);
    }

    public void set(@NotNull JRSUIConstants.Hit hit) {
        this.setProperty(hit);
    }

    public void set(@NotNull JRSUIConstants.ScrollBarHit scrollBarHit) {
        this.setProperty(scrollBarHit);
    }

    public void setValue(double d) {
        if (!(this.state instanceof JRSUIState.ValueState)) {
            throw new IllegalStateException("Renderer not configured for value attribute");
        }
        JRSUIState.ValueState valueState = (JRSUIState.ValueState)this.state;
        valueState.setValue(d);
    }

    public void setThumbStart(double d) {
        if (!(this.state instanceof JRSUIState.ScrollBarState)) {
            throw new IllegalStateException("Renderer not configured for thumb start attribute");
        }
        JRSUIState.ScrollBarState scrollBarState = (JRSUIState.ScrollBarState)this.state;
        scrollBarState.setThumbStart(d);
    }

    public void setThumbPercent(double d) {
        if (!(this.state instanceof JRSUIState.ScrollBarState)) {
            throw new IllegalStateException("Renderer not configured for thumb percent attribute");
        }
        JRSUIState.ScrollBarState scrollBarState = (JRSUIState.ScrollBarState)this.state;
        scrollBarState.setThumbPercent(d);
    }

    public void setAnimationFrame(int n) {
        if (!(this.state instanceof JRSUIState.AnimationFrameState)) {
            throw new IllegalStateException("Renderer not configured for animation frame attribute");
        }
        JRSUIState.AnimationFrameState animationFrameState = (JRSUIState.AnimationFrameState)this.state;
        animationFrameState.setAnimationFrame(n);
    }

    @NotNull
    public BasicRenderer getRenderer() {
        if (this.state != null) {
            assert (this.control != null);
            this.state = this.state.derive();
            return new JRSRenderer(this.control, this.state);
        }
        return new EmptyRenderer();
    }
}

