/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.aqua.impl.TitleBarLayoutInfo;
import org.violetlib.jnr.impl.Colors;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.vappearances.VAppearance;

public class TitleBarPainterExtension
implements PainterExtension {
    @NotNull
    protected final TitleBarConfiguration tg;
    @NotNull
    protected final TitleBarLayoutInfo layoutInfo;
    @NotNull
    protected final Colors colors;

    public TitleBarPainterExtension(@NotNull TitleBarLayoutInfo titleBarLayoutInfo, @NotNull TitleBarConfiguration titleBarConfiguration, @Nullable VAppearance vAppearance) {
        this.tg = titleBarConfiguration;
        this.layoutInfo = titleBarLayoutInfo;
        this.colors = Colors.getColors(vAppearance);
    }

    @Override
    public void paint(@NotNull Graphics2D graphics2D, float f, float f2) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
        this.paintIfNeeded(float_, graphics2D, this.tg.getCloseButtonState(), AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX);
        this.paintIfNeeded(float_, graphics2D, this.tg.getMinimizeButtonState(), AquaUIPainter.TitleBarButtonWidget.MINIMIZE_BOX);
        this.paintIfNeeded(float_, graphics2D, this.tg.getResizeButtonState(), AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX);
    }

    protected void paintIfNeeded(@NotNull Rectangle2D rectangle2D, @NotNull Graphics2D graphics2D, @NotNull AquaUIPainter.State state, @NotNull AquaUIPainter.TitleBarButtonWidget titleBarButtonWidget) {
        Object object;
        RectangularShape rectangularShape;
        boolean bl;
        AquaUIPainter.State state2 = this.tg.getTitleBarState();
        boolean bl2 = this.tg.isDirty() && titleBarButtonWidget == AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX;
        boolean bl3 = state2 == AquaUIPainter.State.INACTIVE && state != AquaUIPainter.State.INACTIVE && state != AquaUIPainter.State.PRESSED;
        boolean bl4 = bl = state == AquaUIPainter.State.ROLLOVER || state == AquaUIPainter.State.PRESSED && titleBarButtonWidget == AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX || bl3 && bl2;
        if (!bl3 && !bl) {
            return;
        }
        Shape shape = this.layoutInfo.getButtonShape(rectangle2D, this.tg, titleBarButtonWidget);
        if (bl3) {
            switch (titleBarButtonWidget) {
                case CLOSE_BOX: {
                    graphics2D.setPaint(this.colors.get("titleBarCloseButton"));
                    break;
                }
                case MINIMIZE_BOX: {
                    graphics2D.setPaint(this.colors.get("titleBarMinimizeButton"));
                    break;
                }
                case RESIZE_BOX: {
                    graphics2D.setPaint(this.colors.get("titleBarResizeButton"));
                }
            }
            graphics2D.fill(shape);
            rectangularShape = (RectangularShape)shape;
            object = (RectangularShape)rectangularShape.clone();
            object.setFrameFromCenter(rectangularShape.getCenterX(), rectangularShape.getCenterY(), rectangularShape.getMinX() + 0.2, rectangularShape.getMinY() + 0.2);
            graphics2D.setPaint(new Color(0, 0, 0, 30));
            graphics2D.setStroke(new BasicStroke(0.8f));
            graphics2D.draw((Shape)object);
        }
        if (bl) {
            if (bl3 && bl2) {
                double d = this.tg.getWidget() == AquaUIPainter.TitleBarWidget.DOCUMENT_WINDOW ? 4.0 : 3.0;
                double d2 = d / 2.0;
                RectangularShape rectangularShape2 = (RectangularShape)shape;
                Ellipse2D.Double double_ = new Ellipse2D.Double(rectangularShape2.getCenterX() - d2, rectangularShape2.getCenterY() - d2, d, d);
                graphics2D.setPaint(Color.BLACK);
                graphics2D.fill(double_);
            } else {
                Shape shape2;
                double d;
                double d3;
                double d4;
                rectangularShape = shape.getBounds2D();
                graphics2D.setPaint(new Color(100, 100, 100));
                graphics2D.setStroke(new BasicStroke(0.8f));
                if (titleBarButtonWidget == AquaUIPainter.TitleBarButtonWidget.MINIMIZE_BOX) {
                    double d5 = rectangularShape.getX() + 2.0;
                    d4 = rectangularShape.getCenterY() - 0.5;
                    d3 = rectangularShape.getWidth() - 4.0;
                    d = 1.0;
                    Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d4, d3, d);
                    graphics2D.fill(double_);
                }
                if (titleBarButtonWidget == AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX) {
                    graphics2D.setStroke(new BasicStroke(2.0f));
                    double d6 = 3.5;
                    d4 = rectangularShape.getX() + d6;
                    d3 = rectangularShape.getY() + d6;
                    d = rectangularShape.getX() + rectangularShape.getWidth() - d6;
                    double d7 = rectangularShape.getY() + rectangularShape.getHeight() - d6;
                    shape2 = new Line2D.Double(d4, d3, d, d7);
                    graphics2D.draw(shape2);
                    shape2 = new Line2D.Double(d4, d7, d, d3);
                    graphics2D.draw(shape2);
                }
                if (titleBarButtonWidget == AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX) {
                    boolean bl5;
                    object = this.tg.getResizeAction();
                    boolean bl6 = bl5 = object == TitleBarConfiguration.ResizeAction.FULL_SCREEN_ENTER || object == TitleBarConfiguration.ResizeAction.FULL_SCREEN_EXIT;
                    if (bl5) {
                        graphics2D.setPaint(new Color(100, 100, 100));
                        if (object == TitleBarConfiguration.ResizeAction.FULL_SCREEN_ENTER) {
                            d4 = 3.0;
                            d3 = rectangularShape.getX() + d4;
                            d = rectangularShape.getY() + d4;
                            double d8 = rectangularShape.getX() + rectangularShape.getWidth() - d4;
                            double d9 = rectangularShape.getY() + rectangularShape.getHeight() - d4;
                            double d10 = 0.8;
                            Path2D.Double double_ = new Path2D.Double();
                            double_.moveTo(d3, d + d10);
                            double_.lineTo(d8 - d10, d9);
                            double_.lineTo(d3, d9);
                            double_.lineTo(d3, d + d10);
                            graphics2D.fill(double_);
                            double_ = new Path2D.Double();
                            double_.moveTo(d8, d9 - d10);
                            double_.lineTo(d3 + d10, d);
                            double_.lineTo(d8, d);
                            double_.lineTo(d8, d9 - d10);
                            graphics2D.fill(double_);
                        } else {
                            d4 = 1.5;
                            d3 = rectangularShape.getX() + d4;
                            d = rectangularShape.getY() + d4;
                            double d11 = rectangularShape.getX() + rectangularShape.getWidth() - d4;
                            double d12 = rectangularShape.getY() + rectangularShape.getHeight() - d4;
                            double d13 = (d3 + d11) / 2.0;
                            double d14 = (d + d12) / 2.0;
                            double d15 = 0.2;
                            Path2D.Double double_ = new Path2D.Double();
                            double_.moveTo(d3, d14 + d15);
                            double_.lineTo(d13 - d15, d12);
                            double_.lineTo(d13 - d15, d14 + d15);
                            double_.lineTo(d3, d14 + d15);
                            graphics2D.fill(double_);
                            double_ = new Path2D.Double();
                            double_.moveTo(d11, d14 - d15);
                            double_.lineTo(d13 + d15, d);
                            double_.lineTo(d13 + d15, d14 - d15);
                            double_.lineTo(d11, d14 - d15);
                            graphics2D.fill(double_);
                        }
                    } else {
                        d4 = rectangularShape.getX() + 2.0;
                        d3 = rectangularShape.getCenterY() - 0.5;
                        d = rectangularShape.getWidth() - 4.0;
                        double d16 = 1.0;
                        shape2 = new Rectangle2D.Double(d4, d3, d, d16);
                        graphics2D.fill(shape2);
                        d4 = rectangularShape.getCenterX() - 0.5;
                        d3 = rectangularShape.getY() + 2.0;
                        d = 1.0;
                        d16 = rectangularShape.getHeight() - 4.0;
                        shape2 = new Rectangle2D.Double(d4, d3, d, d16);
                        graphics2D.setPaint(new Color(100, 100, 100));
                        graphics2D.fill(shape2);
                    }
                }
            }
        }
    }
}

