/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class SliderHorizontalTickPainter {
    @NotNull
    protected final Color color;
    protected final double w;
    protected final double h;
    protected final double x0;
    protected final double x1;
    protected final double y;
    protected final int tickCount;

    public SliderHorizontalTickPainter(@NotNull Color color, double d, double d2, double d3, double d4, double d5, int n) {
        this.color = color;
        this.w = d;
        this.h = d2;
        this.x0 = d3;
        this.x1 = d4;
        this.y = d5;
        this.tickCount = n;
    }

    public void paint(@NotNull Graphics2D graphics2D) {
        graphics2D.setColor(this.color);
        if (this.tickCount == 1) {
            this.drawTick(graphics2D, this.x0);
        } else {
            double d = (this.x1 - this.x0) / (double)(this.tickCount - 1);
            double d2 = this.x0;
            for (int i = 0; i < this.tickCount; ++i) {
                this.drawTick(graphics2D, d2);
                d2 += d;
            }
        }
    }

    protected void drawTick(@NotNull Graphics2D graphics2D, double d) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(d - this.w / 2.0, this.y, this.w, this.h);
        graphics2D.fill(double_);
    }
}

