/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.impl.SliderCircularIndicatorPainter;
import org.violetlib.jnr.aqua.impl.SliderCircularTickPainter;
import org.violetlib.jnr.impl.Colors;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.vappearances.VAppearance;

public class CircularSliderPainterExtension
implements PainterExtension {
    @NotNull
    protected final SliderConfiguration sg;
    @Nullable
    protected final VAppearance appearance;
    @NotNull
    protected final Colors colors;

    public CircularSliderPainterExtension(@NotNull SliderConfiguration sliderConfiguration, @Nullable VAppearance vAppearance) {
        this.sg = sliderConfiguration;
        this.appearance = vAppearance;
        this.colors = Colors.getColors(vAppearance);
    }

    @Override
    public void paint(@NotNull Graphics2D graphics2D, float f, float f2) {
        AquaUIPainter.SliderWidget sliderWidget = this.sg.getWidget();
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            if (this.sg.hasTickMarks()) {
                this.paintCircularTickMarks(graphics2D, f, f2);
            }
            this.paintCircularIndicator(graphics2D, f, f2);
        }
    }

    protected void paintCircularTickMarks(@NotNull Graphics2D graphics2D, float f, float f2) {
        double d = (double)f / 2.0;
        double d2 = (double)f2 / 2.0;
        int n = this.sg.getNumberOfTickMarks();
        double d3 = n > 1 ? 0.0 : 0.5;
        double d4 = n > 1 ? 1.0 : 0.5;
        double d5 = 1.5707963267948966;
        float f3 = JNRUtils.size2D(this.sg.getSize(), 15.5f, 10.5f, 10.5f);
        Color color = this.colors.get("circularSliderTick");
        SliderCircularTickPainter sliderCircularTickPainter = new SliderCircularTickPainter(color, 1.0, 1.0, d, d2, f3, d5, n, d3, d4);
        sliderCircularTickPainter.paint(graphics2D);
    }

    protected void paintCircularIndicator(@NotNull Graphics2D graphics2D, float f, float f2) {
        double d = (double)f / 2.0;
        double d2 = (double)f2 / 2.0;
        double d3 = 1.5707963267948966;
        double d4 = this.sg.getValue();
        float f3 = JNRUtils.size2D(this.sg.getSize(), 7.5f, 3.5f, 3.5f);
        SliderCircularIndicatorPainter sliderCircularIndicatorPainter = new SliderCircularIndicatorPainter(d, d2, f3, d3, d4, this.appearance);
        sliderCircularIndicatorPainter.paint(graphics2D);
    }
}

