/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbLayoutConfiguration;
import org.violetlib.jnr.aqua.SliderLayoutConfiguration;
import org.violetlib.jnr.aqua.impl.ElCapitanLayoutInfo;
import org.violetlib.jnr.aqua.impl.SierraLayoutInfo;
import org.violetlib.jnr.aqua.impl.UIOutliner;
import org.violetlib.jnr.aqua.impl.YosemiteLayoutInfo;
import org.violetlib.jnr.aqua.impl.YosemiteOutliner;
import org.violetlib.jnr.impl.Colors;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.vappearances.VAppearance;

public abstract class AquaUIPainterAbstractBase
implements AquaUIPainter {
    protected int w;
    protected int h;
    @Nullable
    protected VAppearance appearance;
    protected boolean forceVertical;
    protected boolean isAlignmentEnabled = true;
    @Nullable
    protected LayoutInfo layoutInfo;
    protected float xOffset;
    protected float yOffset;
    protected float pWidth;
    protected float pHeight;
    @NotNull
    protected static final AquaUILayoutInfo uiLayout;
    @NotNull
    protected static final UIOutliner uiOutliner;

    @NotNull
    private static AquaUILayoutInfo findLayoutInfo(int n) {
        if (n >= 101200) {
            return new SierraLayoutInfo();
        }
        if (n >= 101100) {
            return new ElCapitanLayoutInfo();
        }
        return new YosemiteLayoutInfo();
    }

    public void setAlignmentEnabled(boolean bl) {
        this.isAlignmentEnabled = bl;
    }

    @Override
    @NotNull
    public Map<String, Color> getColors(@NotNull VAppearance vAppearance) {
        Colors colors = Colors.getColors(vAppearance);
        return colors.getColors();
    }

    @Override
    public void configureAppearance(@NotNull VAppearance vAppearance) {
        this.appearance = vAppearance;
    }

    @Override
    public void configure(int n, int n2) {
        this.w = n;
        this.h = n2;
        this.forceVertical = false;
    }

    @Override
    @NotNull
    public AquaUILayoutInfo getLayoutInfo() {
        return uiLayout;
    }

    @Override
    @NotNull
    public final Rectangle2D getComboBoxEditorBounds(@NotNull ComboBoxLayoutConfiguration comboBoxLayoutConfiguration) {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(comboBoxLayoutConfiguration);
        Rectangle2D rectangle2D = this.getCenteredBounds(layoutInfo);
        Insetter insetter = uiLayout.getComboBoxEditorInsets(comboBoxLayoutConfiguration);
        return insetter.applyToBounds2D(rectangle2D);
    }

    @Override
    @NotNull
    public final Rectangle2D getComboBoxIndicatorBounds(@NotNull ComboBoxLayoutConfiguration comboBoxLayoutConfiguration) {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(comboBoxLayoutConfiguration);
        Rectangle2D rectangle2D = this.getCenteredBounds(layoutInfo);
        Insetter insetter = uiLayout.getComboBoxIndicatorInsets(comboBoxLayoutConfiguration);
        return insetter.applyToBounds2D(rectangle2D);
    }

    @Override
    @NotNull
    public final Rectangle2D getPopupButtonContentBounds(@NotNull PopupButtonLayoutConfiguration popupButtonLayoutConfiguration) {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(popupButtonLayoutConfiguration);
        Rectangle2D rectangle2D = this.getCenteredBounds(layoutInfo);
        Insetter insetter = uiLayout.getPopupButtonContentInsets(popupButtonLayoutConfiguration);
        return insetter.applyToBounds2D(rectangle2D);
    }

    @Override
    public float getScrollBarThumbPosition(@NotNull ScrollBarThumbLayoutConfiguration scrollBarThumbLayoutConfiguration, boolean bl) {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(scrollBarThumbLayoutConfiguration);
        Rectangle2D rectangle2D = this.getCenteredBounds(layoutInfo);
        return uiLayout.getScrollBarThumbPosition(rectangle2D, scrollBarThumbLayoutConfiguration, bl);
    }

    @Override
    public int getScrollBarThumbHit(@NotNull ScrollBarThumbConfiguration scrollBarThumbConfiguration) {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(scrollBarThumbConfiguration);
        Rectangle2D rectangle2D = this.getCenteredBounds(layoutInfo);
        return uiLayout.getScrollBarThumbHit(rectangle2D, scrollBarThumbConfiguration);
    }

    @Override
    @NotNull
    public final Rectangle2D getSliderThumbBounds(@NotNull SliderLayoutConfiguration sliderLayoutConfiguration, double d) {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(sliderLayoutConfiguration);
        Rectangle2D rectangle2D = this.getCenteredBounds(layoutInfo);
        return uiLayout.getSliderThumbBounds(rectangle2D, sliderLayoutConfiguration, d);
    }

    @Override
    @NotNull
    public final Rectangle2D getSliderLabelBounds(@NotNull SliderLayoutConfiguration sliderLayoutConfiguration, double d, @NotNull Dimension dimension) {
        if (d < 0.0 || d > 1.0) {
            return new Rectangle(0, 0, 0, 0);
        }
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(sliderLayoutConfiguration);
        Rectangle2D rectangle2D = this.getCenteredBounds(layoutInfo);
        return uiLayout.getSliderLabelBounds(rectangle2D, sliderLayoutConfiguration, d, dimension);
    }

    public final double getSliderThumbCenter(@NotNull Rectangle2D rectangle2D, @NotNull SliderLayoutConfiguration sliderLayoutConfiguration, double d) {
        return uiLayout.getSliderThumbCenter(rectangle2D, sliderLayoutConfiguration, d);
    }

    @Override
    public final double getSliderThumbPosition(@NotNull SliderLayoutConfiguration sliderLayoutConfiguration, int n, int n2) {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(sliderLayoutConfiguration);
        Rectangle2D rectangle2D = this.getCenteredBounds(layoutInfo);
        return uiLayout.getSliderThumbPosition(rectangle2D, sliderLayoutConfiguration, n, n2);
    }

    protected void configureLayout(@Nullable LayoutInfo layoutInfo) {
        this.xOffset = 0.0f;
        this.yOffset = 0.0f;
        this.pWidth = this.w;
        this.pHeight = this.h;
        this.layoutInfo = layoutInfo;
        if (this.layoutInfo != null) {
            float f;
            float f2 = this.layoutInfo.getFixedVisualWidth();
            if (f2 > 0.0f) {
                if ((float)this.w > f2 && this.isAlignmentEnabled) {
                    this.xOffset = ((float)this.w - f2) / 2.0f;
                }
                this.pWidth = f2;
            }
            if ((f = this.layoutInfo.getFixedVisualHeight()) > 0.0f) {
                if ((float)this.h > f && this.isAlignmentEnabled) {
                    this.yOffset = ((float)this.h - f) / 2.0f;
                }
                this.pHeight = f;
            }
        }
    }

    @NotNull
    protected Rectangle2D getCenteredBounds(@Nullable LayoutInfo layoutInfo) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = this.w;
        float f4 = this.h;
        if (layoutInfo != null) {
            float f5;
            float f6;
            float f7 = layoutInfo.getFixedVisualWidth();
            if (f7 > 0.0f && (f6 = f3 - f7) > 0.0f) {
                f += f6 / 2.0f;
                f3 -= f6;
            }
            if ((f6 = layoutInfo.getFixedVisualHeight()) > 0.0f && (f5 = f4 - f6) > 0.0f) {
                f2 += f5 / 2.0f;
                f4 -= f5;
            }
        }
        return new Rectangle2D.Float(f, f2, f3, f4);
    }

    static {
        int n = JNRPlatformUtils.getPlatformVersion();
        uiLayout = AquaUIPainterAbstractBase.findLayoutInfo(n);
        uiOutliner = new YosemiteOutliner((YosemiteLayoutInfo)uiLayout);
    }
}

