/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import javax.swing.plaf.ListUI;
import org.violetlib.aqua.GenericList;

public class JListModel
implements GenericList {
    protected final JList list;

    public JListModel(JList jList) {
        this.list = jList;
    }

    @Override
    public JComponent getComponent() {
        return this.list;
    }

    @Override
    public void requestFocus() {
        if (this.list.isEnabled() && this.list.isRequestFocusEnabled()) {
            this.list.requestFocusInWindow();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.list.isEnabled();
    }

    @Override
    public int getRowCount() {
        return this.list.getModel().getSize();
    }

    @Override
    public Object getRow(int n) {
        return this.list.getModel().getElementAt(n);
    }

    @Override
    public boolean isMultipleSelection() {
        return this.list.getSelectionMode() != 0;
    }

    @Override
    public boolean isRowSelected(int n) {
        return this.list.isSelectedIndex(n);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.list.isSelectionEmpty();
    }

    @Override
    public void clearSelection() {
        this.list.clearSelection();
    }

    @Override
    public void setSelectionInterval(int n, int n2) {
        this.list.setSelectionInterval(n, n2);
    }

    @Override
    public void addSelectionInterval(int n, int n2) {
        this.list.addSelectionInterval(n, n2);
    }

    @Override
    public void removeSelectionInterval(int n, int n2) {
        this.list.removeSelectionInterval(n, n2);
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.list.getAnchorSelectionIndex();
    }

    @Override
    public void setAnchorSelectionIndex(int n) {
        this.list.getSelectionModel().setAnchorSelectionIndex(n);
    }

    @Override
    public int getMinSelectionIndex() {
        return this.list.getMinSelectionIndex();
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.list.getMaxSelectionIndex();
    }

    @Override
    public boolean isValueAdjusting() {
        return this.list.getValueIsAdjusting();
    }

    @Override
    public void setValueIsAdjusting(boolean bl) {
        this.list.getSelectionModel().setValueIsAdjusting(bl);
    }

    @Override
    public int identifyRowAtLocation(Point point) {
        Rectangle rectangle;
        ListUI listUI = this.list.getUI();
        int n = listUI.locationToIndex(this.list, point);
        if (n != -1 && ((double)point.x > (rectangle = this.list.getCellBounds(n, n)).getX() + rectangle.getWidth() || (double)point.y > rectangle.getY() + rectangle.getHeight())) {
            n = -1;
        }
        return n;
    }

    @Override
    public void scrollToViewRows(int n, int n2) {
        ListUI listUI = this.list.getUI();
        Rectangle rectangle = listUI.getCellBounds(this.list, n, n2);
        this.list.scrollRectToVisible(rectangle);
    }

    @Override
    public boolean isDragEnabled() {
        return this.list.getDragEnabled();
    }

    @Override
    public TransferHandler getTransferHandler() {
        return this.list.getTransferHandler();
    }
}

