/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaTextComponentUIDelegate;

public class AquaTextComponentDelegatedUIBase
extends BasicTextUI {
    @NotNull
    protected final AquaTextComponentUIDelegate delegate;
    @NotNull
    private final String propertyPrefix;
    protected JTextComponent editor;

    protected AquaTextComponentDelegatedUIBase(@NotNull AquaTextComponentUIDelegate aquaTextComponentUIDelegate) {
        this.delegate = aquaTextComponentUIDelegate;
        this.propertyPrefix = aquaTextComponentUIDelegate.getPropertyPrefix();
    }

    @Override
    @NotNull
    protected String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    @Override
    public void installUI(@NotNull JComponent jComponent) {
        if (jComponent instanceof JTextComponent) {
            this.editor = (JTextComponent)jComponent;
            super.installUI(jComponent);
            this.delegate.install(this.editor);
        }
    }

    @Override
    public void uninstallUI(@NotNull JComponent jComponent) {
        this.delegate.uninstall((JTextComponent)jComponent);
        super.uninstallUI(jComponent);
        this.editor = null;
    }

    @Override
    @NotNull
    public EditorKit getEditorKit(@NotNull JTextComponent jTextComponent) {
        EditorKit editorKit = this.delegate.getEditorKit(jTextComponent);
        return editorKit != null ? editorKit : super.getEditorKit(jTextComponent);
    }

    @Override
    @Nullable
    public View create(@NotNull Element element) {
        return this.delegate.create(this.editor, element);
    }

    @Override
    public int getBaseline(@NotNull JComponent jComponent, int n, int n2) {
        super.getBaseline(jComponent, n, n2);
        return this.delegate.getBaseline((JTextComponent)jComponent, n, n2);
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull JComponent jComponent) {
        super.getBaselineResizeBehavior(jComponent);
        return this.delegate.getBaselineResizeBehavior((JTextComponent)jComponent);
    }

    @Override
    protected void propertyChange(@NotNull PropertyChangeEvent propertyChangeEvent) {
        String string;
        super.propertyChange(propertyChangeEvent);
        if (this.delegate.propertyChange(propertyChangeEvent)) {
            this.modelChanged();
        }
        if ("focusAccelerator".equals(string = propertyChangeEvent.getPropertyName())) {
            SwingUtilities.invokeLater(() -> this.updateActionMap(this.editor));
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateActionMap(this.editor);
    }

    private void updateActionMap(@NotNull JTextComponent jTextComponent) {
        ActionMap actionMap = this.delegate.getActionMap(jTextComponent);
        if (actionMap != null) {
            SwingUtilities.replaceUIActionMap(this.editor, actionMap);
        }
    }
}

