/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import javax.swing.ActionMap;
import javax.swing.JTextArea;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BoxView;
import javax.swing.text.CompositeView;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.JTextComponent;
import javax.swing.text.ParagraphView;
import javax.swing.text.PlainView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaTextComponentSupport;
import org.violetlib.aqua.AquaTextComponentUIDelegate;

public class AquaTextAreaUIDelegate
implements AquaTextComponentUIDelegate {
    @Override
    @NotNull
    public String getPropertyPrefix() {
        return "TextArea";
    }

    @Override
    public void install(@NotNull JTextComponent jTextComponent) {
    }

    @Override
    public void uninstall(@NotNull JTextComponent jTextComponent) {
    }

    @Override
    public boolean propertyChange(@NotNull PropertyChangeEvent propertyChangeEvent) {
        JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getSource();
        if (propertyChangeEvent.getPropertyName().equals("lineWrap") || propertyChangeEvent.getPropertyName().equals("wrapStyleWord") || propertyChangeEvent.getPropertyName().equals("tabSize")) {
            return true;
        }
        if ("editable".equals(propertyChangeEvent.getPropertyName())) {
            AquaTextComponentSupport.updateFocusTraversalKeys(jTextComponent, null);
        }
        return false;
    }

    @Override
    @Nullable
    public ActionMap getActionMap(@NotNull JTextComponent jTextComponent) {
        return null;
    }

    @Override
    @Nullable
    public EditorKit getEditorKit(@NotNull JTextComponent jTextComponent) {
        return null;
    }

    @Override
    @Nullable
    public View create(@NotNull JTextComponent jTextComponent, @NotNull Element element) {
        Document document = element.getDocument();
        Object object = document.getProperty("i18n");
        if (object != null && object.equals(Boolean.TRUE)) {
            return this.createI18N(element);
        }
        if (jTextComponent instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)jTextComponent;
            View view = jTextArea.getLineWrap() ? new WrappedPlainView(element, jTextArea.getWrapStyleWord()) : new PlainView(element);
            return view;
        }
        return null;
    }

    private View createI18N(Element element) {
        String string = element.getName();
        if (string != null) {
            if (string.equals("content")) {
                return new PlainParagraph(element);
            }
            if (string.equals("paragraph")) {
                return new BoxView(element, 1);
            }
        }
        return null;
    }

    @Override
    public int getBaseline(@NotNull JTextComponent jTextComponent, int n, int n2) {
        Object object = jTextComponent.getDocument().getProperty("i18n");
        Insets insets = jTextComponent.getInsets();
        if (Boolean.TRUE.equals(object)) {
            View view = AquaTextComponentSupport.getRootView(jTextComponent);
            if (view.getViewCount() > 0) {
                n2 = n2 - insets.top - insets.bottom;
                int n3 = insets.top;
                int n4 = AquaTextComponentSupport.getBaseline(view.getView(0), n - insets.left - insets.right, n2);
                if (n4 < 0) {
                    return -1;
                }
                return n3 + n4;
            }
            return -1;
        }
        FontMetrics fontMetrics = jTextComponent.getFontMetrics(jTextComponent.getFont());
        return insets.top + fontMetrics.getAscent();
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JTextComponent jTextComponent) {
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    static class PlainParagraph
    extends ParagraphView {
        PlainParagraph(Element element) {
            super(element);
            this.layoutPool = new LogicalView(element);
            this.layoutPool.setParent(this);
        }

        @Override
        public void setParent(View view) {
            super.setParent(view);
            if (view != null) {
                this.setPropertiesFromAttributes();
            }
        }

        @Override
        protected void setPropertiesFromAttributes() {
            Container container = this.getContainer();
            if (container != null && !container.getComponentOrientation().isLeftToRight()) {
                this.setJustification(2);
            } else {
                this.setJustification(0);
            }
        }

        @Override
        public int getFlowSpan(int n) {
            JTextArea jTextArea;
            Container container = this.getContainer();
            if (container instanceof JTextArea && !(jTextArea = (JTextArea)container).getLineWrap()) {
                return Integer.MAX_VALUE;
            }
            return super.getFlowSpan(n);
        }

        @Override
        protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            SizeRequirements sizeRequirements2 = super.calculateMinorAxisRequirements(n, sizeRequirements);
            Container container = this.getContainer();
            if (container instanceof JTextArea) {
                JTextArea jTextArea = (JTextArea)container;
                if (!jTextArea.getLineWrap()) {
                    sizeRequirements2.minimum = sizeRequirements2.preferred;
                } else {
                    sizeRequirements2.minimum = 0;
                    sizeRequirements2.preferred = this.getWidth();
                    if (sizeRequirements2.preferred == Integer.MAX_VALUE) {
                        sizeRequirements2.preferred = 100;
                    }
                }
            }
            return sizeRequirements2;
        }

        @Override
        public void setSize(float f, float f2) {
            if ((int)f != this.getWidth()) {
                this.preferenceChanged(null, true, true);
            }
            super.setSize(f, f2);
        }

        static class LogicalView
        extends CompositeView {
            LogicalView(Element element) {
                super(element);
            }

            @Override
            protected int getViewIndexAtPosition(int n) {
                Element element = this.getElement();
                if (element.getElementCount() > 0) {
                    return element.getElementIndex(n);
                }
                return 0;
            }

            @Override
            protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
                return false;
            }

            @Override
            protected void loadChildren(ViewFactory viewFactory) {
                Element element = this.getElement();
                if (element.getElementCount() > 0) {
                    super.loadChildren(viewFactory);
                } else {
                    GlyphView glyphView = new GlyphView(element);
                    this.append(glyphView);
                }
            }

            @Override
            public float getPreferredSpan(int n) {
                if (this.getViewCount() != 1) {
                    throw new Error("One child view is assumed.");
                }
                View view = this.getView(0);
                return view.getPreferredSpan(n);
            }

            @Override
            protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
                view.setParent(this);
                super.forwardUpdateToView(view, documentEvent, shape, viewFactory);
            }

            @Override
            public void paint(Graphics graphics, Shape shape) {
            }

            @Override
            protected boolean isBefore(int n, int n2, Rectangle rectangle) {
                return false;
            }

            @Override
            protected boolean isAfter(int n, int n2, Rectangle rectangle) {
                return false;
            }

            @Override
            protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
                return null;
            }

            @Override
            protected void childAllocation(int n, Rectangle rectangle) {
            }
        }
    }
}

