/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import org.violetlib.aqua.AquaBorder;

public class AquaFocusHandler
implements FocusListener,
PropertyChangeListener {
    private boolean wasTemporary = false;
    private boolean repaintBorder = false;
    public static final String FRAME_ACTIVE_PROPERTY = "Frame.active";
    public static final String HAS_FOCUS_DELEGATE_KEY = "Component.hasFocusDelegate";
    public static final String QUAQUA_HAS_FOCUS_DELEGATE_KEY = "Quaqua.Component.cellRendererFor";
    static final PropertyChangeListener REPAINT_LISTENER = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object instanceof JComponent) {
                ((JComponent)object).repaint();
            }
        }
    };

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!this.wasTemporary || this.repaintBorder) {
            AquaBorder.repaintBorder((JComponent)focusEvent.getSource());
            this.repaintBorder = false;
        }
        this.wasTemporary = false;
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.wasTemporary = focusEvent.isTemporary();
        if (!this.wasTemporary) {
            AquaBorder.repaintBorder((JComponent)focusEvent.getSource());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!FRAME_ACTIVE_PROPERTY.equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
            this.repaintBorder = true;
        } else if (this.wasTemporary) {
            AquaBorder.repaintBorder((JComponent)propertyChangeEvent.getSource());
        }
    }

    public static boolean hasFocus(Component component) {
        if (!component.isEnabled()) {
            return false;
        }
        JComponent jComponent = null;
        if (component instanceof JComponent) {
            jComponent = (JComponent)component;
        }
        if (jComponent != null && !AquaFocusHandler.isActive(jComponent)) {
            return false;
        }
        if (component.hasFocus()) {
            return true;
        }
        if (jComponent != null) {
            Object object = jComponent.getClientProperty(HAS_FOCUS_DELEGATE_KEY);
            if (object == null) {
                object = jComponent.getClientProperty(QUAQUA_HAS_FOCUS_DELEGATE_KEY);
            }
            if (object instanceof Component) {
                Component component2 = (Component)object;
                return component2.hasFocus();
            }
        }
        return false;
    }

    public static void updateComponentTreeUIActivation(Component component, boolean bl) {
        if (component instanceof JInternalFrame) {
            boolean bl2 = bl = bl && ((JInternalFrame)component).isSelected();
        }
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty(FRAME_ACTIVE_PROPERTY, bl);
        }
        Component[] componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray == null) {
            return;
        }
        for (Component component2 : componentArray) {
            AquaFocusHandler.updateComponentTreeUIActivation(component2, bl);
        }
    }

    public static boolean isActive(JComponent jComponent) {
        if (jComponent == null) {
            return true;
        }
        Object object = jComponent.getClientProperty(FRAME_ACTIVE_PROPERTY);
        return !Boolean.FALSE.equals(object);
    }

    protected static void install(JComponent jComponent) {
        jComponent.addPropertyChangeListener(FRAME_ACTIVE_PROPERTY, REPAINT_LISTENER);
    }

    protected static void uninstall(JComponent jComponent) {
        jComponent.removePropertyChangeListener(FRAME_ACTIVE_PROPERTY, REPAINT_LISTENER);
    }

    public static Component getFocusableComponent(Component component) {
        if (component instanceof Container) {
            Component component2;
            Object object;
            Object object2;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (object2 = ((FocusTraversalPolicy)(object = container.getFocusTraversalPolicy())).getDefaultComponent(container)) != null) {
                return object2;
            }
            object = container.getFocusCycleRootAncestor();
            if (object != null && (component2 = ((FocusTraversalPolicy)(object2 = ((Container)object).getFocusTraversalPolicy())).getComponentAfter((Container)object, container)) != null && SwingUtilities.isDescendingFrom(component2, container)) {
                return component2;
            }
        }
        if (component.isFocusable()) {
            return component;
        }
        return null;
    }
}

